/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.safety;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Whitelist {
    private Set<TagName> tagNames = new HashSet<TagName>();
    private Map<TagName, Set<AttributeKey>> attributes = new HashMap<TagName, Set<AttributeKey>>();
    private Map<TagName, Map<AttributeKey, AttributeValue>> enforcedAttributes = new HashMap<TagName, Map<AttributeKey, AttributeValue>>();
    private Map<TagName, Map<AttributeKey, Set<Protocol>>> protocols = new HashMap<TagName, Map<AttributeKey, Set<Protocol>>>();
    private boolean preserveRelativeLinks = false;

    public static Whitelist none() {
        return new Whitelist();
    }

    public static Whitelist simpleText() {
        return new Whitelist().addTags("b", "em", "i", "strong", "u");
    }

    public static Whitelist basic() {
        return new Whitelist().addTags("a", "b", "blockquote", "br", "cite", "code", "dd", "dl", "dt", "em", "i", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "u", "ul").addAttributes("a", "href").addAttributes("blockquote", "cite").addAttributes("q", "cite").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addEnforcedAttribute("a", "rel", "nofollow");
    }

    public static Whitelist basicWithImages() {
        return Whitelist.basic().addTags("img").addAttributes("img", "align", "alt", "height", "src", "title", "width").addProtocols("img", "src", "http", "https");
    }

    public static Whitelist relaxed() {
        return new Whitelist().addTags("a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul").addAttributes("a", "href", "title").addAttributes("blockquote", "cite").addAttributes("col", "span", "width").addAttributes("colgroup", "span", "width").addAttributes("img", "align", "alt", "height", "src", "title", "width").addAttributes("ol", "start", "type").addAttributes("q", "cite").addAttributes("table", "summary", "width").addAttributes("td", "abbr", "axis", "colspan", "rowspan", "width").addAttributes("th", "abbr", "axis", "colspan", "rowspan", "scope", "width").addAttributes("ul", "type").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addProtocols("img", "src", "http", "https").addProtocols("q", "cite", "http", "https");
    }

    public Whitelist addTags(String ... stringArray) {
        Validate.notNull(stringArray);
        for (String string : stringArray) {
            Validate.notEmpty(string);
            this.tagNames.add(TagName.valueOf(string));
        }
        return this;
    }

    public Whitelist removeTags(String ... stringArray) {
        Validate.notNull(stringArray);
        for (String string : stringArray) {
            Validate.notEmpty(string);
            TagName tagName = TagName.valueOf(string);
            if (!this.tagNames.remove(tagName)) continue;
            this.attributes.remove(tagName);
            this.enforcedAttributes.remove(tagName);
            this.protocols.remove(tagName);
        }
        return this;
    }

    public Whitelist addAttributes(String string, String ... stringArray) {
        Validate.notEmpty(string);
        Validate.notNull(stringArray);
        Validate.isTrue(stringArray.length > 0, "No attributes supplied.");
        TagName tagName = TagName.valueOf(string);
        if (!this.tagNames.contains(tagName)) {
            this.tagNames.add(tagName);
        }
        HashSet<AttributeKey> hashSet = new HashSet<AttributeKey>();
        for (String string2 : stringArray) {
            Validate.notEmpty(string2);
            hashSet.add(AttributeKey.valueOf(string2));
        }
        if (this.attributes.containsKey(tagName)) {
            Set<AttributeKey> set = this.attributes.get(tagName);
            set.addAll(hashSet);
        } else {
            this.attributes.put(tagName, hashSet);
        }
        return this;
    }

    public Whitelist removeAttributes(String string, String ... stringArray) {
        Validate.notEmpty(string);
        Validate.notNull(stringArray);
        Validate.isTrue(stringArray.length > 0, "No attributes supplied.");
        TagName tagName = TagName.valueOf(string);
        HashSet<AttributeKey> hashSet = new HashSet<AttributeKey>();
        for (String string2 : stringArray) {
            Validate.notEmpty(string2);
            hashSet.add(AttributeKey.valueOf(string2));
        }
        if (this.tagNames.contains(tagName) && this.attributes.containsKey(tagName)) {
            Set<AttributeKey> set = this.attributes.get(tagName);
            set.removeAll(hashSet);
            if (set.isEmpty()) {
                this.attributes.remove(tagName);
            }
        }
        if (string.equals(":all")) {
            for (TagName tagName2 : this.attributes.keySet()) {
                Set<AttributeKey> set = this.attributes.get(tagName2);
                set.removeAll(hashSet);
                if (!set.isEmpty()) continue;
                this.attributes.remove(tagName2);
            }
        }
        return this;
    }

    public Whitelist addEnforcedAttribute(String string, String string2, String string3) {
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        Validate.notEmpty(string3);
        TagName tagName = TagName.valueOf(string);
        if (!this.tagNames.contains(tagName)) {
            this.tagNames.add(tagName);
        }
        AttributeKey attributeKey = AttributeKey.valueOf(string2);
        AttributeValue attributeValue = AttributeValue.valueOf(string3);
        if (this.enforcedAttributes.containsKey(tagName)) {
            this.enforcedAttributes.get(tagName).put(attributeKey, attributeValue);
        } else {
            HashMap<AttributeKey, AttributeValue> hashMap = new HashMap<AttributeKey, AttributeValue>();
            hashMap.put(attributeKey, attributeValue);
            this.enforcedAttributes.put(tagName, hashMap);
        }
        return this;
    }

    public Whitelist removeEnforcedAttribute(String string, String string2) {
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        TagName tagName = TagName.valueOf(string);
        if (this.tagNames.contains(tagName) && this.enforcedAttributes.containsKey(tagName)) {
            AttributeKey attributeKey = AttributeKey.valueOf(string2);
            Map<AttributeKey, AttributeValue> map = this.enforcedAttributes.get(tagName);
            map.remove(attributeKey);
            if (map.isEmpty()) {
                this.enforcedAttributes.remove(tagName);
            }
        }
        return this;
    }

    public Whitelist preserveRelativeLinks(boolean bl) {
        this.preserveRelativeLinks = bl;
        return this;
    }

    public Whitelist addProtocols(String string, String string2, String ... stringArray) {
        Set<Protocol> set;
        Map<Object, Object> map;
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        Validate.notNull(stringArray);
        TagName tagName = TagName.valueOf(string);
        AttributeKey attributeKey = AttributeKey.valueOf(string2);
        if (this.protocols.containsKey(tagName)) {
            map = this.protocols.get(tagName);
        } else {
            map = new HashMap();
            this.protocols.put(tagName, map);
        }
        if (map.containsKey(attributeKey)) {
            set = (Set)map.get(attributeKey);
        } else {
            set = new HashSet();
            map.put(attributeKey, set);
        }
        for (String string3 : stringArray) {
            Validate.notEmpty(string3);
            Protocol protocol = Protocol.valueOf(string3);
            set.add(protocol);
        }
        return this;
    }

    public Whitelist removeProtocols(String string, String string2, String ... stringArray) {
        Map<AttributeKey, Set<Protocol>> map;
        Validate.notEmpty(string);
        Validate.notEmpty(string2);
        Validate.notNull(stringArray);
        TagName tagName = TagName.valueOf(string);
        AttributeKey attributeKey = AttributeKey.valueOf(string2);
        if (this.protocols.containsKey(tagName) && (map = this.protocols.get(tagName)).containsKey(attributeKey)) {
            Set<Protocol> set = map.get(attributeKey);
            for (String string3 : stringArray) {
                Validate.notEmpty(string3);
                Protocol protocol = Protocol.valueOf(string3);
                set.remove(protocol);
            }
            if (set.isEmpty()) {
                map.remove(attributeKey);
                if (map.isEmpty()) {
                    this.protocols.remove(tagName);
                }
            }
        }
        return this;
    }

    protected boolean isSafeTag(String string) {
        return this.tagNames.contains(TagName.valueOf(string));
    }

    protected boolean isSafeAttribute(String string, Element element, Attribute attribute) {
        TagName tagName = TagName.valueOf(string);
        AttributeKey attributeKey = AttributeKey.valueOf(attribute.getKey());
        if (this.attributes.containsKey(tagName) && this.attributes.get(tagName).contains(attributeKey)) {
            if (this.protocols.containsKey(tagName)) {
                Map<AttributeKey, Set<Protocol>> map = this.protocols.get(tagName);
                return !map.containsKey(attributeKey) || this.testValidProtocol(element, attribute, map.get(attributeKey));
            }
            return true;
        }
        return !string.equals(":all") && this.isSafeAttribute(":all", element, attribute);
    }

    private boolean testValidProtocol(Element element, Attribute attribute, Set<Protocol> set) {
        String string = element.absUrl(attribute.getKey());
        if (string.length() == 0) {
            string = attribute.getValue();
        }
        if (!this.preserveRelativeLinks) {
            attribute.setValue(string);
        }
        for (Protocol protocol : set) {
            String string2 = protocol.toString();
            if (string2.equals("#")) {
                if (!this.isValidAnchor(string)) continue;
                return true;
            }
            string2 = string2 + ":";
            if (!string.toLowerCase().startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAnchor(String string) {
        return string.startsWith("#") && !string.matches(".*\\s.*");
    }

    Attributes getEnforcedAttributes(String string) {
        Attributes attributes = new Attributes();
        TagName tagName = TagName.valueOf(string);
        if (this.enforcedAttributes.containsKey(tagName)) {
            Map<AttributeKey, AttributeValue> map = this.enforcedAttributes.get(tagName);
            for (Map.Entry<AttributeKey, AttributeValue> entry : map.entrySet()) {
                attributes.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return attributes;
    }

    static abstract class TypedValue {
        private String value;

        TypedValue(String string) {
            Validate.notNull(string);
            this.value = string;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.value == null ? 0 : this.value.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TypedValue typedValue = (TypedValue)object;
            return !(this.value == null ? typedValue.value != null : !this.value.equals(typedValue.value));
        }

        public String toString() {
            return this.value;
        }
    }

    static class Protocol
    extends TypedValue {
        Protocol(String string) {
            super(string);
        }

        static Protocol valueOf(String string) {
            return new Protocol(string);
        }
    }

    static class AttributeValue
    extends TypedValue {
        AttributeValue(String string) {
            super(string);
        }

        static AttributeValue valueOf(String string) {
            return new AttributeValue(string);
        }
    }

    static class AttributeKey
    extends TypedValue {
        AttributeKey(String string) {
            super(string);
        }

        static AttributeKey valueOf(String string) {
            return new AttributeKey(string);
        }
    }

    static class TagName
    extends TypedValue {
        TagName(String string) {
            super(string);
        }

        static TagName valueOf(String string) {
            return new TagName(string);
        }
    }
}

