/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTreeBuilder
extends TreeBuilder {
    @Override
    protected void initialiseParse(String string, String string2, ParseErrorList parseErrorList) {
        super.initialiseParse(string, string2, parseErrorList);
        this.stack.add(this.doc);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
    }

    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name());
        Element element = new Element(tag, this.baseUri, startTag.attributes);
        this.insertNode(element);
        if (startTag.isSelfClosing()) {
            this.tokeniser.acknowledgeSelfClosingFlag();
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(element);
        }
        return element;
    }

    void insert(Token.Comment comment) {
        String string;
        Comment comment2 = new Comment(comment.getData(), this.baseUri);
        Node node = comment2;
        if (comment.bogus && (string = comment2.getData()).length() > 1 && (string.startsWith("!") || string.startsWith("?"))) {
            Document document = Jsoup.parse("<" + string.substring(1, string.length() - 1) + ">", this.baseUri, Parser.xmlParser());
            Element element = document.child(0);
            node = new XmlDeclaration(element.tagName(), comment2.baseUri(), string.startsWith("!"));
            node.attributes().addAll(element.attributes());
        }
        this.insertNode(node);
    }

    void insert(Token.Character character) {
        TextNode textNode = new TextNode(character.getData(), this.baseUri);
        this.insertNode(textNode);
    }

    void insert(Token.Doctype doctype) {
        DocumentType documentType = new DocumentType(doctype.getName(), doctype.getPublicIdentifier(), doctype.getSystemIdentifier(), this.baseUri);
        this.insertNode(documentType);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element element;
        int n;
        String string = endTag.name();
        Element element2 = null;
        for (n = this.stack.size() - 1; n >= 0; --n) {
            element = (Element)this.stack.get(n);
            if (!element.nodeName().equals(string)) continue;
            element2 = element;
            break;
        }
        if (element2 == null) {
            return;
        }
        for (n = this.stack.size() - 1; n >= 0; --n) {
            element = (Element)this.stack.get(n);
            this.stack.remove(n);
            if (element == element2) break;
        }
    }

    List<Node> parseFragment(String string, String string2, ParseErrorList parseErrorList) {
        this.initialiseParse(string, string2, parseErrorList);
        this.runParser();
        return this.doc.childNodes();
    }
}

