/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();

    TreeBuilder() {
    }

    protected void initialiseParse(String string, String string2, ParseErrorList parseErrorList) {
        Validate.notNull(string, "String input must not be null");
        Validate.notNull(string2, "BaseURI must not be null");
        this.doc = new Document(string2);
        this.reader = new CharacterReader(string);
        this.errors = parseErrorList;
        this.tokeniser = new Tokeniser(this.reader, parseErrorList);
        this.stack = new ArrayList(32);
        this.baseUri = string2;
    }

    Document parse(String string, String string2) {
        return this.parse(string, string2, ParseErrorList.noTracking());
    }

    Document parse(String string, String string2, ParseErrorList parseErrorList) {
        this.initialiseParse(string, string2, parseErrorList);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
            token.reset();
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected boolean processStartTag(String string) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().name(string));
        }
        return this.process(this.start.reset().name(string));
    }

    public boolean processStartTag(String string, Attributes attributes) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().nameAttr(string, attributes));
        }
        this.start.reset();
        this.start.nameAttr(string, attributes);
        return this.process(this.start);
    }

    protected boolean processEndTag(String string) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(string));
        }
        return this.process(this.end.reset().name(string));
    }

    protected Element currentElement() {
        int n = this.stack.size();
        return n > 0 ? this.stack.get(n - 1) : null;
    }
}

