/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Arrays;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;

final class Tokeniser {
    static final char replacementChar = '\ufffd';
    private static final char[] notCharRefCharsSorted = new char[]{'\t', '\n', '\r', '\f', ' ', '<', '&'};
    private CharacterReader reader;
    private ParseErrorList errors;
    private TokeniserState state = TokeniserState.Data;
    private Token emitPending;
    private boolean isEmitPending = false;
    private String charsString = null;
    private StringBuilder charsBuilder = new StringBuilder(1024);
    StringBuilder dataBuffer = new StringBuilder(1024);
    Token.Tag tagPending;
    Token.StartTag startPending = new Token.StartTag();
    Token.EndTag endPending = new Token.EndTag();
    Token.Character charPending = new Token.Character();
    Token.Doctype doctypePending = new Token.Doctype();
    Token.Comment commentPending = new Token.Comment();
    private String lastStartTag;
    private boolean selfClosingFlagAcknowledged = true;
    private final char[] charRefHolder = new char[1];

    Tokeniser(CharacterReader characterReader, ParseErrorList parseErrorList) {
        this.reader = characterReader;
        this.errors = parseErrorList;
    }

    Token read() {
        if (!this.selfClosingFlagAcknowledged) {
            this.error("Self closing flag not acknowledged");
            this.selfClosingFlagAcknowledged = true;
        }
        while (!this.isEmitPending) {
            this.state.read(this, this.reader);
        }
        if (this.charsBuilder.length() > 0) {
            String string = this.charsBuilder.toString();
            this.charsBuilder.delete(0, this.charsBuilder.length());
            this.charsString = null;
            return this.charPending.data(string);
        }
        if (this.charsString != null) {
            Token.Character character = this.charPending.data(this.charsString);
            this.charsString = null;
            return character;
        }
        this.isEmitPending = false;
        return this.emitPending;
    }

    void emit(Token token) {
        Validate.isFalse(this.isEmitPending, "There is an unread token pending!");
        this.emitPending = token;
        this.isEmitPending = true;
        if (token.type == Token.TokenType.StartTag) {
            Token.StartTag startTag = (Token.StartTag)token;
            this.lastStartTag = startTag.tagName;
            if (startTag.selfClosing) {
                this.selfClosingFlagAcknowledged = false;
            }
        } else if (token.type == Token.TokenType.EndTag) {
            Token.EndTag endTag = (Token.EndTag)token;
            if (endTag.attributes != null) {
                this.error("Attributes incorrectly present on end tag");
            }
        }
    }

    void emit(String string) {
        if (this.charsString == null) {
            this.charsString = string;
        } else {
            if (this.charsBuilder.length() == 0) {
                this.charsBuilder.append(this.charsString);
            }
            this.charsBuilder.append(string);
        }
    }

    void emit(char[] cArray) {
        this.emit(String.valueOf(cArray));
    }

    void emit(char c) {
        this.emit(String.valueOf(c));
    }

    TokeniserState getState() {
        return this.state;
    }

    void transition(TokeniserState tokeniserState) {
        this.state = tokeniserState;
    }

    void advanceTransition(TokeniserState tokeniserState) {
        this.reader.advance();
        this.state = tokeniserState;
    }

    void acknowledgeSelfClosingFlag() {
        this.selfClosingFlagAcknowledged = true;
    }

    char[] consumeCharacterReference(Character c, boolean bl) {
        boolean bl2;
        if (this.reader.isEmpty()) {
            return null;
        }
        if (c != null && c.charValue() == this.reader.current()) {
            return null;
        }
        if (this.reader.matchesAnySorted(notCharRefCharsSorted)) {
            return null;
        }
        char[] cArray = this.charRefHolder;
        this.reader.mark();
        if (this.reader.matchConsume("#")) {
            String string;
            boolean bl3 = this.reader.matchConsumeIgnoreCase("X");
            String string2 = string = bl3 ? this.reader.consumeHexSequence() : this.reader.consumeDigitSequence();
            if (string.length() == 0) {
                this.characterReferenceError("numeric reference with no numerals");
                this.reader.rewindToMark();
                return null;
            }
            if (!this.reader.matchConsume(";")) {
                this.characterReferenceError("missing semicolon");
            }
            int n = -1;
            try {
                int n2 = bl3 ? 16 : 10;
                n = Integer.valueOf(string, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == -1 || n >= 55296 && n <= 57343 || n > 0x10FFFF) {
                this.characterReferenceError("character outside of valid range");
                cArray[0] = 65533;
                return cArray;
            }
            if (n < 65536) {
                cArray[0] = (char)n;
                return cArray;
            }
            return Character.toChars(n);
        }
        String string = this.reader.consumeLetterThenDigitSequence();
        boolean bl4 = this.reader.matches(';');
        boolean bl5 = bl2 = Entities.isBaseNamedEntity(string) || Entities.isNamedEntity(string) && bl4;
        if (!bl2) {
            this.reader.rewindToMark();
            if (bl4) {
                this.characterReferenceError(String.format("invalid named referenece '%s'", string));
            }
            return null;
        }
        if (bl && (this.reader.matchesLetter() || this.reader.matchesDigit() || this.reader.matchesAny('=', '-', '_'))) {
            this.reader.rewindToMark();
            return null;
        }
        if (!this.reader.matchConsume(";")) {
            this.characterReferenceError("missing semicolon");
        }
        cArray[0] = Entities.getCharacterByName(string).charValue();
        return cArray;
    }

    Token.Tag createTagPending(boolean bl) {
        this.tagPending = bl ? this.startPending.reset() : this.endPending.reset();
        return this.tagPending;
    }

    void emitTagPending() {
        this.tagPending.finaliseTag();
        this.emit(this.tagPending);
    }

    void createCommentPending() {
        this.commentPending.reset();
    }

    void emitCommentPending() {
        this.emit(this.commentPending);
    }

    void createDoctypePending() {
        this.doctypePending.reset();
    }

    void emitDoctypePending() {
        this.emit(this.doctypePending);
    }

    void createTempBuffer() {
        Token.reset(this.dataBuffer);
    }

    boolean isAppropriateEndTagToken() {
        return this.lastStartTag != null && this.tagPending.tagName.equals(this.lastStartTag);
    }

    String appropriateEndTagName() {
        if (this.lastStartTag == null) {
            return null;
        }
        return this.lastStartTag;
    }

    void error(TokeniserState tokeniserState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected character '%s' in input state [%s]", new Object[]{Character.valueOf(this.reader.current()), tokeniserState}));
        }
    }

    void eofError(TokeniserState tokeniserState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpectedly reached end of file (EOF) in input state [%s]", new Object[]{tokeniserState}));
        }
    }

    private void characterReferenceError(String string) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Invalid character reference: %s", string));
        }
    }

    private void error(String string) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), string));
        }
    }

    boolean currentNodeInHtmlNS() {
        return true;
    }

    String unescapeEntities(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.reader.isEmpty()) {
            stringBuilder.append(this.reader.consumeTo('&'));
            if (!this.reader.matches('&')) continue;
            this.reader.consume();
            char[] cArray = this.consumeCharacterReference(null, bl);
            if (cArray == null || cArray.length == 0) {
                stringBuilder.append('&');
                continue;
            }
            stringBuilder.append(cArray);
        }
        return stringBuilder.toString();
    }

    static {
        Arrays.sort(notCharRefCharsSorted);
    }
}

