/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.List;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Tokeniser;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.parser.XmlTreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int DEFAULT_MAX_ERRORS = 0;
    private TreeBuilder treeBuilder;
    private int maxErrors = 0;
    private ParseErrorList errors;

    public Parser(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
    }

    public Document parseInput(String string, String string2) {
        this.errors = this.isTrackErrors() ? ParseErrorList.tracking(this.maxErrors) : ParseErrorList.noTracking();
        return this.treeBuilder.parse(string, string2, this.errors);
    }

    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public Parser setTreeBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        return this;
    }

    public boolean isTrackErrors() {
        return this.maxErrors > 0;
    }

    public Parser setTrackErrors(int n) {
        this.maxErrors = n;
        return this;
    }

    public List<ParseError> getErrors() {
        return this.errors;
    }

    public static Document parse(String string, String string2) {
        HtmlTreeBuilder htmlTreeBuilder = new HtmlTreeBuilder();
        return ((TreeBuilder)htmlTreeBuilder).parse(string, string2, ParseErrorList.noTracking());
    }

    public static List<Node> parseFragment(String string, Element element, String string2) {
        HtmlTreeBuilder htmlTreeBuilder = new HtmlTreeBuilder();
        return htmlTreeBuilder.parseFragment(string, element, string2, ParseErrorList.noTracking());
    }

    public static List<Node> parseXmlFragment(String string, String string2) {
        XmlTreeBuilder xmlTreeBuilder = new XmlTreeBuilder();
        return xmlTreeBuilder.parseFragment(string, string2, ParseErrorList.noTracking());
    }

    public static Document parseBodyFragment(String string, String string2) {
        Document document = Document.createShell(string2);
        Element element = document.body();
        List<Node> list = Parser.parseFragment(string, element, string2);
        Node[] nodeArray = list.toArray(new Node[list.size()]);
        for (int i = nodeArray.length - 1; i > 0; --i) {
            nodeArray[i].remove();
        }
        for (Node node : nodeArray) {
            element.appendChild(node);
        }
        return document;
    }

    public static String unescapeEntities(String string, boolean bl) {
        Tokeniser tokeniser = new Tokeniser(new CharacterReader(string), ParseErrorList.noTracking());
        return tokeniser.unescapeEntities(bl);
    }

    public static Document parseBodyFragmentRelaxed(String string, String string2) {
        return Parser.parse(string, string2);
    }

    public static Parser htmlParser() {
        return new Parser(new HtmlTreeBuilder());
    }

    public static Parser xmlParser() {
        return new Parser(new XmlTreeBuilder());
    }
}

