/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.Node;
import org.jsoup.parser.HtmlTreeBuilder;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum HtmlTreeBuilderState {
    Initial{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else if (token.isDoctype()) {
                Token.Doctype doctype = token.asDoctype();
                DocumentType documentType = new DocumentType(doctype.getName(), doctype.getPublicIdentifier(), doctype.getSystemIdentifier(), htmlTreeBuilder.getBaseUri());
                htmlTreeBuilder.getDocument().appendChild(documentType);
                if (doctype.isForceQuirks()) {
                    htmlTreeBuilder.getDocument().quirksMode(Document.QuirksMode.quirks);
                }
                htmlTreeBuilder.transition(BeforeHtml);
            } else {
                htmlTreeBuilder.transition(BeforeHtml);
                return htmlTreeBuilder.process(token);
            }
            return true;
        }
    }
    ,
    BeforeHtml{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (HtmlTreeBuilderState.isWhitespace(token)) {
                    return true;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    htmlTreeBuilder.insert(token.asStartTag());
                    htmlTreeBuilder.transition(BeforeHead);
                } else {
                    if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "head", "body", "html", "br")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    if (token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.insertStartTag("html");
            htmlTreeBuilder.transition(BeforeHead);
            return htmlTreeBuilder.process(token);
        }
    }
    ,
    BeforeHead{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return InBody.process(token, htmlTreeBuilder);
                }
                if (token.isStartTag() && token.asStartTag().name().equals("head")) {
                    Element element = htmlTreeBuilder.insert(token.asStartTag());
                    htmlTreeBuilder.setHeadElement(element);
                    htmlTreeBuilder.transition(InHead);
                } else {
                    if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "head", "body", "html", "br")) {
                        htmlTreeBuilder.processStartTag("head");
                        return htmlTreeBuilder.process(token);
                    }
                    if (token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.processStartTag("head");
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InHead{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            switch (token.type) {
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("html")) {
                        return InBody.process(token, htmlTreeBuilder);
                    }
                    if (StringUtil.in(string, "base", "basefont", "bgsound", "command", "link")) {
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        if (!string.equals("base") || !element.hasAttr("href")) break;
                        htmlTreeBuilder.maybeSetBaseUri(element);
                        break;
                    }
                    if (string.equals("meta")) {
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    if (string.equals("title")) {
                        HtmlTreeBuilderState.handleRcData(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (StringUtil.in(string, "noframes", "style")) {
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("noscript")) {
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InHeadNoscript);
                        break;
                    }
                    if (string.equals("script")) {
                        htmlTreeBuilder.tokeniser.transition(TokeniserState.ScriptData);
                        htmlTreeBuilder.markInsertionMode();
                        htmlTreeBuilder.transition(Text);
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("head")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (string.equals("head")) {
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(AfterHead);
                        break;
                    }
                    if (StringUtil.in(string, "body", "html", "br")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    htmlTreeBuilder.error(this);
                    return false;
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, TreeBuilder treeBuilder) {
            treeBuilder.processEndTag("head");
            return treeBuilder.process(token);
        }
    }
    ,
    InHeadNoscript{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
            } else {
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().name().equals("noscript")) {
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(InHead);
                } else {
                    if (HtmlTreeBuilderState.isWhitespace(token) || token.isComment() || token.isStartTag() && StringUtil.in(token.asStartTag().name(), "basefont", "bgsound", "link", "meta", "noframes", "style")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (token.isEndTag() && token.asEndTag().name().equals("br")) {
                        return this.anythingElse(token, htmlTreeBuilder);
                    }
                    if (token.isStartTag() && StringUtil.in(token.asStartTag().name(), "head", "noscript") || token.isEndTag()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.error(this);
            htmlTreeBuilder.insert(new Token.Character().data(token.toString()));
            return true;
        }
    }
    ,
    AfterHead{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return true;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (string.equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (string.equals("body")) {
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.framesetOk(false);
                    htmlTreeBuilder.transition(InBody);
                    return true;
                }
                if (string.equals("frameset")) {
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InFrameset);
                    return true;
                }
                if (StringUtil.in(string, "base", "basefont", "bgsound", "link", "meta", "noframes", "script", "style", "title")) {
                    htmlTreeBuilder.error(this);
                    Element element = htmlTreeBuilder.getHeadElement();
                    htmlTreeBuilder.push(element);
                    htmlTreeBuilder.process(token, InHead);
                    htmlTreeBuilder.removeFromStack(element);
                    return true;
                }
                if (string.equals("head")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            if (!token.isEndTag()) {
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            if (StringUtil.in(token.asEndTag().name(), "body", "html")) {
                this.anythingElse(token, htmlTreeBuilder);
                return true;
            }
            htmlTreeBuilder.error(this);
            return false;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.processStartTag("body");
            htmlTreeBuilder.framesetOk(true);
            return htmlTreeBuilder.process(token);
        }
    }
    ,
    InBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    if (htmlTreeBuilder.framesetOk() && HtmlTreeBuilderState.isWhitespace(character)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(character);
                        break;
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(character);
                    htmlTreeBuilder.framesetOk(false);
                    break;
                }
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("a")) {
                        Element element;
                        if (htmlTreeBuilder.getActiveFormattingElement("a") != null) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.processEndTag("a");
                            element = htmlTreeBuilder.getFromStack("a");
                            if (element != null) {
                                htmlTreeBuilder.removeFromActiveFormattingElements(element);
                                htmlTreeBuilder.removeFromStack(element);
                            }
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.pushActiveFormattingElements(element);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartEmptyFormatters)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insertEmpty(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartPClosers)) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("span")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("li")) {
                        htmlTreeBuilder.framesetOk(false);
                        ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                        for (int i = arrayList.size() - 1; i > 0; --i) {
                            Element element = arrayList.get(i);
                            if (element.nodeName().equals("li")) {
                                htmlTreeBuilder.processEndTag("li");
                                break;
                            }
                            if (htmlTreeBuilder.isSpecial(element) && !StringUtil.inSorted(element.nodeName(), Constants.InBodyStartLiBreakers)) break;
                        }
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("html")) {
                        htmlTreeBuilder.error(this);
                        Element element = htmlTreeBuilder.getStack().get(0);
                        for (Attribute attribute : startTag.getAttributes()) {
                            if (element.hasAttr(attribute.getKey())) continue;
                            element.attributes().put(attribute);
                        }
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartToHead)) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (string.equals("body")) {
                        htmlTreeBuilder.error(this);
                        ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                        if (arrayList.size() == 1 || arrayList.size() > 2 && !arrayList.get(1).nodeName().equals("body")) {
                            return false;
                        }
                        htmlTreeBuilder.framesetOk(false);
                        Element element = arrayList.get(1);
                        for (Attribute attribute : startTag.getAttributes()) {
                            if (element.hasAttr(attribute.getKey())) continue;
                            element.attributes().put(attribute);
                        }
                        break;
                    }
                    if (string.equals("frameset")) {
                        htmlTreeBuilder.error(this);
                        ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                        if (arrayList.size() == 1 || arrayList.size() > 2 && !arrayList.get(1).nodeName().equals("body")) {
                            return false;
                        }
                        if (!htmlTreeBuilder.framesetOk()) {
                            return false;
                        }
                        Element element = arrayList.get(1);
                        if (element.parent() != null) {
                            element.remove();
                        }
                        while (arrayList.size() > 1) {
                            arrayList.remove(arrayList.size() - 1);
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InFrameset);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.Headings)) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        if (StringUtil.inSorted(htmlTreeBuilder.currentElement().nodeName(), Constants.Headings)) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.pop();
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartPreListing)) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("form")) {
                        if (htmlTreeBuilder.getFormElement() != null) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insertForm(startTag, true);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.DdDt)) {
                        htmlTreeBuilder.framesetOk(false);
                        ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                        for (int i = arrayList.size() - 1; i > 0; --i) {
                            Element element = arrayList.get(i);
                            if (StringUtil.inSorted(element.nodeName(), Constants.DdDt)) {
                                htmlTreeBuilder.processEndTag(element.nodeName());
                                break;
                            }
                            if (htmlTreeBuilder.isSpecial(element) && !StringUtil.inSorted(element.nodeName(), Constants.InBodyStartLiBreakers)) break;
                        }
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("plaintext")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.transition(TokeniserState.PLAINTEXT);
                        break;
                    }
                    if (string.equals("button")) {
                        if (htmlTreeBuilder.inButtonScope("button")) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.processEndTag("button");
                            htmlTreeBuilder.process(startTag);
                            break;
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.Formatters)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        Element element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.pushActiveFormattingElements(element);
                        break;
                    }
                    if (string.equals("nobr")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        if (htmlTreeBuilder.inScope("nobr")) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.processEndTag("nobr");
                            htmlTreeBuilder.reconstructFormattingElements();
                        }
                        Element element = htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.pushActiveFormattingElements(element);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartApplets)) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.insertMarkerToFormattingElements();
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("table")) {
                        if (htmlTreeBuilder.getDocument().quirksMode() != Document.QuirksMode.quirks && htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    if (string.equals("input")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        Element element = htmlTreeBuilder.insertEmpty(startTag);
                        if (element.attr("type").equalsIgnoreCase("hidden")) break;
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartMedia)) {
                        htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    if (string.equals("hr")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.insertEmpty(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        break;
                    }
                    if (string.equals("image")) {
                        if (htmlTreeBuilder.getFromStack("svg") == null) {
                            return htmlTreeBuilder.process(startTag.name("img"));
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("isindex")) {
                        Object object;
                        htmlTreeBuilder.error(this);
                        if (htmlTreeBuilder.getFormElement() != null) {
                            return false;
                        }
                        htmlTreeBuilder.tokeniser.acknowledgeSelfClosingFlag();
                        htmlTreeBuilder.processStartTag("form");
                        if (startTag.attributes.hasKey("action")) {
                            object = htmlTreeBuilder.getFormElement();
                            ((Element)object).attr("action", startTag.attributes.get("action"));
                        }
                        htmlTreeBuilder.processStartTag("hr");
                        htmlTreeBuilder.processStartTag("label");
                        object = startTag.attributes.hasKey("prompt") ? startTag.attributes.get("prompt") : "This is a searchable index. Enter search keywords: ";
                        htmlTreeBuilder.process(new Token.Character().data((String)object));
                        Attributes attributes = new Attributes();
                        for (Attribute attribute : startTag.attributes) {
                            if (StringUtil.inSorted(attribute.getKey(), Constants.InBodyStartInputAttribs)) continue;
                            attributes.put(attribute);
                        }
                        attributes.put("name", "isindex");
                        htmlTreeBuilder.processStartTag("input", attributes);
                        htmlTreeBuilder.processEndTag("label");
                        htmlTreeBuilder.processStartTag("hr");
                        htmlTreeBuilder.processEndTag("form");
                        break;
                    }
                    if (string.equals("textarea")) {
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rcdata);
                        htmlTreeBuilder.markInsertionMode();
                        htmlTreeBuilder.framesetOk(false);
                        htmlTreeBuilder.transition(Text);
                        break;
                    }
                    if (string.equals("xmp")) {
                        if (htmlTreeBuilder.inButtonScope("p")) {
                            htmlTreeBuilder.processEndTag("p");
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.framesetOk(false);
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("iframe")) {
                        htmlTreeBuilder.framesetOk(false);
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("noembed")) {
                        HtmlTreeBuilderState.handleRawtext(startTag, htmlTreeBuilder);
                        break;
                    }
                    if (string.equals("select")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.framesetOk(false);
                        HtmlTreeBuilderState htmlTreeBuilderState = htmlTreeBuilder.state();
                        if (htmlTreeBuilderState.equals((Object)InTable) || htmlTreeBuilderState.equals((Object)InCaption) || htmlTreeBuilderState.equals((Object)InTableBody) || htmlTreeBuilderState.equals((Object)InRow) || htmlTreeBuilderState.equals((Object)InCell)) {
                            htmlTreeBuilder.transition(InSelectInTable);
                            break;
                        }
                        htmlTreeBuilder.transition(InSelect);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartOptions)) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option")) {
                            htmlTreeBuilder.processEndTag("option");
                        }
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartRuby)) {
                        if (!htmlTreeBuilder.inScope("ruby")) break;
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals("ruby")) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.popStackToBefore("ruby");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("math")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.acknowledgeSelfClosingFlag();
                        break;
                    }
                    if (string.equals("svg")) {
                        htmlTreeBuilder.reconstructFormattingElements();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.tokeniser.acknowledgeSelfClosingFlag();
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartDrop)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.reconstructFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    break;
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (StringUtil.inSorted(string, Constants.InBodyEndAdoptionFormatters)) {
                        for (int i = 0; i < 8; ++i) {
                            Node[] nodeArray;
                            Element element;
                            Element element2 = htmlTreeBuilder.getActiveFormattingElement(string);
                            if (element2 == null) {
                                return this.anyOtherEndTag(token, htmlTreeBuilder);
                            }
                            if (!htmlTreeBuilder.onStack(element2)) {
                                htmlTreeBuilder.error(this);
                                htmlTreeBuilder.removeFromActiveFormattingElements(element2);
                                return true;
                            }
                            if (!htmlTreeBuilder.inScope(element2.nodeName())) {
                                htmlTreeBuilder.error(this);
                                return false;
                            }
                            if (htmlTreeBuilder.currentElement() != element2) {
                                htmlTreeBuilder.error(this);
                            }
                            Element element3 = null;
                            Element element4 = null;
                            boolean bl = false;
                            ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
                            int n = arrayList.size();
                            for (int j = 0; j < n && j < 64; ++j) {
                                element = arrayList.get(j);
                                if (element == element2) {
                                    element4 = arrayList.get(j - 1);
                                    bl = true;
                                    continue;
                                }
                                if (!bl || !htmlTreeBuilder.isSpecial(element)) continue;
                                element3 = element;
                                break;
                            }
                            if (element3 == null) {
                                htmlTreeBuilder.popStackToClose(element2.nodeName());
                                htmlTreeBuilder.removeFromActiveFormattingElements(element2);
                                return true;
                            }
                            Element element5 = element3;
                            element = element3;
                            for (int j = 0; j < 3; ++j) {
                                if (htmlTreeBuilder.onStack(element5)) {
                                    element5 = htmlTreeBuilder.aboveOnStack(element5);
                                }
                                if (!htmlTreeBuilder.isInActiveFormattingElements(element5)) {
                                    htmlTreeBuilder.removeFromStack(element5);
                                    continue;
                                }
                                if (element5 == element2) break;
                                nodeArray = new Element(Tag.valueOf(element5.nodeName()), htmlTreeBuilder.getBaseUri());
                                htmlTreeBuilder.replaceActiveFormattingElement(element5, (Element)nodeArray);
                                htmlTreeBuilder.replaceOnStack(element5, (Element)nodeArray);
                                element5 = nodeArray;
                                if (element == element3) {
                                    // empty if block
                                }
                                if (element.parent() != null) {
                                    element.remove();
                                }
                                element5.appendChild(element);
                                element = element5;
                            }
                            if (StringUtil.inSorted(element4.nodeName(), Constants.InBodyEndTableFosters)) {
                                if (element.parent() != null) {
                                    element.remove();
                                }
                                htmlTreeBuilder.insertInFosterParent(element);
                            } else {
                                if (element.parent() != null) {
                                    element.remove();
                                }
                                element4.appendChild(element);
                            }
                            Element element6 = new Element(element2.tag(), htmlTreeBuilder.getBaseUri());
                            element6.attributes().addAll(element2.attributes());
                            for (Node node : nodeArray = element3.childNodes().toArray(new Node[element3.childNodeSize()])) {
                                element6.appendChild(node);
                            }
                            element3.appendChild(element6);
                            htmlTreeBuilder.removeFromActiveFormattingElements(element2);
                            htmlTreeBuilder.removeFromStack(element2);
                            htmlTreeBuilder.insertOnStackAfter(element3, element6);
                        }
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyEndClosers)) {
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (string.equals("span")) {
                        return this.anyOtherEndTag(token, htmlTreeBuilder);
                    }
                    if (string.equals("li")) {
                        if (!htmlTreeBuilder.inListItemScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (string.equals("body")) {
                        if (!htmlTreeBuilder.inScope("body")) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.transition(AfterBody);
                        break;
                    }
                    if (string.equals("html")) {
                        boolean bl = htmlTreeBuilder.processEndTag("body");
                        if (!bl) break;
                        return htmlTreeBuilder.process(endTag);
                    }
                    if (string.equals("form")) {
                        FormElement formElement = htmlTreeBuilder.getFormElement();
                        htmlTreeBuilder.setFormElement(null);
                        if (formElement == null || !htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.removeFromStack(formElement);
                        break;
                    }
                    if (string.equals("p")) {
                        if (!htmlTreeBuilder.inButtonScope(string)) {
                            htmlTreeBuilder.error(this);
                            htmlTreeBuilder.processStartTag(string);
                            return htmlTreeBuilder.process(endTag);
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.DdDt)) {
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        break;
                    }
                    if (StringUtil.inSorted(string, Constants.Headings)) {
                        if (!htmlTreeBuilder.inScope(Constants.Headings)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags(string);
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(Constants.Headings);
                        break;
                    }
                    if (string.equals("sarcasm")) {
                        return this.anyOtherEndTag(token, htmlTreeBuilder);
                    }
                    if (StringUtil.inSorted(string, Constants.InBodyStartApplets)) {
                        if (htmlTreeBuilder.inScope("name")) break;
                        if (!htmlTreeBuilder.inScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.generateImpliedEndTags();
                        if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                            htmlTreeBuilder.error(this);
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        htmlTreeBuilder.clearFormattingElementsToLastMarker();
                        break;
                    }
                    if (string.equals("br")) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.processStartTag("br");
                        return false;
                    }
                    return this.anyOtherEndTag(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        boolean anyOtherEndTag(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            String string = token.asEndTag().name();
            ArrayList<Element> arrayList = htmlTreeBuilder.getStack();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Element element = arrayList.get(i);
                if (element.nodeName().equals(string)) {
                    htmlTreeBuilder.generateImpliedEndTags(string);
                    if (!string.equals(htmlTreeBuilder.currentElement().nodeName())) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    break;
                }
                if (!htmlTreeBuilder.isSpecial(element)) continue;
                htmlTreeBuilder.error(this);
                return false;
            }
            return true;
        }
    }
    ,
    Text{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isCharacter()) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else {
                if (token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                    return htmlTreeBuilder.process(token);
                }
                if (token.isEndTag()) {
                    htmlTreeBuilder.pop();
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                }
            }
            return true;
        }
    }
    ,
    InTable{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isCharacter()) {
                htmlTreeBuilder.newPendingTableCharacters();
                htmlTreeBuilder.markInsertionMode();
                htmlTreeBuilder.transition(InTableText);
                return htmlTreeBuilder.process(token);
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (string.equals("caption")) {
                    htmlTreeBuilder.clearStackToTableContext();
                    htmlTreeBuilder.insertMarkerToFormattingElements();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InCaption);
                } else if (string.equals("colgroup")) {
                    htmlTreeBuilder.clearStackToTableContext();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InColumnGroup);
                } else {
                    if (string.equals("col")) {
                        htmlTreeBuilder.processStartTag("colgroup");
                        return htmlTreeBuilder.process(token);
                    }
                    if (StringUtil.in(string, "tbody", "tfoot", "thead")) {
                        htmlTreeBuilder.clearStackToTableContext();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InTableBody);
                    } else {
                        if (StringUtil.in(string, "td", "th", "tr")) {
                            htmlTreeBuilder.processStartTag("tbody");
                            return htmlTreeBuilder.process(token);
                        }
                        if (string.equals("table")) {
                            htmlTreeBuilder.error(this);
                            boolean bl = htmlTreeBuilder.processEndTag("table");
                            if (bl) {
                                return htmlTreeBuilder.process(token);
                            }
                        } else {
                            if (StringUtil.in(string, "style", "script")) {
                                return htmlTreeBuilder.process(token, InHead);
                            }
                            if (string.equals("input")) {
                                if (!startTag.attributes.get("type").equalsIgnoreCase("hidden")) {
                                    return this.anythingElse(token, htmlTreeBuilder);
                                }
                                htmlTreeBuilder.insertEmpty(startTag);
                            } else if (string.equals("form")) {
                                htmlTreeBuilder.error(this);
                                if (htmlTreeBuilder.getFormElement() != null) {
                                    return false;
                                }
                                htmlTreeBuilder.insertForm(startTag, false);
                            } else {
                                return this.anythingElse(token, htmlTreeBuilder);
                            }
                        }
                    }
                }
                return true;
            }
            if (token.isEndTag()) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.name();
                if (string.equals("table")) {
                    if (!htmlTreeBuilder.inTableScope(string)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                } else {
                    if (StringUtil.in(string, "body", "caption", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                htmlTreeBuilder.popStackToClose("table");
                htmlTreeBuilder.resetInsertionMode();
                return true;
            }
            if (token.isEOF()) {
                if (htmlTreeBuilder.currentElement().nodeName().equals("html")) {
                    htmlTreeBuilder.error(this);
                }
                return true;
            }
            return this.anythingElse(token, htmlTreeBuilder);
        }

        boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            boolean bl;
            htmlTreeBuilder.error(this);
            if (StringUtil.in(htmlTreeBuilder.currentElement().nodeName(), "table", "tbody", "tfoot", "thead", "tr")) {
                htmlTreeBuilder.setFosterInserts(true);
                bl = htmlTreeBuilder.process(token, InBody);
                htmlTreeBuilder.setFosterInserts(false);
            } else {
                bl = htmlTreeBuilder.process(token, InBody);
            }
            return bl;
        }
    }
    ,
    InTableText{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.getPendingTableCharacters().add(character.getData());
                    break;
                }
                default: {
                    if (htmlTreeBuilder.getPendingTableCharacters().size() > 0) {
                        for (String string : htmlTreeBuilder.getPendingTableCharacters()) {
                            if (!HtmlTreeBuilderState.isWhitespace(string)) {
                                htmlTreeBuilder.error(this);
                                if (StringUtil.in(htmlTreeBuilder.currentElement().nodeName(), "table", "tbody", "tfoot", "thead", "tr")) {
                                    htmlTreeBuilder.setFosterInserts(true);
                                    htmlTreeBuilder.process(new Token.Character().data(string), InBody);
                                    htmlTreeBuilder.setFosterInserts(false);
                                    continue;
                                }
                                htmlTreeBuilder.process(new Token.Character().data(string), InBody);
                                continue;
                            }
                            htmlTreeBuilder.insert(new Token.Character().data(string));
                        }
                        htmlTreeBuilder.newPendingTableCharacters();
                    }
                    htmlTreeBuilder.transition(htmlTreeBuilder.originalState());
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InCaption{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isEndTag() && token.asEndTag().name().equals("caption")) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.name();
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.generateImpliedEndTags();
                if (!htmlTreeBuilder.currentElement().nodeName().equals("caption")) {
                    htmlTreeBuilder.error(this);
                }
                htmlTreeBuilder.popStackToClose("caption");
                htmlTreeBuilder.clearFormattingElementsToLastMarker();
                htmlTreeBuilder.transition(InTable);
            } else if (token.isStartTag() && StringUtil.in(token.asStartTag().name(), "caption", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr") || token.isEndTag() && token.asEndTag().name().equals("table")) {
                htmlTreeBuilder.error(this);
                boolean bl = htmlTreeBuilder.processEndTag("caption");
                if (bl) {
                    return htmlTreeBuilder.process(token);
                }
            } else {
                if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "body", "col", "colgroup", "html", "tbody", "td", "tfoot", "th", "thead", "tr")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                return htmlTreeBuilder.process(token, InBody);
            }
            return true;
        }
    }
    ,
    InColumnGroup{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            switch (token.type) {
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    break;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("html")) {
                        return htmlTreeBuilder.process(token, InBody);
                    }
                    if (string.equals("col")) {
                        htmlTreeBuilder.insertEmpty(startTag);
                        break;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (string.equals("colgroup")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("html")) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EOF: {
                    if (htmlTreeBuilder.currentElement().nodeName().equals("html")) {
                        return true;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, TreeBuilder treeBuilder) {
            boolean bl = treeBuilder.processEndTag("colgroup");
            if (bl) {
                return treeBuilder.process(token);
            }
            return true;
        }
    }
    ,
    InTableBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("tr")) {
                        htmlTreeBuilder.clearStackToTableBodyContext();
                        htmlTreeBuilder.insert(startTag);
                        htmlTreeBuilder.transition(InRow);
                        break;
                    }
                    if (StringUtil.in(string, "th", "td")) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.processStartTag("tr");
                        return htmlTreeBuilder.process(startTag);
                    }
                    if (StringUtil.in(string, "caption", "col", "colgroup", "tbody", "tfoot", "thead")) {
                        return this.exitTableBody(token, htmlTreeBuilder);
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (StringUtil.in(string, "tbody", "tfoot", "thead")) {
                        if (!htmlTreeBuilder.inTableScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.clearStackToTableBodyContext();
                        htmlTreeBuilder.pop();
                        htmlTreeBuilder.transition(InTable);
                        break;
                    }
                    if (string.equals("table")) {
                        return this.exitTableBody(token, htmlTreeBuilder);
                    }
                    if (StringUtil.in(string, "body", "caption", "col", "colgroup", "html", "td", "th", "tr")) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean exitTableBody(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (!(htmlTreeBuilder.inTableScope("tbody") || htmlTreeBuilder.inTableScope("thead") || htmlTreeBuilder.inScope("tfoot"))) {
                htmlTreeBuilder.error(this);
                return false;
            }
            htmlTreeBuilder.clearStackToTableBodyContext();
            htmlTreeBuilder.processEndTag(htmlTreeBuilder.currentElement().nodeName());
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InTable);
        }
    }
    ,
    InRow{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (StringUtil.in(string, "th", "td")) {
                    htmlTreeBuilder.clearStackToTableRowContext();
                    htmlTreeBuilder.insert(startTag);
                    htmlTreeBuilder.transition(InCell);
                    htmlTreeBuilder.insertMarkerToFormattingElements();
                    return true;
                }
                if (!StringUtil.in(string, "caption", "col", "colgroup", "tbody", "tfoot", "thead", "tr")) return this.anythingElse(token, htmlTreeBuilder);
                return this.handleMissingTr(token, htmlTreeBuilder);
            }
            if (!token.isEndTag()) return this.anythingElse(token, htmlTreeBuilder);
            Token.EndTag endTag = token.asEndTag();
            String string = endTag.name();
            if (string.equals("tr")) {
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.clearStackToTableRowContext();
                htmlTreeBuilder.pop();
                htmlTreeBuilder.transition(InTableBody);
                return true;
            }
            if (string.equals("table")) {
                return this.handleMissingTr(token, htmlTreeBuilder);
            }
            if (!StringUtil.in(string, "tbody", "tfoot", "thead")) {
                if (!StringUtil.in(string, "body", "caption", "col", "colgroup", "html", "td", "th")) return this.anythingElse(token, htmlTreeBuilder);
                htmlTreeBuilder.error(this);
                return false;
            }
            if (!htmlTreeBuilder.inTableScope(string)) {
                htmlTreeBuilder.error(this);
                return false;
            }
            htmlTreeBuilder.processEndTag("tr");
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InTable);
        }

        private boolean handleMissingTr(Token token, TreeBuilder treeBuilder) {
            boolean bl = treeBuilder.processEndTag("tr");
            if (bl) {
                return treeBuilder.process(token);
            }
            return false;
        }
    }
    ,
    InCell{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isEndTag()) {
                Token.EndTag endTag = token.asEndTag();
                String string = endTag.name();
                if (StringUtil.in(string, "td", "th")) {
                    if (!htmlTreeBuilder.inTableScope(string)) {
                        htmlTreeBuilder.error(this);
                        htmlTreeBuilder.transition(InRow);
                        return false;
                    }
                    htmlTreeBuilder.generateImpliedEndTags();
                    if (!htmlTreeBuilder.currentElement().nodeName().equals(string)) {
                        htmlTreeBuilder.error(this);
                    }
                    htmlTreeBuilder.popStackToClose(string);
                    htmlTreeBuilder.clearFormattingElementsToLastMarker();
                    htmlTreeBuilder.transition(InRow);
                    return true;
                }
                if (StringUtil.in(string, "body", "caption", "col", "colgroup", "html")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (!StringUtil.in(string, "table", "tbody", "tfoot", "thead", "tr")) return this.anythingElse(token, htmlTreeBuilder);
                if (!htmlTreeBuilder.inTableScope(string)) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                this.closeCell(htmlTreeBuilder);
                return htmlTreeBuilder.process(token);
            }
            if (!token.isStartTag()) return this.anythingElse(token, htmlTreeBuilder);
            if (!StringUtil.in(token.asStartTag().name(), "caption", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr")) return this.anythingElse(token, htmlTreeBuilder);
            if (!htmlTreeBuilder.inTableScope("td") && !htmlTreeBuilder.inTableScope("th")) {
                htmlTreeBuilder.error(this);
                return false;
            }
            this.closeCell(htmlTreeBuilder);
            return htmlTreeBuilder.process(token);
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return htmlTreeBuilder.process(token, InBody);
        }

        private void closeCell(HtmlTreeBuilder htmlTreeBuilder) {
            if (htmlTreeBuilder.inTableScope("td")) {
                htmlTreeBuilder.processEndTag("td");
            } else {
                htmlTreeBuilder.processEndTag("th");
            }
        }
    }
    ,
    InSelect{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            switch (token.type) {
                case Character: {
                    Token.Character character = token.asCharacter();
                    if (character.getData().equals(nullString)) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.insert(character);
                    break;
                }
                case Comment: {
                    htmlTreeBuilder.insert(token.asComment());
                    break;
                }
                case Doctype: {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                case StartTag: {
                    Token.StartTag startTag = token.asStartTag();
                    String string = startTag.name();
                    if (string.equals("html")) {
                        return htmlTreeBuilder.process(startTag, InBody);
                    }
                    if (string.equals("option")) {
                        htmlTreeBuilder.processEndTag("option");
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("optgroup")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option")) {
                            htmlTreeBuilder.processEndTag("option");
                        } else if (htmlTreeBuilder.currentElement().nodeName().equals("optgroup")) {
                            htmlTreeBuilder.processEndTag("optgroup");
                        }
                        htmlTreeBuilder.insert(startTag);
                        break;
                    }
                    if (string.equals("select")) {
                        htmlTreeBuilder.error(this);
                        return htmlTreeBuilder.processEndTag("select");
                    }
                    if (StringUtil.in(string, "input", "keygen", "textarea")) {
                        htmlTreeBuilder.error(this);
                        if (!htmlTreeBuilder.inSelectScope("select")) {
                            return false;
                        }
                        htmlTreeBuilder.processEndTag("select");
                        return htmlTreeBuilder.process(startTag);
                    }
                    if (string.equals("script")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EndTag: {
                    Token.EndTag endTag = token.asEndTag();
                    String string = endTag.name();
                    if (string.equals("optgroup")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option") && htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()) != null && htmlTreeBuilder.aboveOnStack(htmlTreeBuilder.currentElement()).nodeName().equals("optgroup")) {
                            htmlTreeBuilder.processEndTag("option");
                        }
                        if (htmlTreeBuilder.currentElement().nodeName().equals("optgroup")) {
                            htmlTreeBuilder.pop();
                            break;
                        }
                        htmlTreeBuilder.error(this);
                        break;
                    }
                    if (string.equals("option")) {
                        if (htmlTreeBuilder.currentElement().nodeName().equals("option")) {
                            htmlTreeBuilder.pop();
                            break;
                        }
                        htmlTreeBuilder.error(this);
                        break;
                    }
                    if (string.equals("select")) {
                        if (!htmlTreeBuilder.inSelectScope(string)) {
                            htmlTreeBuilder.error(this);
                            return false;
                        }
                        htmlTreeBuilder.popStackToClose(string);
                        htmlTreeBuilder.resetInsertionMode();
                        break;
                    }
                    return this.anythingElse(token, htmlTreeBuilder);
                }
                case EOF: {
                    if (htmlTreeBuilder.currentElement().nodeName().equals("html")) break;
                    htmlTreeBuilder.error(this);
                    break;
                }
                default: {
                    return this.anythingElse(token, htmlTreeBuilder);
                }
            }
            return true;
        }

        private boolean anythingElse(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            htmlTreeBuilder.error(this);
            return false;
        }
    }
    ,
    InSelectInTable{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isStartTag() && StringUtil.in(token.asStartTag().name(), "caption", "table", "tbody", "tfoot", "thead", "tr", "td", "th")) {
                htmlTreeBuilder.error(this);
                htmlTreeBuilder.processEndTag("select");
                return htmlTreeBuilder.process(token);
            }
            if (token.isEndTag() && StringUtil.in(token.asEndTag().name(), "caption", "table", "tbody", "tfoot", "thead", "tr", "td", "th")) {
                htmlTreeBuilder.error(this);
                if (htmlTreeBuilder.inTableScope(token.asEndTag().name())) {
                    htmlTreeBuilder.processEndTag("select");
                    return htmlTreeBuilder.process(token);
                }
                return false;
            }
            return htmlTreeBuilder.process(token, InSelect);
        }
    }
    ,
    AfterBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                return htmlTreeBuilder.process(token, InBody);
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().name().equals("html")) {
                    if (htmlTreeBuilder.isFragmentParsing()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                    htmlTreeBuilder.transition(AfterAfterBody);
                } else if (!token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.transition(InBody);
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    InFrameset{

        /*
         * Enabled aggressive block sorting
         */
        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
                return true;
            }
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
                return true;
            }
            if (token.isDoctype()) {
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isStartTag()) {
                Token.StartTag startTag = token.asStartTag();
                String string = startTag.name();
                if (string.equals("html")) {
                    return htmlTreeBuilder.process(startTag, InBody);
                }
                if (string.equals("frameset")) {
                    htmlTreeBuilder.insert(startTag);
                    return true;
                }
                if (string.equals("frame")) {
                    htmlTreeBuilder.insertEmpty(startTag);
                    return true;
                }
                if (string.equals("noframes")) {
                    return htmlTreeBuilder.process(startTag, InHead);
                }
                htmlTreeBuilder.error(this);
                return false;
            }
            if (token.isEndTag() && token.asEndTag().name().equals("frameset")) {
                if (htmlTreeBuilder.currentElement().nodeName().equals("html")) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                htmlTreeBuilder.pop();
                if (htmlTreeBuilder.isFragmentParsing()) return true;
                if (htmlTreeBuilder.currentElement().nodeName().equals("frameset")) return true;
                htmlTreeBuilder.transition(AfterFrameset);
                return true;
            }
            if (token.isEOF()) {
                if (htmlTreeBuilder.currentElement().nodeName().equals("html")) return true;
                htmlTreeBuilder.error(this);
                return true;
            }
            htmlTreeBuilder.error(this);
            return false;
        }
    }
    ,
    AfterFrameset{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (HtmlTreeBuilderState.isWhitespace(token)) {
                htmlTreeBuilder.insert(token.asCharacter());
            } else if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype()) {
                    htmlTreeBuilder.error(this);
                    return false;
                }
                if (token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (token.isEndTag() && token.asEndTag().name().equals("html")) {
                    htmlTreeBuilder.transition(AfterAfterFrameset);
                } else {
                    if (token.isStartTag() && token.asStartTag().name().equals("noframes")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    if (!token.isEOF()) {
                        htmlTreeBuilder.error(this);
                        return false;
                    }
                }
            }
            return true;
        }
    }
    ,
    AfterAfterBody{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype() || HtmlTreeBuilderState.isWhitespace(token) || token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (!token.isEOF()) {
                    htmlTreeBuilder.error(this);
                    htmlTreeBuilder.transition(InBody);
                    return htmlTreeBuilder.process(token);
                }
            }
            return true;
        }
    }
    ,
    AfterAfterFrameset{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            if (token.isComment()) {
                htmlTreeBuilder.insert(token.asComment());
            } else {
                if (token.isDoctype() || HtmlTreeBuilderState.isWhitespace(token) || token.isStartTag() && token.asStartTag().name().equals("html")) {
                    return htmlTreeBuilder.process(token, InBody);
                }
                if (!token.isEOF()) {
                    if (token.isStartTag() && token.asStartTag().name().equals("noframes")) {
                        return htmlTreeBuilder.process(token, InHead);
                    }
                    htmlTreeBuilder.error(this);
                    return false;
                }
            }
            return true;
        }
    }
    ,
    ForeignContent{

        boolean process(Token token, HtmlTreeBuilder htmlTreeBuilder) {
            return true;
        }
    };

    private static String nullString;

    abstract boolean process(Token var1, HtmlTreeBuilder var2);

    private static boolean isWhitespace(Token token) {
        if (token.isCharacter()) {
            String string = token.asCharacter().getData();
            return HtmlTreeBuilderState.isWhitespace(string);
        }
        return false;
    }

    private static boolean isWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (StringUtil.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private static void handleRcData(Token.StartTag startTag, HtmlTreeBuilder htmlTreeBuilder) {
        htmlTreeBuilder.insert(startTag);
        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rcdata);
        htmlTreeBuilder.markInsertionMode();
        htmlTreeBuilder.transition(Text);
    }

    private static void handleRawtext(Token.StartTag startTag, HtmlTreeBuilder htmlTreeBuilder) {
        htmlTreeBuilder.insert(startTag);
        htmlTreeBuilder.tokeniser.transition(TokeniserState.Rawtext);
        htmlTreeBuilder.markInsertionMode();
        htmlTreeBuilder.transition(Text);
    }

    static {
        nullString = String.valueOf('\u0000');
    }

    private static final class Constants {
        private static final String[] InBodyStartToHead = new String[]{"base", "basefont", "bgsound", "command", "link", "meta", "noframes", "script", "style", "title"};
        private static final String[] InBodyStartPClosers = new String[]{"address", "article", "aside", "blockquote", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "menu", "nav", "ol", "p", "section", "summary", "ul"};
        private static final String[] Headings = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        private static final String[] InBodyStartPreListing = new String[]{"pre", "listing"};
        private static final String[] InBodyStartLiBreakers = new String[]{"address", "div", "p"};
        private static final String[] DdDt = new String[]{"dd", "dt"};
        private static final String[] Formatters = new String[]{"b", "big", "code", "em", "font", "i", "s", "small", "strike", "strong", "tt", "u"};
        private static final String[] InBodyStartApplets = new String[]{"applet", "marquee", "object"};
        private static final String[] InBodyStartEmptyFormatters = new String[]{"area", "br", "embed", "img", "keygen", "wbr"};
        private static final String[] InBodyStartMedia = new String[]{"param", "source", "track"};
        private static final String[] InBodyStartInputAttribs = new String[]{"name", "action", "prompt"};
        private static final String[] InBodyStartOptions = new String[]{"optgroup", "option"};
        private static final String[] InBodyStartRuby = new String[]{"rp", "rt"};
        private static final String[] InBodyStartDrop = new String[]{"caption", "col", "colgroup", "frame", "head", "tbody", "td", "tfoot", "th", "thead", "tr"};
        private static final String[] InBodyEndClosers = new String[]{"address", "article", "aside", "blockquote", "button", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "listing", "menu", "nav", "ol", "pre", "section", "summary", "ul"};
        private static final String[] InBodyEndAdoptionFormatters = new String[]{"a", "b", "big", "code", "em", "font", "i", "nobr", "s", "small", "strike", "strong", "tt", "u"};
        private static final String[] InBodyEndTableFosters = new String[]{"table", "tbody", "tfoot", "thead", "tr"};

        private Constants() {
        }
    }
}

