/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.HtmlTreeBuilderState;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTreeBuilder
extends TreeBuilder {
    public static final String[] TagsSearchInScope = new String[]{"applet", "caption", "html", "table", "td", "th", "marquee", "object"};
    private static final String[] TagSearchList = new String[]{"ol", "ul"};
    private static final String[] TagSearchButton = new String[]{"button"};
    private static final String[] TagSearchTableScope = new String[]{"html", "table"};
    private static final String[] TagSearchSelectScope = new String[]{"optgroup", "option"};
    private static final String[] TagSearchEndTags = new String[]{"dd", "dt", "li", "option", "optgroup", "p", "rp", "rt"};
    private static final String[] TagSearchSpecial = new String[]{"address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp"};
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc = false;
    private Element headElement;
    private FormElement formElement;
    private Element contextElement;
    private ArrayList<Element> formattingElements = new ArrayList();
    private List<String> pendingTableCharacters = new ArrayList<String>();
    private Token.EndTag emptyEnd = new Token.EndTag();
    private boolean framesetOk = true;
    private boolean fosterInserts = false;
    private boolean fragmentParsing = false;
    private String[] specificScopeTarget = new String[]{null};

    HtmlTreeBuilder() {
    }

    @Override
    Document parse(String string, String string2, ParseErrorList parseErrorList) {
        this.state = HtmlTreeBuilderState.Initial;
        this.baseUriSetFromDoc = false;
        return super.parse(string, string2, parseErrorList);
    }

    List<Node> parseFragment(String string, Element element, String string2, ParseErrorList parseErrorList) {
        this.state = HtmlTreeBuilderState.Initial;
        this.initialiseParse(string, string2, parseErrorList);
        this.contextElement = element;
        this.fragmentParsing = true;
        Node node = null;
        if (element != null) {
            String string3;
            if (element.ownerDocument() != null) {
                this.doc.quirksMode(element.ownerDocument().quirksMode());
            }
            if (StringUtil.in(string3 = element.tagName(), "title", "textarea")) {
                this.tokeniser.transition(TokeniserState.Rcdata);
            } else if (StringUtil.in(string3, "iframe", "noembed", "noframes", "style", "xmp")) {
                this.tokeniser.transition(TokeniserState.Rawtext);
            } else if (string3.equals("script")) {
                this.tokeniser.transition(TokeniserState.ScriptData);
            } else if (string3.equals("noscript")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else if (string3.equals("plaintext")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else {
                this.tokeniser.transition(TokeniserState.Data);
            }
            node = new Element(Tag.valueOf("html"), string2);
            this.doc.appendChild(node);
            this.stack.add(node);
            this.resetInsertionMode();
            Elements elements = element.parents();
            elements.add(0, element);
            for (Element element2 : elements) {
                if (!(element2 instanceof FormElement)) continue;
                this.formElement = (FormElement)element2;
                break;
            }
        }
        this.runParser();
        if (element != null && node != null) {
            return node.childNodes();
        }
        return this.doc.childNodes();
    }

    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        return this.state.process(token, this);
    }

    boolean process(Token token, HtmlTreeBuilderState htmlTreeBuilderState) {
        this.currentToken = token;
        return htmlTreeBuilderState.process(token, this);
    }

    void transition(HtmlTreeBuilderState htmlTreeBuilderState) {
        this.state = htmlTreeBuilderState;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    void framesetOk(boolean bl) {
        this.framesetOk = bl;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    void maybeSetBaseUri(Element element) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String string = element.absUrl("href");
        if (string.length() != 0) {
            this.baseUri = string;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri(string);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    void error(HtmlTreeBuilderState htmlTreeBuilderState) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected token [%s] when in state [%s]", new Object[]{this.currentToken.tokenType(), htmlTreeBuilderState}));
        }
    }

    Element insert(Token.StartTag startTag) {
        if (startTag.isSelfClosing()) {
            Element element = this.insertEmpty(startTag);
            this.stack.add(element);
            this.tokeniser.transition(TokeniserState.Data);
            this.tokeniser.emit(this.emptyEnd.reset().name(element.tagName()));
            return element;
        }
        Element element = new Element(Tag.valueOf(startTag.name()), this.baseUri, startTag.attributes);
        this.insert(element);
        return element;
    }

    Element insertStartTag(String string) {
        Element element = new Element(Tag.valueOf(string), this.baseUri);
        this.insert(element);
        return element;
    }

    void insert(Element element) {
        this.insertNode(element);
        this.stack.add(element);
    }

    Element insertEmpty(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name());
        Element element = new Element(tag, this.baseUri, startTag.attributes);
        this.insertNode(element);
        if (startTag.isSelfClosing()) {
            if (tag.isKnownTag()) {
                if (tag.isSelfClosing()) {
                    this.tokeniser.acknowledgeSelfClosingFlag();
                }
            } else {
                tag.setSelfClosing();
                this.tokeniser.acknowledgeSelfClosingFlag();
            }
        }
        return element;
    }

    FormElement insertForm(Token.StartTag startTag, boolean bl) {
        Tag tag = Tag.valueOf(startTag.name());
        FormElement formElement = new FormElement(tag, this.baseUri, startTag.attributes);
        this.setFormElement(formElement);
        this.insertNode(formElement);
        if (bl) {
            this.stack.add(formElement);
        }
        return formElement;
    }

    void insert(Token.Comment comment) {
        Comment comment2 = new Comment(comment.getData(), this.baseUri);
        this.insertNode(comment2);
    }

    void insert(Token.Character character) {
        String string = this.currentElement().tagName();
        Node node = string.equals("script") || string.equals("style") ? new DataNode(character.getData(), this.baseUri) : new TextNode(character.getData(), this.baseUri);
        this.currentElement().appendChild(node);
    }

    private void insertNode(Node node) {
        if (this.stack.size() == 0) {
            this.doc.appendChild(node);
        } else if (this.isFosterInserts()) {
            this.insertInFosterParent(node);
        } else {
            this.currentElement().appendChild(node);
        }
        if (node instanceof Element && ((Element)node).tag().isFormListed() && this.formElement != null) {
            this.formElement.addElement((Element)node);
        }
    }

    Element pop() {
        int n = this.stack.size();
        return (Element)this.stack.remove(n - 1);
    }

    void push(Element element) {
        this.stack.add(element);
    }

    ArrayList<Element> getStack() {
        return this.stack;
    }

    boolean onStack(Element element) {
        return this.isElementInQueue(this.stack, element);
    }

    private boolean isElementInQueue(ArrayList<Element> arrayList, Element element) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Element element2 = arrayList.get(i);
            if (element2 != element) continue;
            return true;
        }
        return false;
    }

    Element getFromStack(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            if (!element.nodeName().equals(string)) continue;
            return element;
        }
        return null;
    }

    boolean removeFromStack(Element element) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element2 = (Element)this.stack.get(i);
            if (element2 != element) continue;
            this.stack.remove(i);
            return true;
        }
        return false;
    }

    void popStackToClose(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            this.stack.remove(i);
            if (element.nodeName().equals(string)) break;
        }
    }

    void popStackToClose(String ... stringArray) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            this.stack.remove(i);
            if (StringUtil.in(element.nodeName(), stringArray)) break;
        }
    }

    void popStackToBefore(String string) {
        Element element;
        for (int i = this.stack.size() - 1; i >= 0 && !(element = (Element)this.stack.get(i)).nodeName().equals(string); --i) {
            this.stack.remove(i);
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr");
    }

    private void clearStackToContext(String ... stringArray) {
        Element element;
        for (int i = this.stack.size() - 1; i >= 0 && !StringUtil.in((element = (Element)this.stack.get(i)).nodeName(), stringArray) && !element.nodeName().equals("html"); --i) {
            this.stack.remove(i);
        }
    }

    Element aboveOnStack(Element element) {
        assert (this.onStack(element));
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element2 = (Element)this.stack.get(i);
            if (element2 != element) continue;
            return (Element)this.stack.get(i - 1);
        }
        return null;
    }

    void insertOnStackAfter(Element element, Element element2) {
        int n = this.stack.lastIndexOf(element);
        Validate.isTrue(n != -1);
        this.stack.add(n + 1, element2);
    }

    void replaceOnStack(Element element, Element element2) {
        this.replaceInQueue(this.stack, element, element2);
    }

    private void replaceInQueue(ArrayList<Element> arrayList, Element element, Element element2) {
        int n = arrayList.lastIndexOf(element);
        Validate.isTrue(n != -1);
        arrayList.set(n, element2);
    }

    void resetInsertionMode() {
        boolean bl = false;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            String string;
            Element element = (Element)this.stack.get(i);
            if (i == 0) {
                bl = true;
                element = this.contextElement;
            }
            if ("select".equals(string = element.nodeName())) {
                this.transition(HtmlTreeBuilderState.InSelect);
                break;
            }
            if ("td".equals(string) || "th".equals(string) && !bl) {
                this.transition(HtmlTreeBuilderState.InCell);
                break;
            }
            if ("tr".equals(string)) {
                this.transition(HtmlTreeBuilderState.InRow);
                break;
            }
            if ("tbody".equals(string) || "thead".equals(string) || "tfoot".equals(string)) {
                this.transition(HtmlTreeBuilderState.InTableBody);
                break;
            }
            if ("caption".equals(string)) {
                this.transition(HtmlTreeBuilderState.InCaption);
                break;
            }
            if ("colgroup".equals(string)) {
                this.transition(HtmlTreeBuilderState.InColumnGroup);
                break;
            }
            if ("table".equals(string)) {
                this.transition(HtmlTreeBuilderState.InTable);
                break;
            }
            if ("head".equals(string)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("body".equals(string)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("frameset".equals(string)) {
                this.transition(HtmlTreeBuilderState.InFrameset);
                break;
            }
            if ("html".equals(string)) {
                this.transition(HtmlTreeBuilderState.BeforeHead);
                break;
            }
            if (!bl) continue;
            this.transition(HtmlTreeBuilderState.InBody);
            break;
        }
    }

    private boolean inSpecificScope(String string, String[] stringArray, String[] stringArray2) {
        this.specificScopeTarget[0] = string;
        return this.inSpecificScope(this.specificScopeTarget, stringArray, stringArray2);
    }

    private boolean inSpecificScope(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            String string = element.nodeName();
            if (StringUtil.in(string, stringArray)) {
                return true;
            }
            if (StringUtil.in(string, stringArray2)) {
                return false;
            }
            if (stringArray3 == null || !StringUtil.in(string, stringArray3)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    boolean inScope(String[] stringArray) {
        return this.inSpecificScope(stringArray, TagsSearchInScope, null);
    }

    boolean inScope(String string) {
        return this.inScope(string, null);
    }

    boolean inScope(String string, String[] stringArray) {
        return this.inSpecificScope(string, TagsSearchInScope, stringArray);
    }

    boolean inListItemScope(String string) {
        return this.inScope(string, TagSearchList);
    }

    boolean inButtonScope(String string) {
        return this.inScope(string, TagSearchButton);
    }

    boolean inTableScope(String string) {
        return this.inSpecificScope(string, TagSearchTableScope, null);
    }

    boolean inSelectScope(String string) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.stack.get(i);
            String string2 = element.nodeName();
            if (string2.equals(string)) {
                return true;
            }
            if (StringUtil.in(string2, TagSearchSelectScope)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    void setHeadElement(Element element) {
        this.headElement = element;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    void setFosterInserts(boolean bl) {
        this.fosterInserts = bl;
    }

    FormElement getFormElement() {
        return this.formElement;
    }

    void setFormElement(FormElement formElement) {
        this.formElement = formElement;
    }

    void newPendingTableCharacters() {
        this.pendingTableCharacters = new ArrayList<String>();
    }

    List<String> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    void setPendingTableCharacters(List<String> list) {
        this.pendingTableCharacters = list;
    }

    void generateImpliedEndTags(String string) {
        while (string != null && !this.currentElement().nodeName().equals(string) && StringUtil.in(this.currentElement().nodeName(), TagSearchEndTags)) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(null);
    }

    boolean isSpecial(Element element) {
        String string = element.nodeName();
        return StringUtil.in(string, TagSearchSpecial);
    }

    Element lastFormattingElement() {
        return this.formattingElements.size() > 0 ? this.formattingElements.get(this.formattingElements.size() - 1) : null;
    }

    Element removeLastFormattingElement() {
        int n = this.formattingElements.size();
        if (n > 0) {
            return this.formattingElements.remove(n - 1);
        }
        return null;
    }

    void pushActiveFormattingElements(Element element) {
        Element element2;
        int n = 0;
        for (int i = this.formattingElements.size() - 1; i >= 0 && (element2 = this.formattingElements.get(i)) != null; --i) {
            if (this.isSameFormattingElement(element, element2)) {
                ++n;
            }
            if (n != 3) continue;
            this.formattingElements.remove(i);
            break;
        }
        this.formattingElements.add(element);
    }

    private boolean isSameFormattingElement(Element element, Element element2) {
        return element.nodeName().equals(element2.nodeName()) && element.attributes().equals(element2.attributes());
    }

    void reconstructFormattingElements() {
        Element element = this.lastFormattingElement();
        if (element == null || this.onStack(element)) {
            return;
        }
        Element element2 = element;
        int n = this.formattingElements.size();
        int n2 = n - 1;
        boolean bl = false;
        do {
            if (n2 != 0) continue;
            bl = true;
            break;
        } while ((element2 = this.formattingElements.get(--n2)) != null && !this.onStack(element2));
        do {
            if (!bl) {
                element2 = this.formattingElements.get(++n2);
            }
            Validate.notNull(element2);
            bl = false;
            Element element3 = this.insertStartTag(element2.nodeName());
            element3.attributes().addAll(element2.attributes());
            this.formattingElements.set(n2, element3);
        } while (n2 != n - 1);
    }

    void clearFormattingElementsToLastMarker() {
        Element element;
        while (!this.formattingElements.isEmpty() && (element = this.removeLastFormattingElement()) != null) {
        }
    }

    void removeFromActiveFormattingElements(Element element) {
        for (int i = this.formattingElements.size() - 1; i >= 0; --i) {
            Element element2 = this.formattingElements.get(i);
            if (element2 != element) continue;
            this.formattingElements.remove(i);
            break;
        }
    }

    boolean isInActiveFormattingElements(Element element) {
        return this.isElementInQueue(this.formattingElements, element);
    }

    Element getActiveFormattingElement(String string) {
        Element element;
        for (int i = this.formattingElements.size() - 1; i >= 0 && (element = this.formattingElements.get(i)) != null; --i) {
            if (!element.nodeName().equals(string)) continue;
            return element;
        }
        return null;
    }

    void replaceActiveFormattingElement(Element element, Element element2) {
        this.replaceInQueue(this.formattingElements, element, element2);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    void insertInFosterParent(Node node) {
        Element element;
        Element element2 = this.getFromStack("table");
        boolean bl = false;
        if (element2 != null) {
            if (element2.parent() != null) {
                element = element2.parent();
                bl = true;
            } else {
                element = this.aboveOnStack(element2);
            }
        } else {
            element = (Element)this.stack.get(0);
        }
        if (bl) {
            Validate.notNull(element2);
            element2.before(node);
        } else {
            element.appendChild(node);
        }
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }
}

