/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Arrays;
import java.util.Locale;
import org.jsoup.helper.Validate;

final class CharacterReader {
    static final char EOF = '\uffff';
    private static final int maxCacheLen = 12;
    private final char[] input;
    private final int length;
    private int pos = 0;
    private int mark = 0;
    private final String[] stringCache = new String[512];

    CharacterReader(String string) {
        Validate.notNull(string);
        this.input = string.toCharArray();
        this.length = this.input.length;
    }

    int pos() {
        return this.pos;
    }

    boolean isEmpty() {
        return this.pos >= this.length;
    }

    char current() {
        return this.pos >= this.length ? (char)'\uffff' : this.input[this.pos];
    }

    char consume() {
        char c = this.pos >= this.length ? (char)'\uffff' : this.input[this.pos];
        ++this.pos;
        return c;
    }

    void unconsume() {
        --this.pos;
    }

    void advance() {
        ++this.pos;
    }

    void mark() {
        this.mark = this.pos;
    }

    void rewindToMark() {
        this.pos = this.mark;
    }

    String consumeAsString() {
        return new String(this.input, this.pos++, 1);
    }

    int nextIndexOf(char c) {
        for (int i = this.pos; i < this.length; ++i) {
            if (c != this.input[i]) continue;
            return i - this.pos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence charSequence) {
        char c = charSequence.charAt(0);
        for (int i = this.pos; i < this.length; ++i) {
            if (c != this.input[i]) {
                while (++i < this.length && c != this.input[i]) {
                }
            }
            int n = i + 1;
            int n2 = n + charSequence.length() - 1;
            if (i >= this.length || n2 > this.length) continue;
            int n3 = 1;
            while (n < n2 && charSequence.charAt(n3) == this.input[n]) {
                ++n;
                ++n3;
            }
            if (n != n2) continue;
            return i - this.pos;
        }
        return -1;
    }

    String consumeTo(char c) {
        int n = this.nextIndexOf(c);
        if (n != -1) {
            String string = this.cacheString(this.pos, n);
            this.pos += n;
            return string;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String string) {
        int n = this.nextIndexOf(string);
        if (n != -1) {
            String string2 = this.cacheString(this.pos, n);
            this.pos += n;
            return string2;
        }
        return this.consumeToEnd();
    }

    String consumeToAny(char ... cArray) {
        int n = this.pos;
        int n2 = this.length;
        char[] cArray2 = this.input;
        block0: while (this.pos < n2) {
            for (char c : cArray) {
                if (cArray2[this.pos] == c) break block0;
            }
            ++this.pos;
        }
        return this.pos > n ? this.cacheString(n, this.pos - n) : "";
    }

    String consumeToAnySorted(char ... cArray) {
        int n = this.pos;
        int n2 = this.length;
        char[] cArray2 = this.input;
        while (this.pos < n2 && Arrays.binarySearch(cArray, cArray2[this.pos]) < 0) {
            ++this.pos;
        }
        return this.pos > n ? this.cacheString(n, this.pos - n) : "";
    }

    String consumeData() {
        char c;
        int n = this.pos;
        int n2 = this.length;
        char[] cArray = this.input;
        while (this.pos < n2 && (c = cArray[this.pos]) != '&' && c != '<' && c != '\u0000') {
            ++this.pos;
        }
        return this.pos > n ? this.cacheString(n, this.pos - n) : "";
    }

    String consumeTagName() {
        char c;
        int n = this.pos;
        int n2 = this.length;
        char[] cArray = this.input;
        while (this.pos < n2 && (c = cArray[this.pos]) != '\t' && c != '\n' && c != '\r' && c != '\f' && c != ' ' && c != '/' && c != '>' && c != '\u0000') {
            ++this.pos;
        }
        return this.pos > n ? this.cacheString(n, this.pos - n) : "";
    }

    String consumeToEnd() {
        String string = this.cacheString(this.pos, this.length - this.pos);
        this.pos = this.length;
        return string;
    }

    String consumeLetterSequence() {
        char c;
        int n = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.pos;
        }
        return this.cacheString(n, this.pos - n);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        int n = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.pos;
        }
        while (!this.isEmpty() && (c = this.input[this.pos]) >= '0' && c <= '9') {
            ++this.pos;
        }
        return this.cacheString(n, this.pos - n);
    }

    String consumeHexSequence() {
        char c;
        int n = this.pos;
        while (this.pos < this.length && ((c = this.input[this.pos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.pos;
        }
        return this.cacheString(n, this.pos - n);
    }

    String consumeDigitSequence() {
        char c;
        int n = this.pos;
        while (this.pos < this.length && (c = this.input[this.pos]) >= '0' && c <= '9') {
            ++this.pos;
        }
        return this.cacheString(n, this.pos - n);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.input[this.pos] == c;
    }

    boolean matches(String string) {
        int n = string.length();
        if (n > this.length - this.pos) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == this.input[this.pos + i]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String string) {
        int n = string.length();
        if (n > this.length - this.pos) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = Character.toUpperCase(string.charAt(i));
            if (c2 == (c = Character.toUpperCase(this.input[this.pos + i]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... cArray) {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        for (char c2 : cArray) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesAnySorted(char[] cArray) {
        return !this.isEmpty() && Arrays.binarySearch(cArray, this.input[this.pos]) >= 0;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.input[this.pos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String string) {
        if (this.matches(string)) {
            this.pos += string.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String string) {
        if (this.matchesIgnoreCase(string)) {
            this.pos += string.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(string2) > -1 || this.nextIndexOf(string3) > -1;
    }

    public String toString() {
        return new String(this.input, this.pos, this.length - this.pos);
    }

    private String cacheString(int n, int n2) {
        int n3;
        char[] cArray = this.input;
        String[] stringArray = this.stringCache;
        if (n2 > 12) {
            return new String(cArray, n, n2);
        }
        int n4 = 0;
        int n5 = n;
        for (n3 = 0; n3 < n2; ++n3) {
            n4 = 31 * n4 + cArray[n5++];
        }
        n3 = n4 & stringArray.length - 1;
        String string = stringArray[n3];
        if (string == null) {
            stringArray[n3] = string = new String(cArray, n, n2);
        } else {
            if (this.rangeEquals(n, n2, string)) {
                return string;
            }
            stringArray[n3] = string = new String(cArray, n, n2);
        }
        return string;
    }

    boolean rangeEquals(int n, int n2, String string) {
        if (n2 == string.length()) {
            char[] cArray = this.input;
            int n3 = n;
            int n4 = 0;
            while (n2-- != 0) {
                if (cArray[n3++] == string.charAt(n4++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

