/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.SerializationException;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Cloneable {
    private static final List<Node> EMPTY_NODES = Collections.emptyList();
    Node parentNode;
    List<Node> childNodes;
    Attributes attributes;
    String baseUri;
    int siblingIndex;

    protected Node(String string, Attributes attributes) {
        Validate.notNull(string);
        Validate.notNull(attributes);
        this.childNodes = EMPTY_NODES;
        this.baseUri = string.trim();
        this.attributes = attributes;
    }

    protected Node(String string) {
        this(string, new Attributes());
    }

    protected Node() {
        this.childNodes = EMPTY_NODES;
        this.attributes = null;
    }

    public abstract String nodeName();

    public String attr(String string) {
        Validate.notNull(string);
        if (this.attributes.hasKey(string)) {
            return this.attributes.get(string);
        }
        if (string.toLowerCase().startsWith("abs:")) {
            return this.absUrl(string.substring("abs:".length()));
        }
        return "";
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public Node attr(String string, String string2) {
        this.attributes.put(string, string2);
        return this;
    }

    public boolean hasAttr(String string) {
        String string2;
        Validate.notNull(string);
        if (string.startsWith("abs:") && this.attributes.hasKey(string2 = string.substring("abs:".length())) && !this.absUrl(string2).equals("")) {
            return true;
        }
        return this.attributes.hasKey(string);
    }

    public Node removeAttr(String string) {
        Validate.notNull(string);
        this.attributes.remove(string);
        return this;
    }

    public String baseUri() {
        return this.baseUri;
    }

    public void setBaseUri(final String string) {
        Validate.notNull(string);
        this.traverse(new NodeVisitor(){

            public void head(Node node, int n) {
                node.baseUri = string;
            }

            public void tail(Node node, int n) {
            }
        });
    }

    public String absUrl(String string) {
        Validate.notEmpty(string);
        if (!this.hasAttr(string)) {
            return "";
        }
        return StringUtil.resolve(this.baseUri, this.attr(string));
    }

    public Node childNode(int n) {
        return this.childNodes.get(n);
    }

    public List<Node> childNodes() {
        return Collections.unmodifiableList(this.childNodes);
    }

    public List<Node> childNodesCopy() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.childNodes.size());
        for (Node node : this.childNodes) {
            arrayList.add(node.clone());
        }
        return arrayList;
    }

    public final int childNodeSize() {
        return this.childNodes.size();
    }

    protected Node[] childNodesAsArray() {
        return this.childNodes.toArray(new Node[this.childNodeSize()]);
    }

    public Node parent() {
        return this.parentNode;
    }

    public final Node parentNode() {
        return this.parentNode;
    }

    public Document ownerDocument() {
        if (this instanceof Document) {
            return (Document)this;
        }
        if (this.parentNode == null) {
            return null;
        }
        return this.parentNode.ownerDocument();
    }

    public void remove() {
        Validate.notNull(this.parentNode);
        this.parentNode.removeChild(this);
    }

    public Node before(String string) {
        this.addSiblingHtml(this.siblingIndex, string);
        return this;
    }

    public Node before(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex, node);
        return this;
    }

    public Node after(String string) {
        this.addSiblingHtml(this.siblingIndex + 1, string);
        return this;
    }

    public Node after(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex + 1, node);
        return this;
    }

    private void addSiblingHtml(int n, String string) {
        Validate.notNull(string);
        Validate.notNull(this.parentNode);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = Parser.parseFragment(string, element, this.baseUri());
        this.parentNode.addChildren(n, list.toArray(new Node[list.size()]));
    }

    public Node wrap(String string) {
        Validate.notEmpty(string);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = Parser.parseFragment(string, element, this.baseUri());
        Node node = list.get(0);
        if (node == null || !(node instanceof Element)) {
            return null;
        }
        Element element2 = (Element)node;
        Element element3 = this.getDeepChild(element2);
        this.parentNode.replaceChild(this, element2);
        element3.addChildren(this);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Node node2 = list.get(i);
                node2.parentNode.removeChild(node2);
                element2.appendChild(node2);
            }
        }
        return this;
    }

    public Node unwrap() {
        Validate.notNull(this.parentNode);
        Node node = this.childNodes.size() > 0 ? this.childNodes.get(0) : null;
        this.parentNode.addChildren(this.siblingIndex, this.childNodesAsArray());
        this.remove();
        return node;
    }

    private Element getDeepChild(Element element) {
        Elements elements = element.children();
        if (elements.size() > 0) {
            return this.getDeepChild((Element)elements.get(0));
        }
        return element;
    }

    public void replaceWith(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.replaceChild(this, node);
    }

    protected void setParentNode(Node node) {
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        this.parentNode = node;
    }

    protected void replaceChild(Node node, Node node2) {
        Validate.isTrue(node.parentNode == this);
        Validate.notNull(node2);
        if (node2.parentNode != null) {
            node2.parentNode.removeChild(node2);
        }
        int n = node.siblingIndex;
        this.childNodes.set(n, node2);
        node2.parentNode = this;
        node2.setSiblingIndex(n);
        node.parentNode = null;
    }

    protected void removeChild(Node node) {
        Validate.isTrue(node.parentNode == this);
        int n = node.siblingIndex;
        this.childNodes.remove(n);
        this.reindexChildren(n);
        node.parentNode = null;
    }

    protected void addChildren(Node ... nodeArray) {
        for (Node node : nodeArray) {
            this.reparentChild(node);
            this.ensureChildNodes();
            this.childNodes.add(node);
            node.setSiblingIndex(this.childNodes.size() - 1);
        }
    }

    protected void addChildren(int n, Node ... nodeArray) {
        Validate.noNullElements(nodeArray);
        this.ensureChildNodes();
        for (int i = nodeArray.length - 1; i >= 0; --i) {
            Node node = nodeArray[i];
            this.reparentChild(node);
            this.childNodes.add(n, node);
            this.reindexChildren(n);
        }
    }

    protected void ensureChildNodes() {
        if (this.childNodes == EMPTY_NODES) {
            this.childNodes = new ArrayList<Node>(4);
        }
    }

    protected void reparentChild(Node node) {
        if (node.parentNode != null) {
            node.parentNode.removeChild(node);
        }
        node.setParentNode(this);
    }

    private void reindexChildren(int n) {
        for (int i = n; i < this.childNodes.size(); ++i) {
            this.childNodes.get(i).setSiblingIndex(i);
        }
    }

    public List<Node> siblingNodes() {
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        List<Node> list = this.parentNode.childNodes;
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size() - 1);
        for (Node node : list) {
            if (node == this) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Node nextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> list = this.parentNode.childNodes;
        int n = this.siblingIndex + 1;
        if (list.size() > n) {
            return list.get(n);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        if (this.siblingIndex > 0) {
            return this.parentNode.childNodes.get(this.siblingIndex - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.siblingIndex;
    }

    protected void setSiblingIndex(int n) {
        this.siblingIndex = n;
    }

    public Node traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor nodeTraversor = new NodeTraversor(nodeVisitor);
        nodeTraversor.traverse(this);
        return this;
    }

    public String outerHtml() {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.outerHtml(stringBuilder);
        return stringBuilder.toString();
    }

    protected void outerHtml(Appendable appendable) {
        new NodeTraversor(new OuterHtmlVisitor(appendable, this.getOutputSettings())).traverse(this);
    }

    Document.OutputSettings getOutputSettings() {
        return this.ownerDocument() != null ? this.ownerDocument().outputSettings() : new Document("").outputSettings();
    }

    abstract void outerHtmlHead(Appendable var1, int var2, Document.OutputSettings var3);

    abstract void outerHtmlTail(Appendable var1, int var2, Document.OutputSettings var3);

    public <T extends Appendable> T html(T t) {
        this.outerHtml(t);
        return t;
    }

    public String toString() {
        return this.outerHtml();
    }

    protected void indent(Appendable appendable, int n, Document.OutputSettings outputSettings) {
        appendable.append("\n").append(StringUtil.padding(n * outputSettings.indentAmount()));
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public boolean hasSameValue(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.outerHtml().equals(((Node)object).outerHtml());
    }

    public Node clone() {
        Node node = this.doClone(null);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(node);
        while (!linkedList.isEmpty()) {
            Node node2 = (Node)linkedList.remove();
            for (int i = 0; i < node2.childNodes.size(); ++i) {
                Node node3 = node2.childNodes.get(i).doClone(node2);
                node2.childNodes.set(i, node3);
                linkedList.add(node3);
            }
        }
        return node;
    }

    protected Node doClone(Node node) {
        Node node2;
        try {
            node2 = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        node2.parentNode = node;
        node2.siblingIndex = node == null ? 0 : this.siblingIndex;
        node2.attributes = this.attributes != null ? this.attributes.clone() : null;
        node2.baseUri = this.baseUri;
        node2.childNodes = new ArrayList<Node>(this.childNodes.size());
        for (Node node3 : this.childNodes) {
            node2.childNodes.add(node3);
        }
        return node2;
    }

    private static class OuterHtmlVisitor
    implements NodeVisitor {
        private Appendable accum;
        private Document.OutputSettings out;

        OuterHtmlVisitor(Appendable appendable, Document.OutputSettings outputSettings) {
            this.accum = appendable;
            this.out = outputSettings;
        }

        public void head(Node node, int n) {
            try {
                node.outerHtmlHead(this.accum, n, this.out);
            }
            catch (IOException iOException) {
                throw new SerializationException(iOException);
            }
        }

        public void tail(Node node, int n) {
            if (!node.nodeName().equals("#text")) {
                try {
                    node.outerHtmlTail(this.accum, n, this.out);
                }
                catch (IOException iOException) {
                    throw new SerializationException(iOException);
                }
            }
        }
    }
}

