/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.jsoup.SerializationException;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entities {
    private static final Map<String, Character> full;
    private static final Map<Character, String> xhtmlByVal;
    private static final Map<String, Character> base;
    private static final Map<Character, String> baseByVal;
    private static final Map<Character, String> fullByVal;
    private static final Object[][] xhtmlArray;

    private Entities() {
    }

    public static boolean isNamedEntity(String string) {
        return full.containsKey(string);
    }

    public static boolean isBaseNamedEntity(String string) {
        return base.containsKey(string);
    }

    public static Character getCharacterByName(String string) {
        return full.get(string);
    }

    static String escape(String string, Document.OutputSettings outputSettings) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        try {
            Entities.escape(stringBuilder, string, outputSettings, false, false, false);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return stringBuilder.toString();
    }

    static void escape(Appendable appendable, String string, Document.OutputSettings outputSettings, boolean bl, boolean bl2, boolean bl3) {
        int n;
        boolean bl4 = false;
        boolean bl5 = false;
        EscapeMode escapeMode = outputSettings.escapeMode();
        CharsetEncoder charsetEncoder = outputSettings.encoder();
        CoreCharset coreCharset = CoreCharset.byName(charsetEncoder.charset().name());
        Map<Character, String> map = escapeMode.getMap();
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (bl2) {
                if (StringUtil.isWhitespace(n)) {
                    if (bl3 && !bl5 || bl4) continue;
                    appendable.append(' ');
                    bl4 = true;
                    continue;
                }
                bl4 = false;
                bl5 = true;
            }
            if (n < 65536) {
                char c = (char)n;
                switch (c) {
                    case '&': {
                        appendable.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            appendable.append("&nbsp;");
                            break;
                        }
                        appendable.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!bl || escapeMode == EscapeMode.xhtml) {
                            appendable.append("&lt;");
                            break;
                        }
                        appendable.append(c);
                        break;
                    }
                    case '>': {
                        if (!bl) {
                            appendable.append("&gt;");
                            break;
                        }
                        appendable.append(c);
                        break;
                    }
                    case '\"': {
                        if (bl) {
                            appendable.append("&quot;");
                            break;
                        }
                        appendable.append(c);
                        break;
                    }
                    default: {
                        if (Entities.canEncode(coreCharset, c, charsetEncoder)) {
                            appendable.append(c);
                            break;
                        }
                        if (map.containsKey(Character.valueOf(c))) {
                            appendable.append('&').append(map.get(Character.valueOf(c))).append(';');
                            break;
                        }
                        appendable.append("&#x").append(Integer.toHexString(n)).append(';');
                        break;
                    }
                }
                continue;
            }
            String string2 = new String(Character.toChars(n));
            if (charsetEncoder.canEncode(string2)) {
                appendable.append(string2);
                continue;
            }
            appendable.append("&#x").append(Integer.toHexString(n)).append(';');
        }
    }

    static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    static String unescape(String string, boolean bl) {
        return Parser.unescapeEntities(string, bl);
    }

    private static boolean canEncode(CoreCharset coreCharset, char c, CharsetEncoder charsetEncoder) {
        switch (coreCharset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return true;
            }
        }
        return charsetEncoder.canEncode(c);
    }

    private static Map<String, Character> loadEntities(String string) {
        Properties properties = new Properties();
        HashMap<String, Character> hashMap = new HashMap<String, Character>();
        try {
            InputStream inputStream = Entities.class.getResourceAsStream(string);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new MissingResourceException("Error loading entities resource: " + iOException.getMessage(), "Entities", string);
        }
        for (Map.Entry entry : properties.entrySet()) {
            Character c = Character.valueOf((char)Integer.parseInt((String)entry.getValue(), 16));
            String string2 = (String)entry.getKey();
            hashMap.put(string2, c);
        }
        return hashMap;
    }

    private static Map<Character, String> toCharacterKey(Map<String, Character> map) {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        for (Map.Entry<String, Character> entry : map.entrySet()) {
            Character c = entry.getValue();
            String string = entry.getKey();
            if (hashMap.containsKey(c)) {
                if (!string.toLowerCase().equals(string)) continue;
                hashMap.put(c, string);
                continue;
            }
            hashMap.put(c, string);
        }
        return hashMap;
    }

    static /* synthetic */ Map access$000() {
        return xhtmlByVal;
    }

    static /* synthetic */ Map access$100() {
        return baseByVal;
    }

    static /* synthetic */ Map access$200() {
        return fullByVal;
    }

    static {
        xhtmlArray = new Object[][]{{"quot", 34}, {"amp", 38}, {"lt", 60}, {"gt", 62}};
        xhtmlByVal = new HashMap<Character, String>();
        base = Entities.loadEntities("entities-base.properties");
        baseByVal = Entities.toCharacterKey(base);
        full = Entities.loadEntities("entities-full.properties");
        fullByVal = Entities.toCharacterKey(full);
        for (Object[] objectArray : xhtmlArray) {
            Character c = Character.valueOf((char)((Integer)objectArray[1]).intValue());
            xhtmlByVal.put(c, (String)objectArray[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CoreCharset {
        ascii,
        utf,
        fallback;


        private static CoreCharset byName(String string) {
            if (string.equals("US-ASCII")) {
                return ascii;
            }
            if (string.startsWith("UTF-")) {
                return utf;
            }
            return fallback;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscapeMode {
        xhtml(Entities.access$000()),
        base(Entities.access$100()),
        extended(Entities.access$200());

        private Map<Character, String> map;

        private EscapeMode(Map<Character, String> map) {
            this.map = map;
        }

        public Map<Character, String> getMap() {
            return this.map;
        }
    }
}

