/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Node {
    private Tag tag;
    private static final Pattern classSplit = Pattern.compile("\\s+");

    public Element(Tag tag, String string, Attributes attributes) {
        super(string, attributes);
        Validate.notNull(tag);
        this.tag = tag;
    }

    public Element(Tag tag, String string) {
        this(tag, string, new Attributes());
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public Element tagName(String string) {
        Validate.notEmpty(string, "Tag name must not be empty.");
        this.tag = Tag.valueOf(string);
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        return this.attributes.get("id");
    }

    @Override
    public Element attr(String string, String string2) {
        super.attr(string, string2);
        return this;
    }

    public Element attr(String string, boolean bl) {
        this.attributes.put(string, bl);
        return this;
    }

    public Map<String, String> dataset() {
        return this.attributes.dataset();
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    public Elements parents() {
        Elements elements = new Elements();
        Element.accumulateParents(this, elements);
        return elements;
    }

    private static void accumulateParents(Element element, Elements elements) {
        Element element2 = element.parent();
        if (element2 != null && !element2.tagName().equals("#root")) {
            elements.add(element2);
            Element.accumulateParents(element2, elements);
        }
    }

    public Element child(int n) {
        return (Element)this.children().get(n);
    }

    public Elements children() {
        ArrayList<Element> arrayList = new ArrayList<Element>(this.childNodes.size());
        for (Node node : this.childNodes) {
            if (!(node instanceof Element)) continue;
            arrayList.add((Element)node);
        }
        return new Elements((List<Element>)arrayList);
    }

    public List<TextNode> textNodes() {
        ArrayList<TextNode> arrayList = new ArrayList<TextNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof TextNode)) continue;
            arrayList.add((TextNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<DataNode> dataNodes() {
        ArrayList<DataNode> arrayList = new ArrayList<DataNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof DataNode)) continue;
            arrayList.add((DataNode)node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Element appendChild(Node node) {
        Validate.notNull(node);
        this.reparentChild(node);
        this.ensureChildNodes();
        this.childNodes.add(node);
        node.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    public Element prependChild(Node node) {
        Validate.notNull(node);
        this.addChildren(0, node);
        return this;
    }

    public Element insertChildren(int n, Collection<? extends Node> collection) {
        Validate.notNull(collection, "Children collection to be inserted must not be null.");
        int n2 = this.childNodeSize();
        if (n < 0) {
            n += n2 + 1;
        }
        Validate.isTrue(n >= 0 && n <= n2, "Insert position out of bounds.");
        ArrayList<? extends Node> arrayList = new ArrayList<Node>(collection);
        Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        this.addChildren(n, nodeArray);
        return this;
    }

    public Element appendElement(String string) {
        Element element = new Element(Tag.valueOf(string), this.baseUri());
        this.appendChild(element);
        return element;
    }

    public Element prependElement(String string) {
        Element element = new Element(Tag.valueOf(string), this.baseUri());
        this.prependChild(element);
        return element;
    }

    public Element appendText(String string) {
        Validate.notNull(string);
        TextNode textNode = new TextNode(string, this.baseUri());
        this.appendChild(textNode);
        return this;
    }

    public Element prependText(String string) {
        Validate.notNull(string);
        TextNode textNode = new TextNode(string, this.baseUri());
        this.prependChild(textNode);
        return this;
    }

    public Element append(String string) {
        Validate.notNull(string);
        List<Node> list = Parser.parseFragment(string, this, this.baseUri());
        this.addChildren(list.toArray(new Node[list.size()]));
        return this;
    }

    public Element prepend(String string) {
        Validate.notNull(string);
        List<Node> list = Parser.parseFragment(string, this, this.baseUri());
        this.addChildren(0, list.toArray(new Node[list.size()]));
        return this;
    }

    @Override
    public Element before(String string) {
        return (Element)super.before(string);
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element after(String string) {
        return (Element)super.after(string);
    }

    @Override
    public Element after(Node node) {
        return (Element)super.after(node);
    }

    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    @Override
    public Element wrap(String string) {
        return (Element)super.wrap(string);
    }

    public String cssSelector() {
        if (this.id().length() > 0) {
            return "#" + this.id();
        }
        String string = this.tagName().replace(':', '|');
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = StringUtil.join(this.classNames(), ".");
        if (string2.length() > 0) {
            stringBuilder.append('.').append(string2);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return stringBuilder.toString();
        }
        stringBuilder.insert(0, " > ");
        if (this.parent().select(stringBuilder.toString()).size() > 1) {
            stringBuilder.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return this.parent().cssSelector() + stringBuilder.toString();
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        Elements elements = this.parent().children();
        Elements elements2 = new Elements(elements.size() - 1);
        for (Element element : elements) {
            if (element == this) continue;
            elements2.add(element);
        }
        return elements2;
    }

    public Element nextElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        Elements elements = this.parent().children();
        Integer n = Element.indexInList(this, elements);
        Validate.notNull(n);
        if (elements.size() > n + 1) {
            return (Element)elements.get(n + 1);
        }
        return null;
    }

    public Element previousElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        Elements elements = this.parent().children();
        Integer n = Element.indexInList(this, elements);
        Validate.notNull(n);
        if (n > 0) {
            return (Element)elements.get(n - 1);
        }
        return null;
    }

    public Element firstElementSibling() {
        Elements elements = this.parent().children();
        return elements.size() > 1 ? (Element)elements.get(0) : null;
    }

    public Integer elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().children());
    }

    public Element lastElementSibling() {
        Elements elements = this.parent().children();
        return elements.size() > 1 ? (Element)elements.get(elements.size() - 1) : null;
    }

    private static <E extends Element> Integer indexInList(Element element, List<E> list) {
        Validate.notNull(element);
        Validate.notNull(list);
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            if (element2 != element) continue;
            return i;
        }
        return null;
    }

    public Elements getElementsByTag(String string) {
        Validate.notEmpty(string);
        string = string.toLowerCase().trim();
        return Collector.collect(new Evaluator.Tag(string), this);
    }

    public Element getElementById(String string) {
        Validate.notEmpty(string);
        Elements elements = Collector.collect(new Evaluator.Id(string), this);
        if (elements.size() > 0) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String string) {
        Validate.notEmpty(string);
        return Collector.collect(new Evaluator.Class(string), this);
    }

    public Elements getElementsByAttribute(String string) {
        Validate.notEmpty(string);
        string = string.trim().toLowerCase();
        return Collector.collect(new Evaluator.Attribute(string), this);
    }

    public Elements getElementsByAttributeStarting(String string) {
        Validate.notEmpty(string);
        string = string.trim().toLowerCase();
        return Collector.collect(new Evaluator.AttributeStarting(string), this);
    }

    public Elements getElementsByAttributeValue(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValue(string, string2), this);
    }

    public Elements getElementsByAttributeValueNot(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(string, string2), this);
    }

    public Elements getElementsByAttributeValueStarting(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(string, string2), this);
    }

    public Elements getElementsByAttributeValueEnding(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(string, string2), this);
    }

    public Elements getElementsByAttributeValueContaining(String string, String string2) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(string, string2), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(string, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String string, String string2) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string2, patternSyntaxException);
        }
        return this.getElementsByAttributeValueMatching(string, pattern);
    }

    public Elements getElementsByIndexLessThan(int n) {
        return Collector.collect(new Evaluator.IndexLessThan(n), this);
    }

    public Elements getElementsByIndexGreaterThan(int n) {
        return Collector.collect(new Evaluator.IndexGreaterThan(n), this);
    }

    public Elements getElementsByIndexEquals(int n) {
        return Collector.collect(new Evaluator.IndexEquals(n), this);
    }

    public Elements getElementsContainingText(String string) {
        return Collector.collect(new Evaluator.ContainsText(string), this);
    }

    public Elements getElementsContainingOwnText(String string) {
        return Collector.collect(new Evaluator.ContainsOwnText(string), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string, patternSyntaxException);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String string) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Pattern syntax error: " + string, patternSyntaxException);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        final StringBuilder stringBuilder = new StringBuilder();
        new NodeTraversor(new NodeVisitor(){

            public void head(Node node, int n) {
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    Element.appendNormalisedText(stringBuilder, textNode);
                } else if (node instanceof Element) {
                    Element element = (Element)node;
                    if (stringBuilder.length() > 0 && (element.isBlock() || element.tag.getName().equals("br")) && !TextNode.lastCharIsWhitespace(stringBuilder)) {
                        stringBuilder.append(" ");
                    }
                }
            }

            public void tail(Node node, int n) {
            }
        }).traverse(this);
        return stringBuilder.toString().trim();
    }

    public String ownText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.ownText(stringBuilder);
        return stringBuilder.toString().trim();
    }

    private void ownText(StringBuilder stringBuilder) {
        for (Node node : this.childNodes) {
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Element.appendNormalisedText(stringBuilder, textNode);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element.appendWhitespaceIfBr((Element)node, stringBuilder);
        }
    }

    private static void appendNormalisedText(StringBuilder stringBuilder, TextNode textNode) {
        String string = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode)) {
            stringBuilder.append(string);
        } else {
            StringUtil.appendNormalisedWhitespace(stringBuilder, string, TextNode.lastCharIsWhitespace(stringBuilder));
        }
    }

    private static void appendWhitespaceIfBr(Element element, StringBuilder stringBuilder) {
        if (element.tag.getName().equals("br") && !TextNode.lastCharIsWhitespace(stringBuilder)) {
            stringBuilder.append(" ");
        }
    }

    static boolean preserveWhitespace(Node node) {
        if (node != null && node instanceof Element) {
            Element element = (Element)node;
            return element.tag.preserveWhitespace() || element.parent() != null && element.parent().tag.preserveWhitespace();
        }
        return false;
    }

    public Element text(String string) {
        Validate.notNull(string);
        this.empty();
        TextNode textNode = new TextNode(string, this.baseUri);
        this.appendChild(textNode);
        return this;
    }

    public boolean hasText() {
        for (Node node : this.childNodes) {
            Node node2;
            if (!(node instanceof TextNode ? !((TextNode)(node2 = (TextNode)node)).isBlank() : node instanceof Element && ((Element)(node2 = (Element)node)).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : this.childNodes) {
            Node node2;
            if (node instanceof DataNode) {
                node2 = (DataNode)node;
                stringBuilder.append(((DataNode)node2).getWholeData());
                continue;
            }
            if (!(node instanceof Element)) continue;
            node2 = (Element)node;
            String string = ((Element)node2).data();
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set<String> classNames() {
        String[] stringArray = classSplit.split(this.className());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        linkedHashSet.remove("");
        return linkedHashSet;
    }

    public Element classNames(Set<String> set) {
        Validate.notNull(set);
        this.attributes.put("class", StringUtil.join(set, " "));
        return this;
    }

    public boolean hasClass(String string) {
        String[] stringArray;
        String string2 = this.attributes.get("class");
        if (string2.equals("") || string2.length() < string.length()) {
            return false;
        }
        for (String string3 : stringArray = classSplit.split(string2)) {
            if (!string.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    public Element addClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        set.add(string);
        this.classNames(set);
        return this;
    }

    public Element removeClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        set.remove(string);
        this.classNames(set);
        return this;
    }

    public Element toggleClass(String string) {
        Validate.notNull(string);
        Set<String> set = this.classNames();
        if (set.contains(string)) {
            set.remove(string);
        } else {
            set.add(string);
        }
        this.classNames(set);
        return this;
    }

    public String val() {
        if (this.tagName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String string) {
        if (this.tagName().equals("textarea")) {
            this.text(string);
        } else {
            this.attr("value", string);
        }
        return this;
    }

    @Override
    void outerHtmlHead(Appendable appendable, int n, Document.OutputSettings outputSettings) {
        if (outputSettings.prettyPrint() && (this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || outputSettings.outline())) {
            if (appendable instanceof StringBuilder) {
                if (((StringBuilder)appendable).length() > 0) {
                    this.indent(appendable, n, outputSettings);
                }
            } else {
                this.indent(appendable, n, outputSettings);
            }
        }
        appendable.append("<").append(this.tagName());
        this.attributes.html(appendable, outputSettings);
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            if (outputSettings.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                appendable.append('>');
            } else {
                appendable.append(" />");
            }
        } else {
            appendable.append(">");
        }
    }

    @Override
    void outerHtmlTail(Appendable appendable, int n, Document.OutputSettings outputSettings) {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (outputSettings.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() || outputSettings.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && !(this.childNodes.get(0) instanceof TextNode)))) {
                this.indent(appendable, n, outputSettings);
            }
            appendable.append("</").append(this.tagName()).append(">");
        }
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        this.html(stringBuilder);
        return this.getOutputSettings().prettyPrint() ? stringBuilder.toString().trim() : stringBuilder.toString();
    }

    private void html(StringBuilder stringBuilder) {
        for (Node node : this.childNodes) {
            node.outerHtml(stringBuilder);
        }
    }

    @Override
    public <T extends Appendable> T html(T t) {
        for (Node node : this.childNodes) {
            node.outerHtml(t);
        }
        return t;
    }

    public Element html(String string) {
        this.empty();
        this.append(string);
        return this;
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }
}

