/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;

public class DocumentType
extends Node {
    private static final String NAME = "name";
    private static final String PUBLIC_ID = "publicId";
    private static final String SYSTEM_ID = "systemId";

    public DocumentType(String string, String string2, String string3, String string4) {
        super(string4);
        this.attr(NAME, string);
        this.attr(PUBLIC_ID, string2);
        this.attr(SYSTEM_ID, string3);
    }

    public String nodeName() {
        return "#doctype";
    }

    void outerHtmlHead(Appendable appendable, int n, Document.OutputSettings outputSettings) {
        if (outputSettings.syntax() == Document.OutputSettings.Syntax.html && !this.has(PUBLIC_ID) && !this.has(SYSTEM_ID)) {
            appendable.append("<!doctype");
        } else {
            appendable.append("<!DOCTYPE");
        }
        if (this.has(NAME)) {
            appendable.append(" ").append(this.attr(NAME));
        }
        if (this.has(PUBLIC_ID)) {
            appendable.append(" PUBLIC \"").append(this.attr(PUBLIC_ID)).append('\"');
        }
        if (this.has(SYSTEM_ID)) {
            appendable.append(" \"").append(this.attr(SYSTEM_ID)).append('\"');
        }
        appendable.append('>');
    }

    void outerHtmlTail(Appendable appendable, int n, Document.OutputSettings outputSettings) {
    }

    private boolean has(String string) {
        return !StringUtil.isBlank(this.attr(string));
    }
}

