/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements Cloneable,
Map.Entry<String, String> {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    private String key;
    private String value;

    public Attribute(String string, String string2) {
        Validate.notEmpty(string);
        Validate.notNull(string2);
        this.key = string.trim().toLowerCase();
        this.value = string2;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        Validate.notEmpty(string);
        this.key = string.trim().toLowerCase();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String string) {
        Validate.notNull(string);
        String string2 = this.value;
        this.value = string;
        return string2;
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.html(stringBuilder, new Document("").outputSettings());
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return stringBuilder.toString();
    }

    protected void html(Appendable appendable, Document.OutputSettings outputSettings) {
        appendable.append(this.key);
        if (!this.shouldCollapseAttribute(outputSettings)) {
            appendable.append("=\"");
            Entities.escape(appendable, this.value, outputSettings, true, false, false);
            appendable.append('\"');
        }
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String string, String string2) {
        String string3 = Entities.unescape(string2, true);
        return new Attribute(string, string3);
    }

    protected boolean isDataAttribute() {
        return this.key.startsWith("data-") && this.key.length() > "data-".length();
    }

    protected final boolean shouldCollapseAttribute(Document.OutputSettings outputSettings) {
        return ("".equals(this.value) || this.value.equalsIgnoreCase(this.key)) && outputSettings.syntax() == Document.OutputSettings.Syntax.html && this.isBooleanAttribute();
    }

    protected boolean isBooleanAttribute() {
        return Arrays.binarySearch(booleanAttributes, this.key) >= 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return !(this.value == null ? attribute.value != null : !this.value.equals(attribute.value));
    }

    @Override
    public int hashCode() {
        int n = this.key != null ? this.key.hashCode() : 0;
        n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
        return n;
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

