/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class W3CDom {
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public org.w3c.dom.Document fromJsoup(Document document) {
        Validate.notNull(document);
        try {
            this.factory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
            org.w3c.dom.Document document2 = documentBuilder.newDocument();
            this.convert(document, document2);
            return document2;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    public void convert(Document document, org.w3c.dom.Document document2) {
        if (!StringUtil.isBlank(document.location())) {
            document2.setDocumentURI(document.location());
        }
        org.jsoup.nodes.Element element = document.child(0);
        NodeTraversor nodeTraversor = new NodeTraversor(new W3CBuilder(document2));
        nodeTraversor.traverse(element);
    }

    public String asString(org.w3c.dom.Document document) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException);
        }
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final org.w3c.dom.Document doc;
        private final HashMap<String, String> namespaces = new HashMap();
        private Element dest;

        public W3CBuilder(org.w3c.dom.Document document) {
            this.doc = document;
        }

        public void head(Node node, int n) {
            if (node instanceof org.jsoup.nodes.Element) {
                org.jsoup.nodes.Element element = (org.jsoup.nodes.Element)node;
                String string = this.updateNamespaces(element);
                String string2 = this.namespaces.get(string);
                Element element2 = this.doc.createElementNS(string2, element.tagName());
                this.copyAttributes(element, element2);
                if (this.dest == null) {
                    this.doc.appendChild(element2);
                } else {
                    this.dest.appendChild(element2);
                }
                this.dest = element2;
            } else if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Text text = this.doc.createTextNode(textNode.getWholeText());
                this.dest.appendChild(text);
            } else if (node instanceof org.jsoup.nodes.Comment) {
                org.jsoup.nodes.Comment comment = (org.jsoup.nodes.Comment)node;
                Comment comment2 = this.doc.createComment(comment.getData());
                this.dest.appendChild(comment2);
            } else if (node instanceof DataNode) {
                DataNode dataNode = (DataNode)node;
                Text text = this.doc.createTextNode(dataNode.getWholeData());
                this.dest.appendChild(text);
            }
        }

        public void tail(Node node, int n) {
            if (node instanceof org.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = (Element)this.dest.getParentNode();
            }
        }

        private void copyAttributes(Node node, Element element) {
            for (Attribute attribute : node.attributes()) {
                element.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }

        private String updateNamespaces(org.jsoup.nodes.Element element) {
            Attributes attributes = element.attributes();
            for (Attribute attribute : attributes) {
                String string;
                String string2 = attribute.getKey();
                if (string2.equals(xmlnsKey)) {
                    string = "";
                } else {
                    if (!string2.startsWith(xmlnsPrefix)) continue;
                    string = string2.substring(xmlnsPrefix.length());
                }
                this.namespaces.put(string, attribute.getValue());
            }
            int n = element.tagName().indexOf(":");
            return n > 0 ? element.tagName().substring(0, n) : "";
        }
    }
}

