/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.parser.TokenQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnection
implements Connection {
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String FORM_URL_ENCODED = "application/x-www-form-urlencoded";
    private static final int HTTP_TEMP_REDIR = 307;
    private Connection.Request req = new Request();
    private Connection.Response res = new Response();

    public static Connection connect(String string) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(string);
        return httpConnection;
    }

    public static Connection connect(URL uRL) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(uRL);
        return httpConnection;
    }

    private static String encodeUrl(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(" ", "%20");
    }

    private static String encodeMimeName(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("\"", "%22");
    }

    private HttpConnection() {
    }

    @Override
    public Connection url(URL uRL) {
        this.req.url(uRL);
        return this;
    }

    @Override
    public Connection url(String string) {
        Validate.notEmpty(string, "Must supply a valid URL");
        try {
            this.req.url(new URL(HttpConnection.encodeUrl(string)));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Malformed URL: " + string, malformedURLException);
        }
        return this;
    }

    @Override
    public Connection proxy(Proxy proxy) {
        this.req.proxy(proxy);
        return this;
    }

    @Override
    public Connection proxy(String string, int n) {
        this.req.proxy(string, n);
        return this;
    }

    @Override
    public Connection userAgent(String string) {
        Validate.notNull(string, "User agent must not be null");
        this.req.header("User-Agent", string);
        return this;
    }

    @Override
    public Connection timeout(int n) {
        this.req.timeout(n);
        return this;
    }

    @Override
    public Connection maxBodySize(int n) {
        this.req.maxBodySize(n);
        return this;
    }

    @Override
    public Connection followRedirects(boolean bl) {
        this.req.followRedirects(bl);
        return this;
    }

    @Override
    public Connection referrer(String string) {
        Validate.notNull(string, "Referrer must not be null");
        this.req.header("Referer", string);
        return this;
    }

    @Override
    public Connection method(Connection.Method method) {
        this.req.method(method);
        return this;
    }

    @Override
    public Connection ignoreHttpErrors(boolean bl) {
        this.req.ignoreHttpErrors(bl);
        return this;
    }

    @Override
    public Connection ignoreContentType(boolean bl) {
        this.req.ignoreContentType(bl);
        return this;
    }

    @Override
    public Connection validateTLSCertificates(boolean bl) {
        this.req.validateTLSCertificates(bl);
        return this;
    }

    @Override
    public Connection data(String string, String string2) {
        this.req.data(KeyVal.create(string, string2));
        return this;
    }

    @Override
    public Connection data(String string, String string2, InputStream inputStream) {
        this.req.data(KeyVal.create(string, string2, inputStream));
        return this;
    }

    @Override
    public Connection data(Map<String, String> map) {
        Validate.notNull(map, "Data map must not be null");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.req.data(KeyVal.create(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    @Override
    public Connection data(String ... stringArray) {
        Validate.notNull(stringArray, "Data key value pairs must not be null");
        Validate.isTrue(stringArray.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            Validate.notEmpty(string, "Data key must not be empty");
            Validate.notNull(string2, "Data value must not be null");
            this.req.data(KeyVal.create(string, string2));
        }
        return this;
    }

    @Override
    public Connection data(Collection<Connection.KeyVal> collection) {
        Validate.notNull(collection, "Data collection must not be null");
        for (Connection.KeyVal keyVal : collection) {
            this.req.data(keyVal);
        }
        return this;
    }

    @Override
    public Connection.KeyVal data(String string) {
        Validate.notEmpty(string, "Data key must not be empty");
        for (Connection.KeyVal keyVal : this.request().data()) {
            if (!keyVal.key().equals(string)) continue;
            return keyVal;
        }
        return null;
    }

    @Override
    public Connection requestBody(String string) {
        this.req.requestBody(string);
        return this;
    }

    @Override
    public Connection header(String string, String string2) {
        this.req.header(string, string2);
        return this;
    }

    @Override
    public Connection cookie(String string, String string2) {
        this.req.cookie(string, string2);
        return this;
    }

    @Override
    public Connection cookies(Map<String, String> map) {
        Validate.notNull(map, "Cookie map must not be null");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.req.cookie(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection parser(Parser parser) {
        this.req.parser(parser);
        return this;
    }

    @Override
    public Document get() {
        this.req.method(Connection.Method.GET);
        this.execute();
        return this.res.parse();
    }

    @Override
    public Document post() {
        this.req.method(Connection.Method.POST);
        this.execute();
        return this.res.parse();
    }

    @Override
    public Connection.Response execute() {
        this.res = Response.execute(this.req);
        return this.res;
    }

    @Override
    public Connection.Request request() {
        return this.req;
    }

    @Override
    public Connection request(Connection.Request request) {
        this.req = request;
        return this;
    }

    @Override
    public Connection.Response response() {
        return this.res;
    }

    @Override
    public Connection response(Connection.Response response) {
        this.res = response;
        return this;
    }

    @Override
    public Connection postDataCharset(String string) {
        this.req.postDataCharset(string);
        return this;
    }

    private static boolean needsMultipart(Connection.Request request) {
        boolean bl = false;
        for (Connection.KeyVal keyVal : request.data()) {
            if (!keyVal.hasInputStream()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static class KeyVal
    implements Connection.KeyVal {
        private String key;
        private String value;
        private InputStream stream;

        public static KeyVal create(String string, String string2) {
            return new KeyVal().key(string).value(string2);
        }

        public static KeyVal create(String string, String string2, InputStream inputStream) {
            return new KeyVal().key(string).value(string2).inputStream(inputStream);
        }

        private KeyVal() {
        }

        public KeyVal key(String string) {
            Validate.notEmpty(string, "Data key must not be empty");
            this.key = string;
            return this;
        }

        public String key() {
            return this.key;
        }

        public KeyVal value(String string) {
            Validate.notNull(string, "Data value must not be null");
            this.value = string;
            return this;
        }

        public String value() {
            return this.value;
        }

        public KeyVal inputStream(InputStream inputStream) {
            Validate.notNull(this.value, "Data input stream must not be null");
            this.stream = inputStream;
            return this;
        }

        public InputStream inputStream() {
            return this.stream;
        }

        public boolean hasInputStream() {
            return this.stream != null;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response
    extends Base<Connection.Response>
    implements Connection.Response {
        private static final int MAX_REDIRECTS = 20;
        private static SSLSocketFactory sslSocketFactory;
        private static final String LOCATION = "Location";
        private int statusCode;
        private String statusMessage;
        private ByteBuffer byteData;
        private String charset;
        private String contentType;
        private boolean executed = false;
        private int numRedirects = 0;
        private Connection.Request req;
        private static final Pattern xmlContentTypeRxp;

        Response() {
        }

        private Response(Response response) {
            if (response != null) {
                this.numRedirects = response.numRedirects + 1;
                if (this.numRedirects >= 20) {
                    throw new IOException(String.format("Too many redirects occurred trying to load URL %s", response.url()));
                }
            }
        }

        static Response execute(Connection.Request request) {
            return Response.execute(request, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Response execute(Connection.Request request, Response response) {
            Response response2;
            block23: {
                boolean bl;
                Validate.notNull(request, "Request must not be null");
                String string = request.url().getProtocol();
                if (!string.equals("http") && !string.equals("https")) {
                    throw new MalformedURLException("Only http & https protocols supported");
                }
                boolean bl2 = request.method().hasBody();
                boolean bl3 = bl = request.requestBody() != null;
                if (!bl2) {
                    Validate.isFalse(bl, "Cannot set a request body for HTTP method " + (Object)((Object)request.method()));
                }
                String string2 = null;
                if (request.data().size() > 0 && (!bl2 || bl)) {
                    Response.serialiseRequestUrl(request);
                } else if (bl2) {
                    string2 = Response.setOutputContentType(request);
                }
                HttpURLConnection httpURLConnection = Response.createConnection(request);
                try {
                    httpURLConnection.connect();
                    if (httpURLConnection.getDoOutput()) {
                        Response.writePost(request, httpURLConnection.getOutputStream(), string2);
                    }
                    int n = httpURLConnection.getResponseCode();
                    response2 = new Response(response);
                    response2.setupFromConnection(httpURLConnection, response);
                    response2.req = request;
                    if (response2.hasHeader(LOCATION) && request.followRedirects()) {
                        String string3;
                        if (n != 307) {
                            request.method(Connection.Method.GET);
                            request.data().clear();
                        }
                        if ((string3 = response2.header(LOCATION)) != null && string3.startsWith("http:/") && string3.charAt(6) != '/') {
                            string3 = string3.substring(6);
                        }
                        request.url(StringUtil.resolve(request.url(), HttpConnection.encodeUrl(string3)));
                        for (Map.Entry entry : response2.cookies.entrySet()) {
                            request.cookie((String)entry.getKey(), (String)entry.getValue());
                        }
                        Response response3 = Response.execute(request, response2);
                        return response3;
                    }
                    if (!(n >= 200 && n < 400 || request.ignoreHttpErrors())) {
                        throw new HttpStatusException("HTTP error fetching URL", n, request.url().toString());
                    }
                    String string4 = response2.contentType();
                    if (!(string4 == null || request.ignoreContentType() || string4.startsWith("text/") || xmlContentTypeRxp.matcher(string4).matches())) {
                        throw new UnsupportedMimeTypeException("Unhandled content type. Must be text/*, application/xml, or application/xhtml+xml", string4, request.url().toString());
                    }
                    if (string4 != null && xmlContentTypeRxp.matcher(string4).matches() && request instanceof Request && !((Request)request).parserDefined) {
                        request.parser(Parser.xmlParser());
                    }
                    response2.charset = DataUtil.getCharsetFromContentType(response2.contentType);
                    if (httpURLConnection.getContentLength() != 0 && request.method() != Connection.Method.HEAD) {
                        InputStream inputStream = null;
                        try {
                            InputStream inputStream2 = inputStream = httpURLConnection.getErrorStream() != null ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                            if (response2.hasHeaderWithValue(HttpConnection.CONTENT_ENCODING, "gzip")) {
                                inputStream = new GZIPInputStream(inputStream);
                            }
                            response2.byteData = DataUtil.readToByteBuffer(inputStream, request.maxBodySize());
                            break block23;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    response2.byteData = DataUtil.emptyByteBuffer();
                }
                finally {
                    httpURLConnection.disconnect();
                }
            }
            response2.executed = true;
            return response2;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public String statusMessage() {
            return this.statusMessage;
        }

        @Override
        public String charset() {
            return this.charset;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        @Override
        public Document parse() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before parsing response");
            Document document = DataUtil.parseByteData(this.byteData, this.charset, this.url.toExternalForm(), this.req.parser());
            this.byteData.rewind();
            this.charset = document.outputSettings().charset().name();
            return document;
        }

        @Override
        public String body() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            String string = this.charset == null ? Charset.forName("UTF-8").decode(this.byteData).toString() : Charset.forName(this.charset).decode(this.byteData).toString();
            this.byteData.rewind();
            return string;
        }

        @Override
        public byte[] bodyAsBytes() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            return this.byteData.array();
        }

        private static HttpURLConnection createConnection(Connection.Request request) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)(request.proxy() == null ? request.url().openConnection() : request.url().openConnection(request.proxy()));
            httpURLConnection.setRequestMethod(request.method().name());
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setConnectTimeout(request.timeout());
            httpURLConnection.setReadTimeout(request.timeout());
            if (httpURLConnection instanceof HttpsURLConnection && !request.validateTLSCertificates()) {
                Response.initUnSecureTSL();
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sslSocketFactory);
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(Response.getInsecureVerifier());
            }
            if (request.method().hasBody()) {
                httpURLConnection.setDoOutput(true);
            }
            if (request.cookies().size() > 0) {
                httpURLConnection.addRequestProperty("Cookie", Response.getRequestCookieString(request));
            }
            for (Map.Entry<String, String> entry : request.headers().entrySet()) {
                httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            return httpURLConnection;
        }

        private static HostnameVerifier getInsecureVerifier() {
            return new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
        }

        private static synchronized void initUnSecureTSL() {
            if (sslSocketFactory == null) {
                TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                }};
                try {
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(null, trustManagerArray, new SecureRandom());
                    sslSocketFactory = sSLContext.getSocketFactory();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new IOException("Can't create unsecure trust manager");
                }
                catch (KeyManagementException keyManagementException) {
                    throw new IOException("Can't create unsecure trust manager");
                }
            }
        }

        private void setupFromConnection(HttpURLConnection httpURLConnection, Connection.Response response) {
            this.method = Connection.Method.valueOf(httpURLConnection.getRequestMethod());
            this.url = httpURLConnection.getURL();
            this.statusCode = httpURLConnection.getResponseCode();
            this.statusMessage = httpURLConnection.getResponseMessage();
            this.contentType = httpURLConnection.getContentType();
            LinkedHashMap<String, List<String>> linkedHashMap = Response.createHeaderMap(httpURLConnection);
            this.processResponseHeaders(linkedHashMap);
            if (response != null) {
                for (Map.Entry<String, String> entry : response.cookies().entrySet()) {
                    if (this.hasCookie(entry.getKey())) continue;
                    this.cookie(entry.getKey(), entry.getValue());
                }
            }
        }

        private static LinkedHashMap<String, List<String>> createHeaderMap(HttpURLConnection httpURLConnection) {
            LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
            int n = 0;
            while (true) {
                String string = httpURLConnection.getHeaderFieldKey(n);
                String string2 = httpURLConnection.getHeaderField(n);
                if (string == null && string2 == null) break;
                ++n;
                if (string == null || string2 == null) continue;
                if (linkedHashMap.containsKey(string)) {
                    linkedHashMap.get(string).add(string2);
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                linkedHashMap.put(string, arrayList);
            }
            return linkedHashMap;
        }

        void processResponseHeaders(Map<String, List<String>> map) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                Object object;
                String string = entry.getKey();
                if (string == null) continue;
                List<String> list = entry.getValue();
                if (string.equalsIgnoreCase("Set-Cookie")) {
                    for (String string2 : list) {
                        if (string2 == null) continue;
                        object = new TokenQueue(string2);
                        String string3 = ((TokenQueue)object).chompTo("=").trim();
                        String string4 = ((TokenQueue)object).consumeTo(";").trim();
                        if (string3.length() <= 0) continue;
                        this.cookie(string3, string4);
                    }
                    continue;
                }
                if (list.size() == 1) {
                    this.header(string, list.get(0));
                    continue;
                }
                if (list.size() <= 1) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    object = list.get(i);
                    if (i != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append((String)object);
                }
                this.header(string, stringBuilder.toString());
            }
        }

        private static String setOutputContentType(Connection.Request request) {
            String string = null;
            if (HttpConnection.needsMultipart(request)) {
                string = DataUtil.mimeBoundary();
                request.header(HttpConnection.CONTENT_TYPE, "multipart/form-data; boundary=" + string);
            } else {
                request.header(HttpConnection.CONTENT_TYPE, "application/x-www-form-urlencoded; charset=" + request.postDataCharset());
            }
            return string;
        }

        private static void writePost(Connection.Request request, OutputStream outputStream, String string) {
            Collection<Connection.KeyVal> collection = request.data();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, request.postDataCharset()));
            if (string != null) {
                for (Connection.KeyVal keyVal : collection) {
                    bufferedWriter.write("--");
                    bufferedWriter.write(string);
                    bufferedWriter.write("\r\n");
                    bufferedWriter.write("Content-Disposition: form-data; name=\"");
                    bufferedWriter.write(HttpConnection.encodeMimeName(keyVal.key()));
                    bufferedWriter.write("\"");
                    if (keyVal.hasInputStream()) {
                        bufferedWriter.write("; filename=\"");
                        bufferedWriter.write(HttpConnection.encodeMimeName(keyVal.value()));
                        bufferedWriter.write("\"\r\nContent-Type: application/octet-stream\r\n\r\n");
                        bufferedWriter.flush();
                        DataUtil.crossStreams(keyVal.inputStream(), outputStream);
                        outputStream.flush();
                    } else {
                        bufferedWriter.write("\r\n\r\n");
                        bufferedWriter.write(keyVal.value());
                    }
                    bufferedWriter.write("\r\n");
                }
                bufferedWriter.write("--");
                bufferedWriter.write(string);
                bufferedWriter.write("--");
            } else if (request.requestBody() != null) {
                bufferedWriter.write(request.requestBody());
            } else {
                boolean bl = true;
                for (Connection.KeyVal keyVal : collection) {
                    if (!bl) {
                        bufferedWriter.append('&');
                    } else {
                        bl = false;
                    }
                    bufferedWriter.write(URLEncoder.encode(keyVal.key(), request.postDataCharset()));
                    bufferedWriter.write(61);
                    bufferedWriter.write(URLEncoder.encode(keyVal.value(), request.postDataCharset()));
                }
            }
            bufferedWriter.close();
        }

        private static String getRequestCookieString(Connection.Request request) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (Map.Entry<String, String> entry : request.cookies().entrySet()) {
                if (!bl) {
                    stringBuilder.append("; ");
                } else {
                    bl = false;
                }
                stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
            }
            return stringBuilder.toString();
        }

        private static void serialiseRequestUrl(Connection.Request request) {
            URL uRL = request.url();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            stringBuilder.append(uRL.getProtocol()).append("://").append(uRL.getAuthority()).append(uRL.getPath()).append("?");
            if (uRL.getQuery() != null) {
                stringBuilder.append(uRL.getQuery());
                bl = false;
            }
            for (Connection.KeyVal keyVal : request.data()) {
                Validate.isFalse(keyVal.hasInputStream(), "InputStream data not supported in URL query string.");
                if (!bl) {
                    stringBuilder.append('&');
                } else {
                    bl = false;
                }
                stringBuilder.append(URLEncoder.encode(keyVal.key(), "UTF-8")).append('=').append(URLEncoder.encode(keyVal.value(), "UTF-8"));
            }
            request.url(new URL(stringBuilder.toString()));
            request.data().clear();
        }

        static {
            xmlContentTypeRxp = Pattern.compile("(application|text)/\\w*\\+?xml.*");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    extends Base<Connection.Request>
    implements Connection.Request {
        private Proxy proxy;
        private int timeoutMilliseconds = 3000;
        private int maxBodySizeBytes = 0x100000;
        private boolean followRedirects = true;
        private Collection<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
        private String body = null;
        private boolean ignoreHttpErrors = false;
        private boolean ignoreContentType = false;
        private Parser parser;
        private boolean parserDefined = false;
        private boolean validateTSLCertificates = true;
        private String postDataCharset = "UTF-8";

        private Request() {
            this.method = Connection.Method.GET;
            this.headers.put("Accept-Encoding", "gzip");
            this.parser = Parser.htmlParser();
        }

        @Override
        public Proxy proxy() {
            return this.proxy;
        }

        @Override
        public Request proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @Override
        public Request proxy(String string, int n) {
            this.proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(string, n));
            return this;
        }

        @Override
        public int timeout() {
            return this.timeoutMilliseconds;
        }

        @Override
        public Request timeout(int n) {
            Validate.isTrue(n >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
            this.timeoutMilliseconds = n;
            return this;
        }

        @Override
        public int maxBodySize() {
            return this.maxBodySizeBytes;
        }

        @Override
        public Connection.Request maxBodySize(int n) {
            Validate.isTrue(n >= 0, "maxSize must be 0 (unlimited) or larger");
            this.maxBodySizeBytes = n;
            return this;
        }

        @Override
        public boolean followRedirects() {
            return this.followRedirects;
        }

        @Override
        public Connection.Request followRedirects(boolean bl) {
            this.followRedirects = bl;
            return this;
        }

        @Override
        public boolean ignoreHttpErrors() {
            return this.ignoreHttpErrors;
        }

        @Override
        public boolean validateTLSCertificates() {
            return this.validateTSLCertificates;
        }

        @Override
        public void validateTLSCertificates(boolean bl) {
            this.validateTSLCertificates = bl;
        }

        @Override
        public Connection.Request ignoreHttpErrors(boolean bl) {
            this.ignoreHttpErrors = bl;
            return this;
        }

        @Override
        public boolean ignoreContentType() {
            return this.ignoreContentType;
        }

        @Override
        public Connection.Request ignoreContentType(boolean bl) {
            this.ignoreContentType = bl;
            return this;
        }

        @Override
        public Request data(Connection.KeyVal keyVal) {
            Validate.notNull(keyVal, "Key val must not be null");
            this.data.add(keyVal);
            return this;
        }

        @Override
        public Collection<Connection.KeyVal> data() {
            return this.data;
        }

        @Override
        public Connection.Request requestBody(String string) {
            this.body = string;
            return this;
        }

        @Override
        public String requestBody() {
            return this.body;
        }

        @Override
        public Request parser(Parser parser) {
            this.parser = parser;
            this.parserDefined = true;
            return this;
        }

        @Override
        public Parser parser() {
            return this.parser;
        }

        @Override
        public Connection.Request postDataCharset(String string) {
            Validate.notNull(string, "Charset must not be null");
            if (!Charset.isSupported(string)) {
                throw new IllegalCharsetNameException(string);
            }
            this.postDataCharset = string;
            return this;
        }

        @Override
        public String postDataCharset() {
            return this.postDataCharset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Base<T extends Connection.Base>
    implements Connection.Base<T> {
        URL url;
        Connection.Method method;
        Map<String, String> headers = new LinkedHashMap<String, String>();
        Map<String, String> cookies = new LinkedHashMap<String, String>();

        private Base() {
        }

        @Override
        public URL url() {
            return this.url;
        }

        @Override
        public T url(URL uRL) {
            Validate.notNull(uRL, "URL must not be null");
            this.url = uRL;
            return (T)this;
        }

        @Override
        public Connection.Method method() {
            return this.method;
        }

        @Override
        public T method(Connection.Method method) {
            Validate.notNull((Object)method, "Method must not be null");
            this.method = method;
            return (T)this;
        }

        @Override
        public String header(String string) {
            Validate.notNull(string, "Header name must not be null");
            return this.getHeaderCaseInsensitive(string);
        }

        @Override
        public T header(String string, String string2) {
            Validate.notEmpty(string, "Header name must not be empty");
            Validate.notNull(string2, "Header value must not be null");
            this.removeHeader(string);
            this.headers.put(string, string2);
            return (T)this;
        }

        @Override
        public boolean hasHeader(String string) {
            Validate.notEmpty(string, "Header name must not be empty");
            return this.getHeaderCaseInsensitive(string) != null;
        }

        @Override
        public boolean hasHeaderWithValue(String string, String string2) {
            return this.hasHeader(string) && this.header(string).equalsIgnoreCase(string2);
        }

        @Override
        public T removeHeader(String string) {
            Validate.notEmpty(string, "Header name must not be empty");
            Map.Entry<String, String> entry = this.scanHeaders(string);
            if (entry != null) {
                this.headers.remove(entry.getKey());
            }
            return (T)this;
        }

        @Override
        public Map<String, String> headers() {
            return this.headers;
        }

        private String getHeaderCaseInsensitive(String string) {
            Map.Entry<String, String> entry;
            Validate.notNull(string, "Header name must not be null");
            String string2 = this.headers.get(string);
            if (string2 == null) {
                string2 = this.headers.get(string.toLowerCase());
            }
            if (string2 == null && (entry = this.scanHeaders(string)) != null) {
                string2 = entry.getValue();
            }
            return string2;
        }

        private Map.Entry<String, String> scanHeaders(String string) {
            String string2 = string.toLowerCase();
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                if (!entry.getKey().toLowerCase().equals(string2)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public String cookie(String string) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            return this.cookies.get(string);
        }

        @Override
        public T cookie(String string, String string2) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            Validate.notNull(string2, "Cookie value must not be null");
            this.cookies.put(string, string2);
            return (T)this;
        }

        @Override
        public boolean hasCookie(String string) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            return this.cookies.containsKey(string);
        }

        @Override
        public T removeCookie(String string) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            this.cookies.remove(string);
            return (T)this;
        }

        @Override
        public Map<String, String> cookies() {
            return this.cookies;
        }
    }
}

