/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;

public final class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:\"|')?([^\\s,;\"']*)");
    static final String defaultCharset = "UTF-8";
    private static final int bufferSize = 131072;
    private static final int UNICODE_BOM = 65279;
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final int boundaryLength = 32;

    private DataUtil() {
    }

    public static Document load(File file, String string, String string2) {
        ByteBuffer byteBuffer = DataUtil.readFileToByteBuffer(file);
        return DataUtil.parseByteData(byteBuffer, string, string2, Parser.htmlParser());
    }

    public static Document load(InputStream inputStream, String string, String string2) {
        ByteBuffer byteBuffer = DataUtil.readToByteBuffer(inputStream);
        return DataUtil.parseByteData(byteBuffer, string, string2, Parser.htmlParser());
    }

    public static Document load(InputStream inputStream, String string, String string2, Parser parser) {
        ByteBuffer byteBuffer = DataUtil.readToByteBuffer(inputStream);
        return DataUtil.parseByteData(byteBuffer, string, string2, parser);
    }

    static void crossStreams(InputStream inputStream, OutputStream outputStream) {
        int n;
        byte[] byArray = new byte[131072];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    static Document parseByteData(ByteBuffer byteBuffer, String string, String string2, Parser parser) {
        String string3;
        Document document = null;
        if ((string = DataUtil.detectCharsetFromBom(byteBuffer, string)) == null) {
            XmlDeclaration xmlDeclaration;
            string3 = Charset.forName(defaultCharset).decode(byteBuffer).toString();
            document = parser.parseInput(string3, string2);
            Element element = document.select("meta[http-equiv=content-type], meta[charset]").first();
            String string4 = null;
            if (element != null) {
                if (element.hasAttr("http-equiv")) {
                    string4 = DataUtil.getCharsetFromContentType(element.attr("content"));
                }
                if (string4 == null && element.hasAttr("charset")) {
                    string4 = element.attr("charset");
                }
            }
            if (string4 == null && document.childNode(0) instanceof XmlDeclaration && (xmlDeclaration = (XmlDeclaration)document.childNode(0)).name().equals("xml")) {
                string4 = xmlDeclaration.attr("encoding");
            }
            if ((string4 = DataUtil.validateCharset(string4)) != null && !string4.equals(defaultCharset)) {
                string = string4 = string4.trim().replaceAll("[\"']", "");
                byteBuffer.rewind();
                string3 = Charset.forName(string4).decode(byteBuffer).toString();
                document = null;
            }
        } else {
            Validate.notEmpty(string, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
            string3 = Charset.forName(string).decode(byteBuffer).toString();
        }
        if (document == null) {
            document = parser.parseInput(string3, string2);
            document.outputSettings().charset(string);
        }
        return document;
    }

    static ByteBuffer readToByteBuffer(InputStream inputStream, int n) {
        int n2;
        Validate.isTrue(n >= 0, "maxSize must be 0 (unlimited) or larger");
        boolean bl = n > 0;
        byte[] byArray = new byte[131072];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(131072);
        int n3 = n;
        while ((n2 = inputStream.read(byArray)) != -1) {
            if (bl) {
                if (n2 > n3) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                    break;
                }
                n3 -= n2;
            }
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    static ByteBuffer readToByteBuffer(InputStream inputStream) {
        return DataUtil.readToByteBuffer(inputStream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuffer readFileToByteBuffer(File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            return byteBuffer;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    static ByteBuffer emptyByteBuffer() {
        return ByteBuffer.allocate(0);
    }

    static String getCharsetFromContentType(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = charsetPattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1).trim();
            string2 = string2.replace("charset=", "");
            return DataUtil.validateCharset(string2);
        }
        return null;
    }

    private static String validateCharset(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        string = string.trim().replaceAll("[\"']", "");
        try {
            if (Charset.isSupported(string)) {
                return string;
            }
            if (Charset.isSupported(string = string.toUpperCase(Locale.ENGLISH))) {
                return string;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return null;
    }

    static String mimeBoundary() {
        StringBuilder stringBuilder = new StringBuilder(32);
        Random random = new Random();
        for (int i = 0; i < 32; ++i) {
            stringBuilder.append(mimeBoundaryChars[random.nextInt(mimeBoundaryChars.length)]);
        }
        return stringBuilder.toString();
    }

    private static String detectCharsetFromBom(ByteBuffer byteBuffer, String string) {
        byteBuffer.mark();
        byte[] byArray = new byte[4];
        if (byteBuffer.remaining() >= byArray.length) {
            byteBuffer.get(byArray);
            byteBuffer.rewind();
        }
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1 || byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            string = "UTF-32";
        } else if (byArray[0] == -2 && byArray[1] == -1 || byArray[0] == -1 && byArray[1] == -2) {
            string = "UTF-16";
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            string = defaultCharset;
            byteBuffer.position(3);
        }
        return string;
    }
}

