/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.examples;

import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainText {
    private static final String userAgent = "Mozilla/5.0 (jsoup)";
    private static final int timeout = 5000;

    public static void main(String ... stringArray) {
        Validate.isTrue(stringArray.length == 1 || stringArray.length == 2, "usage: java -cp jsoup.jar org.jsoup.examples.HtmlToPlainText url [selector]");
        String string = stringArray[0];
        String string2 = stringArray.length == 2 ? stringArray[1] : null;
        Document document = Jsoup.connect(string).userAgent(userAgent).timeout(5000).get();
        HtmlToPlainText htmlToPlainText = new HtmlToPlainText();
        if (string2 != null) {
            Elements elements = document.select(string2);
            for (Element element : elements) {
                String string3 = htmlToPlainText.getPlainText(element);
                System.out.println(string3);
            }
        } else {
            String string4 = htmlToPlainText.getPlainText(document);
            System.out.println(string4);
        }
    }

    public String getPlainText(Element element) {
        FormattingVisitor formattingVisitor = new FormattingVisitor();
        NodeTraversor nodeTraversor = new NodeTraversor(formattingVisitor);
        nodeTraversor.traverse(element);
        return formattingVisitor.toString();
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int n) {
            String string = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (string.equals("li")) {
                this.append("\n * ");
            } else if (string.equals("dt")) {
                this.append("  ");
            } else if (StringUtil.in(string, "p", "h1", "h2", "h3", "h4", "h5", "tr")) {
                this.append("\n");
            }
        }

        public void tail(Node node, int n) {
            String string = node.nodeName();
            if (StringUtil.in(string, "br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5")) {
                this.append("\n");
            } else if (string.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void append(String string) {
            if (string.startsWith("\n")) {
                this.width = 0;
            }
            if (string.equals(" ") && (this.accum.length() == 0 || StringUtil.in(this.accum.substring(this.accum.length() - 1), " ", "\n"))) {
                return;
            }
            if (string.length() + this.width > 80) {
                String[] stringArray = string.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl;
                    String string2 = stringArray[i];
                    boolean bl2 = bl = i == stringArray.length - 1;
                    if (!bl) {
                        string2 = string2 + " ";
                    }
                    if (string2.length() + this.width > 80) {
                        this.accum.append("\n").append(string2);
                        this.width = string2.length();
                        continue;
                    }
                    this.accum.append(string2);
                    this.width += string2.length();
                }
            } else {
                this.accum.append(string);
                this.width += string.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

