/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private static final Logger LOG = Log.getLogger(XmlParser.class);
    private Map<String, URL> _redirectMap = new HashMap<String, URL>();
    private SAXParser _parser;
    private Map<String, ContentHandler> _observerMap;
    private Stack<ContentHandler> _observers = new Stack();
    private String _xpath;
    private Object _xpaths;
    private String _dtd;

    public XmlParser() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        boolean bl = sAXParserFactory.getClass().toString().startsWith("org.apache.xerces.");
        String string = System.getProperty("org.eclipse.jetty.xml.XmlParser.Validating", bl ? "true" : "false");
        boolean bl2 = Boolean.valueOf(string);
        this.setValidating(bl2);
    }

    public XmlParser(boolean bl) {
        this.setValidating(bl);
    }

    public void setValidating(boolean bl) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            this._parser = sAXParserFactory.newSAXParser();
            try {
                if (bl) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", bl);
                }
            }
            catch (Exception exception) {
                if (bl) {
                    LOG.warn("Schema validation may not be supported: ", (Throwable)exception);
                }
                LOG.ignore((Throwable)exception);
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", bl);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", true);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            try {
                if (bl) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
                }
            }
            catch (Exception exception) {
                LOG.warn(exception.getMessage(), new Object[0]);
            }
        }
        catch (Exception exception) {
            LOG.warn("EXCEPTION ", (Throwable)exception);
            throw new Error(exception.toString());
        }
    }

    public boolean isValidating() {
        return this._parser.isValidating();
    }

    public synchronized void redirectEntity(String string, URL uRL) {
        if (uRL != null) {
            this._redirectMap.put(string, uRL);
        }
    }

    public String getXpath() {
        return this._xpath;
    }

    public void setXpath(String string) {
        this._xpath = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "| ");
        while (stringTokenizer.hasMoreTokens()) {
            this._xpaths = LazyList.add((Object)this._xpaths, (Object)stringTokenizer.nextToken());
        }
    }

    public String getDTD() {
        return this._dtd;
    }

    public synchronized void addContentHandler(String string, ContentHandler contentHandler) {
        if (this._observerMap == null) {
            this._observerMap = new HashMap<String, ContentHandler>();
        }
        this._observerMap.put(string, contentHandler);
    }

    public synchronized Node parse(InputSource inputSource) {
        this._dtd = null;
        Handler handler = new Handler();
        XMLReader xMLReader = this._parser.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("parsing: sid=" + inputSource.getSystemId() + ",pid=" + inputSource.getPublicId(), new Object[0]);
        }
        this._parser.parse(inputSource, (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    public synchronized Node parse(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parse: " + string, new Object[0]);
        }
        return this.parse(new InputSource(string));
    }

    public synchronized Node parse(File file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parse: " + file, new Object[0]);
        }
        return this.parse(new InputSource(Resource.toURL((File)file).toString()));
    }

    public synchronized Node parse(InputStream inputStream) {
        this._dtd = null;
        Handler handler = new Handler();
        XMLReader xMLReader = this._parser.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        this._parser.parse(new InputSource(inputStream), (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    protected InputSource resolveEntity(String string, String string2) {
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug("resolveEntity(" + string + ", " + string2 + ")", new Object[0]);
        }
        if (string2 != null && string2.endsWith(".dtd")) {
            this._dtd = string2;
        }
        URL uRL = null;
        if (string != null) {
            uRL = this._redirectMap.get(string);
        }
        if (uRL == null) {
            uRL = this._redirectMap.get(string2);
        }
        if (uRL == null) {
            object = string2;
            if (((String)object).lastIndexOf(47) >= 0) {
                object = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't exact match entity in redirect map, trying " + (String)object, new Object[0]);
            }
            uRL = this._redirectMap.get(object);
        }
        if (uRL != null) {
            try {
                object = uRL.openStream();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Redirected entity " + string2 + " --> " + uRL, new Object[0]);
                }
                InputSource inputSource = new InputSource((InputStream)object);
                inputSource.setSystemId(string2);
                return inputSource;
            }
            catch (IOException iOException) {
                LOG.ignore((Throwable)iOException);
            }
        }
        return null;
    }

    public static class Node
    extends AbstractList<Object> {
        Node _parent;
        private ArrayList<Object> _list;
        private String _tag;
        private Attribute[] _attrs;
        private boolean _lastString = false;
        private String _path;

        Node(Node node, String string, Attributes attributes) {
            this._parent = node;
            this._tag = string;
            if (attributes != null) {
                this._attrs = new Attribute[attributes.getLength()];
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getLocalName(i);
                    if (string2 == null || string2.equals("")) {
                        string2 = attributes.getQName(i);
                    }
                    this._attrs[i] = new Attribute(string2, attributes.getValue(i));
                }
            }
        }

        public Node getParent() {
            return this._parent;
        }

        public String getTag() {
            return this._tag;
        }

        public String getPath() {
            if (this._path == null) {
                this._path = this.getParent() != null && this.getParent().getTag() != null ? this.getParent().getPath() + "/" + this._tag : "/" + this._tag;
            }
            return this._path;
        }

        public Attribute[] getAttributes() {
            return this._attrs;
        }

        public String getAttribute(String string) {
            return this.getAttribute(string, null);
        }

        public String getAttribute(String string, String string2) {
            if (this._attrs == null || string == null) {
                return string2;
            }
            for (int i = 0; i < this._attrs.length; ++i) {
                if (!string.equals(this._attrs[i].getName())) continue;
                return this._attrs[i].getValue();
            }
            return string2;
        }

        @Override
        public int size() {
            if (this._list != null) {
                return this._list.size();
            }
            return 0;
        }

        @Override
        public Object get(int n) {
            if (this._list != null) {
                return this._list.get(n);
            }
            return null;
        }

        public Node get(String string) {
            if (this._list != null) {
                for (int i = 0; i < this._list.size(); ++i) {
                    Object object = this._list.get(i);
                    if (!(object instanceof Node)) continue;
                    Node node = (Node)object;
                    if (!string.equals(node._tag)) continue;
                    return node;
                }
            }
            return null;
        }

        @Override
        public void add(int n, Object object) {
            if (this._list == null) {
                this._list = new ArrayList();
            }
            if (object instanceof String) {
                if (this._lastString) {
                    int n2 = this._list.size() - 1;
                    this._list.set(n2, (String)this._list.get(n2) + object);
                } else {
                    this._list.add(n, object);
                }
                this._lastString = true;
            } else {
                this._lastString = false;
                this._list.add(n, object);
            }
        }

        @Override
        public void clear() {
            if (this._list != null) {
                this._list.clear();
            }
            this._list = null;
        }

        public String getString(String string, boolean bl, boolean bl2) {
            Node node = this.get(string);
            if (node == null) {
                return null;
            }
            String string2 = node.toString(bl);
            if (string2 != null && bl2) {
                string2 = string2.trim();
            }
            return string2;
        }

        @Override
        public synchronized String toString() {
            return this.toString(true);
        }

        public synchronized String toString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder, bl);
            return stringBuilder.toString();
        }

        public synchronized String toString(boolean bl, boolean bl2) {
            String string = this.toString(bl);
            if (string != null && bl2) {
                string = string.trim();
            }
            return string;
        }

        private synchronized void toString(StringBuilder stringBuilder, boolean bl) {
            int n;
            if (bl) {
                stringBuilder.append("<");
                stringBuilder.append(this._tag);
                if (this._attrs != null) {
                    for (n = 0; n < this._attrs.length; ++n) {
                        stringBuilder.append(' ');
                        stringBuilder.append(this._attrs[n].getName());
                        stringBuilder.append("=\"");
                        stringBuilder.append(this._attrs[n].getValue());
                        stringBuilder.append("\"");
                    }
                }
            }
            if (this._list != null) {
                if (bl) {
                    stringBuilder.append(">");
                }
                for (n = 0; n < this._list.size(); ++n) {
                    Object object = this._list.get(n);
                    if (object == null) continue;
                    if (object instanceof Node) {
                        ((Node)object).toString(stringBuilder, bl);
                        continue;
                    }
                    stringBuilder.append(object.toString());
                }
                if (bl) {
                    stringBuilder.append("</");
                    stringBuilder.append(this._tag);
                    stringBuilder.append(">");
                }
            } else if (bl) {
                stringBuilder.append("/>");
            }
        }

        public Iterator<Node> iterator(final String string) {
            return new Iterator<Node>(){
                int c = 0;
                Node _node;

                @Override
                public boolean hasNext() {
                    if (this._node != null) {
                        return true;
                    }
                    while (_list != null && this.c < _list.size()) {
                        Node node;
                        Object e = _list.get(this.c);
                        if (e instanceof Node && string.equals((node = (Node)e)._tag)) {
                            this._node = node;
                            return true;
                        }
                        ++this.c;
                    }
                    return false;
                }

                @Override
                public Node next() {
                    try {
                        if (this.hasNext()) {
                            Node node = this._node;
                            return node;
                        }
                        throw new NoSuchElementException();
                    }
                    finally {
                        this._node = null;
                        ++this.c;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }

    public static class Attribute {
        private String _name;
        private String _value;

        Attribute(String string, String string2) {
            this._name = string;
            this._value = string2;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }

    private class Handler
    extends DefaultHandler {
        Node _top;
        SAXParseException _error;
        private Node _context;
        private NoopHandler _noop;

        Handler() {
            this._context = this._top = new Node(null, null, null);
            this._noop = new NoopHandler(this);
        }

        void clear() {
            this._top = null;
            this._error = null;
            this._context = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            int n;
            Object object;
            String string4 = null;
            if (XmlParser.this._parser.isNamespaceAware()) {
                string4 = string2;
            }
            if (string4 == null || "".equals(string4)) {
                string4 = string3;
            }
            Node node = new Node(this._context, string4, attributes);
            if (XmlParser.this._xpaths != null) {
                object = node.getPath();
                n = 0;
                int n2 = LazyList.size((Object)XmlParser.this._xpaths);
                while (n == 0 && n2-- > 0) {
                    String string5 = (String)LazyList.get((Object)XmlParser.this._xpaths, (int)n2);
                    n = ((String)object).equals(string5) || string5.startsWith((String)object) && string5.length() > ((String)object).length() && string5.charAt(((String)object).length()) == '/' ? 1 : 0;
                }
                if (n != 0) {
                    this._context.add(node);
                    this._context = node;
                } else {
                    XmlParser.this._parser.getXMLReader().setContentHandler(this._noop);
                }
            } else {
                this._context.add(node);
                this._context = node;
            }
            object = null;
            if (XmlParser.this._observerMap != null) {
                object = (ContentHandler)XmlParser.this._observerMap.get(string4);
            }
            XmlParser.this._observers.push(object);
            for (n = 0; n < XmlParser.this._observers.size(); ++n) {
                if (XmlParser.this._observers.get(n) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(n)).startElement(string, string2, string3, attributes);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this._context = this._context._parent;
            for (int i = 0; i < XmlParser.this._observers.size(); ++i) {
                if (XmlParser.this._observers.get(i) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(i)).endElement(string, string2, string3);
            }
            XmlParser.this._observers.pop();
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            for (int i = 0; i < XmlParser.this._observers.size(); ++i) {
                if (XmlParser.this._observers.get(i) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(i)).ignorableWhitespace(cArray, n, n2);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this._context.add(new String(cArray, n, n2));
            for (int i = 0; i < XmlParser.this._observers.size(); ++i) {
                if (XmlParser.this._observers.get(i) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(i)).characters(cArray, n, n2);
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            LOG.debug("EXCEPTION ", (Throwable)sAXParseException);
            LOG.warn("WARNING@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString(), new Object[0]);
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            if (this._error == null) {
                this._error = sAXParseException;
            }
            LOG.debug("EXCEPTION ", (Throwable)sAXParseException);
            LOG.warn("ERROR@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString(), new Object[0]);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            this._error = sAXParseException;
            LOG.debug("EXCEPTION ", (Throwable)sAXParseException);
            LOG.warn("FATAL@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString(), new Object[0]);
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            return sAXParseException.getSystemId() + " line:" + sAXParseException.getLineNumber() + " col:" + sAXParseException.getColumnNumber();
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            return XmlParser.this.resolveEntity(string, string2);
        }
    }

    private class NoopHandler
    extends DefaultHandler {
        Handler _next;
        int _depth;

        NoopHandler(Handler handler) {
            this._next = handler;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            ++this._depth;
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (this._depth == 0) {
                XmlParser.this._parser.getXMLReader().setContentHandler(this._next);
            } else {
                --this._depth;
            }
        }
    }
}

