/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.ConfigurationProcessorFactory;
import org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.InputSource;

public class XmlConfiguration {
    private static final Logger LOG = Log.getLogger(XmlConfiguration.class);
    private static final Class<?>[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] __boxedPrimitives = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Class<?>[] __supportedCollections = new Class[]{ArrayList.class, ArrayQueue.class, HashSet.class, Queue.class, List.class, Set.class, Collection.class};
    private static final Iterable<ConfigurationProcessorFactory> __factoryLoader = ServiceLoader.load(ConfigurationProcessorFactory.class);
    private static final XmlParser __parser = XmlConfiguration.initParser();
    private final Map<String, Object> _idMap = new HashMap<String, Object>();
    private final Map<String, String> _propertyMap = new HashMap<String, String>();
    private final URL _url;
    private final String _dtd;
    private ConfigurationProcessor _processor;

    private static XmlParser initParser() {
        XmlParser xmlParser = new XmlParser();
        URL uRL = Loader.getResource(XmlConfiguration.class, (String)"org/eclipse/jetty/xml/configure_6_0.dtd");
        URL uRL2 = Loader.getResource(XmlConfiguration.class, (String)"org/eclipse/jetty/xml/configure_7_6.dtd");
        URL uRL3 = Loader.getResource(XmlConfiguration.class, (String)"org/eclipse/jetty/xml/configure_9_0.dtd");
        URL uRL4 = Loader.getResource(XmlConfiguration.class, (String)"org/eclipse/jetty/xml/configure_9_3.dtd");
        xmlParser.redirectEntity("configure.dtd", uRL3);
        xmlParser.redirectEntity("configure_1_0.dtd", uRL);
        xmlParser.redirectEntity("configure_1_1.dtd", uRL);
        xmlParser.redirectEntity("configure_1_2.dtd", uRL);
        xmlParser.redirectEntity("configure_1_3.dtd", uRL);
        xmlParser.redirectEntity("configure_6_0.dtd", uRL);
        xmlParser.redirectEntity("configure_7_6.dtd", uRL2);
        xmlParser.redirectEntity("configure_9_0.dtd", uRL3);
        xmlParser.redirectEntity("configure_9_3.dtd", uRL4);
        xmlParser.redirectEntity("http://jetty.mortbay.org/configure.dtd", uRL4);
        xmlParser.redirectEntity("http://jetty.eclipse.org/configure.dtd", uRL4);
        xmlParser.redirectEntity("http://www.eclipse.org/jetty/configure.dtd", uRL4);
        xmlParser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", uRL4);
        xmlParser.redirectEntity("-//Jetty//Configure//EN", uRL4);
        return xmlParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL uRL) {
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = uRL;
            this.setConfig(__parser.parse(uRL.toString()));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String string) {
        string = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"http://eclipse.org/jetty/configure.dtd\">" + string;
        InputSource inputSource = new InputSource(new StringReader(string));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = null;
            this.setConfig(__parser.parse(inputSource));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream inputStream) {
        InputSource inputSource = new InputSource(inputStream);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = null;
            this.setConfig(__parser.parse(inputSource));
            this._dtd = __parser.getDTD();
        }
    }

    private void setConfig(XmlParser.Node node) {
        if ("Configure".equals(node.getTag())) {
            this._processor = new JettyXmlConfiguration();
        } else if (__factoryLoader != null) {
            for (ConfigurationProcessorFactory configurationProcessorFactory : __factoryLoader) {
                this._processor = configurationProcessorFactory.getConfigurationProcessor(this._dtd, node.getTag());
                if (this._processor == null) continue;
                break;
            }
            if (this._processor == null) {
                throw new IllegalStateException("Unknown configuration type: " + node.getTag() + " in " + this);
            }
        } else {
            throw new IllegalArgumentException("Unknown XML tag:" + node.getTag());
        }
        this._processor.init(this._url, node, this);
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }

    public Map<String, String> getProperties() {
        return this._propertyMap;
    }

    public Object configure(Object object) {
        return this._processor.configure(object);
    }

    public Object configure() {
        return this._processor.configure();
    }

    public void initializeDefaults(Object object) {
    }

    public static void main(final String ... stringArray) {
        final AtomicReference atomicReference = new AtomicReference();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Object run() {
                try {
                    int n;
                    Properties properties = null;
                    try {
                        Class<?> object2 = XmlConfiguration.class.getClassLoader().loadClass("org.eclipse.jetty.start.Config");
                        properties = (Properties)object2.getMethod("getProperties", new Class[0]).invoke(null, new Object[0]);
                        LOG.debug("org.eclipse.jetty.start.Config properties = {}", new Object[]{properties});
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                        LOG.ignore(throwable);
                    }
                    catch (Exception exception) {
                        LOG.warn((Throwable)exception);
                    }
                    if (properties == null) {
                        properties = new Properties();
                        properties.putAll((Map<?, ?>)System.getProperties());
                    }
                    String[] stringArray2 = stringArray;
                    int n2 = stringArray2.length;
                    for (n = 0; n < n2; ++n) {
                        String string = stringArray2[n];
                        if (string.indexOf(61) >= 0) {
                            int n3 = string.indexOf(61);
                            properties.put(string.substring(0, n3), string.substring(n3 + 1));
                            continue;
                        }
                        if (!string.toLowerCase(Locale.ENGLISH).endsWith(".properties")) continue;
                        properties.load(Resource.newResource((String)string).getInputStream());
                    }
                    Object var2_8 = null;
                    Object[] objectArray = new Object[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        void var2_9;
                        if (stringArray[n].toLowerCase(Locale.ENGLISH).endsWith(".properties") || stringArray[n].indexOf(61) >= 0) continue;
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.newResource((String)stringArray[n]).getURI().toURL());
                        if (var2_9 != null) {
                            xmlConfiguration.getIdMap().putAll(var2_9.getIdMap());
                        }
                        if (properties.size() > 0) {
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            for (Object object : properties.keySet()) {
                                hashMap.put(object.toString(), String.valueOf(properties.get(object)));
                            }
                            xmlConfiguration.getProperties().putAll(hashMap);
                        }
                        objectArray[n] = xmlConfiguration.configure();
                        XmlConfiguration xmlConfiguration2 = xmlConfiguration;
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        LifeCycle lifeCycle;
                        if (!(objectArray[n] instanceof LifeCycle) || (lifeCycle = (LifeCycle)objectArray[n]).isRunning()) continue;
                        lifeCycle.start();
                    }
                }
                catch (Exception exception) {
                    LOG.debug("EXCEPTION ", (Throwable)exception);
                    atomicReference.set(exception);
                }
                return null;
            }
        });
        Throwable throwable = (Throwable)atomicReference.get();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error(throwable);
        }
    }

    private static class JettyXmlConfiguration
    implements ConfigurationProcessor {
        private String _url;
        XmlParser.Node _root;
        XmlConfiguration _configuration;

        private JettyXmlConfiguration() {
        }

        @Override
        public void init(URL uRL, XmlParser.Node node, XmlConfiguration xmlConfiguration) {
            this._url = uRL == null ? null : uRL.toString();
            this._root = node;
            this._configuration = xmlConfiguration;
        }

        @Override
        public Object configure(Object object) {
            Class<?> clazz = JettyXmlConfiguration.nodeClass(this._root);
            if (clazz != null && !clazz.isInstance(object)) {
                String string = clazz.getClassLoader() == object.getClass().getClassLoader() ? "" : "Object Class and type Class are from different loaders.";
                throw new IllegalArgumentException("Object of class '" + object.getClass().getCanonicalName() + "' is not of type '" + clazz.getCanonicalName() + "'. " + string + " in " + this._url);
            }
            String string = this._root.getAttribute("id");
            if (string != null) {
                this._configuration.getIdMap().put(string, object);
            }
            this.configure(object, this._root, 0);
            return object;
        }

        @Override
        public Object configure() {
            Class<?> clazz = JettyXmlConfiguration.nodeClass(this._root);
            String string = this._root.getAttribute("id");
            Object object = string == null ? null : this._configuration.getIdMap().get(string);
            int n = 0;
            if (object == null && clazz != null) {
                n = this._root.size();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                LinkedList<Object> linkedList = new LinkedList<Object>();
                for (int i = 0; i < this._root.size(); ++i) {
                    Object object2 = this._root.get(i);
                    if (object2 instanceof String) continue;
                    XmlParser.Node node = (XmlParser.Node)object2;
                    if (!node.getTag().equals("Arg")) {
                        n = i;
                        break;
                    }
                    String string2 = node.getAttribute("name");
                    Object object3 = this.value(object, (XmlParser.Node)object2);
                    if (string2 != null) {
                        hashMap.put(string2, object3);
                    }
                    linkedList.add(object3);
                }
                try {
                    object = hashMap.size() > 0 ? TypeUtil.construct(clazz, (Object[])linkedList.toArray(), hashMap) : TypeUtil.construct(clazz, (Object[])linkedList.toArray());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException(String.format("No constructor %s(%s,%s) in %s", clazz, linkedList, hashMap, this._url));
                }
            }
            if (string != null) {
                this._configuration.getIdMap().put(string, object);
            }
            this._configuration.initializeDefaults(object);
            this.configure(object, this._root, n);
            return object;
        }

        private static Class<?> nodeClass(XmlParser.Node node) {
            String string = node.getAttribute("class");
            if (string == null) {
                return null;
            }
            return Loader.loadClass(XmlConfiguration.class, (String)string);
        }

        public void configure(Object object, XmlParser.Node node, int n) {
            XmlParser.Node node2;
            Object object2;
            while (n < node.size()) {
                object2 = node.get(n);
                if (!(object2 instanceof String)) {
                    node2 = (XmlParser.Node)object2;
                    if (!"Arg".equals(node2.getTag())) break;
                    LOG.warn("Ignored arg: " + node2, new Object[0]);
                }
                ++n;
            }
            while (n < node.size()) {
                object2 = node.get(n);
                if (!(object2 instanceof String)) {
                    node2 = (XmlParser.Node)object2;
                    try {
                        String string;
                        switch (string = node2.getTag()) {
                            case "Set": {
                                this.set(object, node2);
                                break;
                            }
                            case "Put": {
                                this.put(object, node2);
                                break;
                            }
                            case "Call": {
                                this.call(object, node2);
                                break;
                            }
                            case "Get": {
                                this.get(object, node2);
                                break;
                            }
                            case "New": {
                                this.newObj(object, node2);
                                break;
                            }
                            case "Array": {
                                this.newArray(object, node2);
                                break;
                            }
                            case "Map": {
                                this.newMap(object, node2);
                                break;
                            }
                            case "Ref": {
                                this.refObj(object, node2);
                                break;
                            }
                            case "Property": {
                                this.propertyObj(node2);
                                break;
                            }
                            case "SystemProperty": {
                                this.systemPropertyObj(node2);
                                break;
                            }
                            case "Env": {
                                this.envObj(node2);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown tag: " + string + " in " + this._url);
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOG.warn("Config error at " + node2, new Object[]{exception.toString() + " in " + this._url});
                        throw exception;
                    }
                }
                ++n;
            }
        }

        private void set(Object object, XmlParser.Node node) {
            String string = node.getAttribute("name");
            String string2 = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
            Object object2 = this.value(object, node);
            Object[] objectArray = new Object[]{object2};
            Class<?> clazz = JettyXmlConfiguration.nodeClass(node);
            if (clazz != null) {
                object = null;
            } else {
                clazz = object.getClass();
            }
            Class[] classArray = new Class[]{Object.class};
            if (object2 != null) {
                classArray[0] = object2.getClass();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + (object != null ? object.toString() : clazz.getName()) + "." + string2 + "(" + object2 + ")", new Object[0]);
            }
            try {
                Method method = clazz.getMethod(string2, classArray);
                method.invoke(object, objectArray);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException exception) {
                LOG.ignore((Throwable)exception);
                try {
                    Field field = classArray[0].getField("TYPE");
                    classArray[0] = (Class)field.get(null);
                    Method method = clazz.getMethod(string2, classArray);
                    method.invoke(object, objectArray);
                    return;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException exception2) {
                    Method[] methodArray;
                    LOG.ignore((Throwable)exception2);
                    try {
                        methodArray = clazz.getField(string);
                        if (Modifier.isPublic(methodArray.getModifiers())) {
                            methodArray.set(object, object2);
                            return;
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        LOG.ignore((Throwable)noSuchFieldException);
                    }
                    methodArray = clazz.getMethods();
                    Method method = null;
                    for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
                        Class<?>[] classArray2 = methodArray[i].getParameterTypes();
                        if (!string2.equals(methodArray[i].getName()) || classArray2.length != 1) continue;
                        try {
                            method = methodArray[i];
                            methodArray[i].invoke(object, objectArray);
                            return;
                        }
                        catch (IllegalAccessException | IllegalArgumentException exception3) {
                            LOG.ignore((Throwable)exception3);
                            try {
                                for (Class clazz2 : __supportedCollections) {
                                    if (!classArray2[0].isAssignableFrom(clazz2)) continue;
                                    methodArray[i].invoke(object, JettyXmlConfiguration.convertArrayToCollection(object2, clazz2));
                                    return;
                                }
                                continue;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                LOG.ignore((Throwable)illegalAccessException);
                            }
                        }
                    }
                    if (method != null) {
                        try {
                            Class clazz3 = method.getParameterTypes()[0];
                            if (clazz3.isPrimitive()) {
                                for (int i = 0; i < __primitives.length; ++i) {
                                    if (!clazz3.equals(__primitives[i])) continue;
                                    clazz3 = __boxedPrimitives[i];
                                    break;
                                }
                            }
                            Constructor<?> constructor = clazz3.getConstructor(classArray);
                            objectArray[0] = constructor.newInstance(objectArray);
                            this._configuration.initializeDefaults(objectArray[0]);
                            method.invoke(object, objectArray);
                            return;
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException reflectiveOperationException) {
                            LOG.ignore((Throwable)reflectiveOperationException);
                        }
                    }
                    throw new NoSuchMethodException(clazz + "." + string2 + "(" + classArray[0] + ")");
                }
            }
        }

        private static Collection<?> convertArrayToCollection(Object object, Class<?> clazz) {
            ArrayQueue arrayQueue = null;
            if (object.getClass().isArray()) {
                if (clazz.isAssignableFrom(ArrayList.class)) {
                    arrayQueue = JettyXmlConfiguration.convertArrayToArrayList(object);
                } else if (clazz.isAssignableFrom(HashSet.class)) {
                    arrayQueue = new HashSet<Object>(JettyXmlConfiguration.convertArrayToArrayList(object));
                } else if (clazz.isAssignableFrom(ArrayQueue.class)) {
                    ArrayQueue arrayQueue2 = new ArrayQueue();
                    arrayQueue2.addAll(JettyXmlConfiguration.convertArrayToArrayList(object));
                    arrayQueue = arrayQueue2;
                }
            }
            if (arrayQueue == null) {
                throw new IllegalArgumentException("Can't convert \"" + object.getClass() + "\" to " + clazz);
            }
            return arrayQueue;
        }

        private static ArrayList<Object> convertArrayToArrayList(Object object) {
            int n = Array.getLength(object);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(Array.get(object, i));
            }
            return arrayList;
        }

        private void put(Object object, XmlParser.Node node) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("Object for put is not a Map: " + object);
            }
            Map map = (Map)object;
            String string = node.getAttribute("name");
            Object object2 = this.value(object, node);
            map.put(string, object2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + object + ".put(" + string + "," + object2 + ")", new Object[0]);
            }
        }

        private Object get(Object object, XmlParser.Node node) {
            Class<?> clazz = JettyXmlConfiguration.nodeClass(node);
            if (clazz != null) {
                object = null;
            } else {
                clazz = object.getClass();
            }
            String string = node.getAttribute("name");
            String string2 = node.getAttribute("id");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML get " + string, new Object[0]);
            }
            try {
                Method method = clazz.getMethod("get" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1), null);
                object = method.invoke(object, (Object[])null);
                if (string2 != null) {
                    this._configuration.getIdMap().put(string2, object);
                }
                this.configure(object, node, 0);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Field field = clazz.getField(string);
                    object = field.get(object);
                    this.configure(object, node, 0);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw noSuchMethodException;
                }
            }
            return object;
        }

        private Object call(Object object, XmlParser.Node node) {
            Class<?> clazz;
            AttrOrElementNode attrOrElementNode = new AttrOrElementNode(object, node, "Id", "Name", "Class", "Arg");
            String string = attrOrElementNode.getString("Id");
            String string2 = attrOrElementNode.getString("Name");
            String string3 = attrOrElementNode.getString("Class");
            List<Object> list = attrOrElementNode.getList("Arg");
            if (string3 != null) {
                clazz = Loader.loadClass(XmlConfiguration.class, (String)string3);
                object = null;
            } else if (object != null) {
                clazz = object.getClass();
            } else {
                throw new IllegalArgumentException(node.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML call " + string2, new Object[0]);
            }
            try {
                Object object2 = TypeUtil.call(clazz, (String)string2, (Object)object, (Object[])list.toArray(new Object[list.size()]));
                if (string != null) {
                    this._configuration.getIdMap().put(string, object2);
                }
                this.configure(object2, node, attrOrElementNode.getNext());
                return object2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                IllegalStateException illegalStateException = new IllegalStateException("No Method: " + node + " on " + clazz);
                illegalStateException.initCause(noSuchMethodException);
                throw illegalStateException;
            }
        }

        private Object newObj(Object object, XmlParser.Node node) {
            Object object2;
            AttrOrElementNode attrOrElementNode = new AttrOrElementNode(object, node, "Id", "Class", "Arg");
            String string = attrOrElementNode.getString("Id");
            String string2 = attrOrElementNode.getString("Class");
            List<XmlParser.Node> list = attrOrElementNode.getNodes("Arg");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML new " + string2, new Object[0]);
            }
            Class clazz = Loader.loadClass(XmlConfiguration.class, (String)string2);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (XmlParser.Node node2 : list) {
                String string3 = node2.getAttribute("name");
                Object object3 = this.value(object, node2);
                if (string3 != null) {
                    hashMap.put(string3, object3);
                }
                linkedList.add(object3);
            }
            try {
                if (hashMap.size() > 0) {
                    LOG.debug("using named mapping", new Object[0]);
                    object2 = TypeUtil.construct((Class)clazz, (Object[])linkedList.toArray(), hashMap);
                } else {
                    LOG.debug("using normal mapping", new Object[0]);
                    object2 = TypeUtil.construct((Class)clazz, (Object[])linkedList.toArray());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException("No suitable constructor: " + node + " on " + object);
            }
            if (string != null) {
                this._configuration.getIdMap().put(string, object2);
            }
            this._configuration.initializeDefaults(object2);
            this.configure(object2, node, attrOrElementNode.getNext());
            return object2;
        }

        private Object refObj(Object object, XmlParser.Node node) {
            String string = node.getAttribute("refid");
            if (string == null) {
                string = node.getAttribute("id");
            }
            if ((object = this._configuration.getIdMap().get(string)) == null && node.size() > 0) {
                throw new IllegalStateException("No object for refid=" + string);
            }
            this.configure(object, node, 0);
            return object;
        }

        private Object newArray(Object object, XmlParser.Node node) {
            AttrOrElementNode attrOrElementNode = new AttrOrElementNode(object, node, "Id", "Type", "Item");
            String string = attrOrElementNode.getString("Id");
            String string2 = attrOrElementNode.getString("Type");
            List<XmlParser.Node> list = attrOrElementNode.getNodes("Item");
            Class clazz = Object.class;
            if (string2 != null && (clazz = TypeUtil.fromName((String)string2)) == null) {
                switch (string2) {
                    case "String": {
                        clazz = String.class;
                        break;
                    }
                    case "URL": {
                        clazz = URL.class;
                        break;
                    }
                    case "InetAddress": {
                        clazz = InetAddress.class;
                        break;
                    }
                    default: {
                        clazz = Loader.loadClass(XmlConfiguration.class, (String)string2);
                    }
                }
            }
            Object object2 = null;
            for (XmlParser.Node node2 : list) {
                String string3 = node2.getAttribute("id");
                Object object3 = this.value(object, node2);
                object2 = LazyList.add((Object)object2, (Object)(object3 == null && clazz.isPrimitive() ? Integer.valueOf(0) : object3));
                if (string3 == null) continue;
                this._configuration.getIdMap().put(string3, object3);
            }
            Object object4 = LazyList.toArray((Object)object2, (Class)clazz);
            if (string != null) {
                this._configuration.getIdMap().put(string, object4);
            }
            return object4;
        }

        private Object newMap(Object object, XmlParser.Node node) {
            AttrOrElementNode attrOrElementNode = new AttrOrElementNode(node, "Id", "Entry");
            String string = attrOrElementNode.getString("Id");
            List<XmlParser.Node> list = attrOrElementNode.getNodes("Entry");
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            if (string != null) {
                this._configuration.getIdMap().put(string, hashMap);
            }
            for (XmlParser.Node node2 : list) {
                Object object2;
                Object object32;
                if (!node2.getTag().equals("Entry")) {
                    throw new IllegalStateException("Not an Entry");
                }
                XmlParser.Node node3 = null;
                XmlParser.Node node4 = null;
                for (Object object32 : node2) {
                    if (object32 instanceof String) continue;
                    object2 = (XmlParser.Node)object32;
                    if (!((XmlParser.Node)object2).getTag().equals("Item")) {
                        throw new IllegalStateException("Not an Item");
                    }
                    if (node3 == null) {
                        node3 = object2;
                        continue;
                    }
                    node4 = object2;
                }
                if (node3 == null || node4 == null) {
                    throw new IllegalStateException("Missing Item in Entry");
                }
                String string2 = node3.getAttribute("id");
                object32 = node4.getAttribute("id");
                object2 = this.value(object, node3);
                Object object4 = this.value(object, node4);
                hashMap.put(object2, object4);
                if (string2 != null) {
                    this._configuration.getIdMap().put(string2, object2);
                }
                if (object32 == null) continue;
                this._configuration.getIdMap().put((String)object32, object4);
            }
            return hashMap;
        }

        private Object propertyObj(XmlParser.Node node) {
            AttrOrElementNode attrOrElementNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String string = attrOrElementNode.getString("Id");
            String string2 = attrOrElementNode.getString("Name", true);
            List<Object> list = attrOrElementNode.getList("Deprecated");
            String string3 = attrOrElementNode.getString("Default");
            Map<String, String> map = this._configuration.getProperties();
            String string4 = map.get(string2);
            String string5 = null;
            if (!list.isEmpty()) {
                for (Object object : list) {
                    String string6 = map.get(StringUtil.valueOf((Object)object));
                    if (string6 != null) {
                        if (string4 == null) {
                            LOG.warn("Property '{}' is deprecated, use '{}' instead", new Object[]{object, string2});
                        } else {
                            LOG.warn("Property '{}' is deprecated, value from '{}' used", new Object[]{object, string2});
                        }
                    }
                    if (string5 != null) continue;
                    string5 = string6;
                }
            }
            if (string4 == null) {
                string4 = string5;
            }
            if (string4 == null) {
                string4 = string3;
            }
            if (string != null) {
                this._configuration.getIdMap().put(string, string4);
            }
            return string4;
        }

        private Object systemPropertyObj(XmlParser.Node node) {
            AttrOrElementNode attrOrElementNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String string = attrOrElementNode.getString("Id");
            String string2 = attrOrElementNode.getString("Name", true);
            List<Object> list = attrOrElementNode.getList("Deprecated");
            String string3 = attrOrElementNode.getString("Default");
            String string4 = System.getProperty(string2);
            String string5 = null;
            if (!list.isEmpty()) {
                for (Object object : list) {
                    String string6 = System.getProperty(StringUtil.valueOf((Object)object));
                    if (string6 != null) {
                        if (string4 == null) {
                            LOG.warn("SystemProperty '{}' is deprecated, use '{}' instead", new Object[]{object, string2});
                        } else {
                            LOG.warn("SystemProperty '{}' is deprecated, value from '{}' used", new Object[]{object, string2});
                        }
                    }
                    if (string5 != null) continue;
                    string5 = string6;
                }
            }
            if (string4 == null) {
                string4 = string5;
            }
            if (string4 == null) {
                string4 = string3;
            }
            if (string != null) {
                this._configuration.getIdMap().put(string, string4);
            }
            return string4;
        }

        private Object envObj(XmlParser.Node node) {
            AttrOrElementNode attrOrElementNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String string = attrOrElementNode.getString("Id");
            String string2 = attrOrElementNode.getString("Name", true);
            List<Object> list = attrOrElementNode.getList("Deprecated");
            String string3 = attrOrElementNode.getString("Default");
            String string4 = System.getenv(string2);
            if (string4 == null && !list.isEmpty()) {
                for (Object object : list) {
                    string4 = System.getenv(StringUtil.valueOf((Object)object));
                    if (string4 == null) continue;
                    LOG.warn("Property '{}' is deprecated, use '{}' instead", new Object[]{object, string2});
                    break;
                }
            }
            if (string4 == null) {
                string4 = string3;
            }
            if (string != null) {
                this._configuration.getIdMap().put(string, string4);
            }
            return string4;
        }

        private Object value(Object object, XmlParser.Node node) {
            Object object2;
            String string = node.getAttribute("type");
            String string2 = node.getAttribute("ref");
            if (string2 != null) {
                object2 = this._configuration.getIdMap().get(string2);
            } else {
                Object object3;
                int n;
                if (node.size() == 0) {
                    if ("String".equals(string)) {
                        return "";
                    }
                    return null;
                }
                int n2 = node.size() - 1;
                if (string == null || !"String".equals(string)) {
                    for (n = 0; n <= n2 && (object3 = node.get(n)) instanceof String && ((String)(object3 = ((String)object3).trim())).length() <= 0; ++n) {
                    }
                    while (n < n2 && (object3 = node.get(n2)) instanceof String && ((String)(object3 = ((String)object3).trim())).length() <= 0) {
                        --n2;
                    }
                    if (n > n2) {
                        return null;
                    }
                }
                if (n == n2) {
                    object2 = this.itemValue(object, node.get(n));
                } else {
                    object3 = new StringBuilder();
                    for (int i = n; i <= n2; ++i) {
                        Object object4 = node.get(i);
                        ((StringBuilder)object3).append(this.itemValue(object, object4));
                    }
                    object2 = ((StringBuilder)object3).toString();
                }
            }
            if (object2 == null) {
                if ("String".equals(string)) {
                    return "";
                }
                return null;
            }
            if (string == null) {
                if (object2 instanceof String) {
                    return ((String)object2).trim();
                }
                return object2;
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(string, String.class)) {
                return object2.toString();
            }
            Class clazz = TypeUtil.fromName((String)string);
            if (clazz != null) {
                return TypeUtil.valueOf((Class)clazz, (String)object2.toString());
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(string, URL.class)) {
                if (object2 instanceof URL) {
                    return object2;
                }
                try {
                    return new URL(object2.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new InvocationTargetException(malformedURLException);
                }
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(string, InetAddress.class)) {
                if (object2 instanceof InetAddress) {
                    return object2;
                }
                try {
                    return InetAddress.getByName(object2.toString());
                }
                catch (UnknownHostException unknownHostException) {
                    throw new InvocationTargetException(unknownHostException);
                }
            }
            for (Class clazz2 : __supportedCollections) {
                if (!JettyXmlConfiguration.isTypeMatchingClass(string, clazz2)) continue;
                return JettyXmlConfiguration.convertArrayToCollection(object2, clazz2);
            }
            throw new IllegalStateException("Unknown type " + string);
        }

        private static boolean isTypeMatchingClass(String string, Class<?> clazz) {
            return clazz.getSimpleName().equalsIgnoreCase(string) || clazz.getName().equals(string);
        }

        private Object itemValue(Object object, Object object2) {
            if (object2 instanceof String) {
                return object2;
            }
            XmlParser.Node node = (XmlParser.Node)object2;
            String string = node.getTag();
            if ("Call".equals(string)) {
                return this.call(object, node);
            }
            if ("Get".equals(string)) {
                return this.get(object, node);
            }
            if ("New".equals(string)) {
                return this.newObj(object, node);
            }
            if ("Ref".equals(string)) {
                return this.refObj(object, node);
            }
            if ("Array".equals(string)) {
                return this.newArray(object, node);
            }
            if ("Map".equals(string)) {
                return this.newMap(object, node);
            }
            if ("Property".equals(string)) {
                return this.propertyObj(node);
            }
            if ("SystemProperty".equals(string)) {
                return this.systemPropertyObj(node);
            }
            if ("Env".equals(string)) {
                return this.envObj(node);
            }
            LOG.warn("Unknown value tag: " + node, new Throwable());
            return null;
        }

        private class AttrOrElementNode {
            final Object _obj;
            final XmlParser.Node _node;
            final Set<String> _elements = new HashSet<String>();
            final int _next;

            AttrOrElementNode(XmlParser.Node node, String ... stringArray) {
                this(null, node, stringArray);
            }

            AttrOrElementNode(Object object, XmlParser.Node node, String ... stringArray) {
                this._obj = object;
                this._node = node;
                for (String object2 : stringArray) {
                    this._elements.add(object2);
                }
                int n = 0;
                for (Object e : this._node) {
                    XmlParser.Node node2;
                    if (e instanceof String) {
                        if (((String)e).trim().length() != 0) break;
                        ++n;
                        continue;
                    }
                    if (!(e instanceof XmlParser.Node) || !this._elements.contains((node2 = (XmlParser.Node)e).getTag())) break;
                    ++n;
                }
                this._next = n;
            }

            public int getNext() {
                return this._next;
            }

            public String getString(String string) {
                return StringUtil.valueOf((Object)this.get(string, false));
            }

            public String getString(String string, boolean bl) {
                return StringUtil.valueOf((Object)this.get(string, bl));
            }

            public Object get(String string, boolean bl) {
                String string2 = StringUtil.asciiToLowerCase((String)string);
                String string3 = this._node.getAttribute(string2);
                Object object = string3;
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node node;
                    Object object2 = this._node.get(i);
                    if (!(object2 instanceof XmlParser.Node) || !string.equals((node = (XmlParser.Node)object2).getTag())) continue;
                    if (string3 != null) {
                        throw new IllegalStateException("Cannot have attr '" + string2 + "' and element '" + string + "'");
                    }
                    object = JettyXmlConfiguration.this.value(this._obj, node);
                    break;
                }
                if (bl && object == null) {
                    throw new IllegalStateException("Must have attr '" + string2 + "' or element '" + string + "'");
                }
                return object;
            }

            public List<Object> getList(String string) {
                return this.getList(string, false);
            }

            public List<Object> getList(String string, boolean bl) {
                String string2 = StringUtil.asciiToLowerCase((String)string);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string3 = this._node.getAttribute(string2);
                if (string3 != null) {
                    arrayList.addAll(StringUtil.csvSplit(null, (String)string3, (int)0, (int)string3.length()));
                }
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node node;
                    Object object = this._node.get(i);
                    if (!(object instanceof XmlParser.Node) || !string.equals((node = (XmlParser.Node)object).getTag())) continue;
                    if (string3 != null) {
                        throw new IllegalStateException("Cannot have attr '" + string2 + "' and element '" + string + "'");
                    }
                    arrayList.add(JettyXmlConfiguration.this.value(this._obj, node));
                }
                if (bl && arrayList.isEmpty()) {
                    throw new IllegalStateException("Must have attr '" + string2 + "' or element '" + string + "'");
                }
                return arrayList;
            }

            public List<XmlParser.Node> getNodes(String string) {
                XmlParser.Node node;
                String string2 = StringUtil.asciiToLowerCase((String)string);
                ArrayList<XmlParser.Node> arrayList = new ArrayList<XmlParser.Node>();
                String string3 = this._node.getAttribute(string2);
                if (string3 != null) {
                    for (Object object : StringUtil.csvSplit(null, (String)string3, (int)0, (int)string3.length())) {
                        node = new XmlParser.Node(null, string, null);
                        node.add(object);
                        arrayList.add(node);
                    }
                }
                for (int i = 0; i < this._next; ++i) {
                    Object object;
                    object = this._node.get(i);
                    if (!(object instanceof XmlParser.Node) || !string.equals((node = (XmlParser.Node)object).getTag())) continue;
                    if (string3 != null) {
                        throw new IllegalStateException("Cannot have attr '" + string2 + "' and element '" + string + "'");
                    }
                    arrayList.add(node);
                }
                return arrayList;
            }
        }
    }
}

