/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jetty.util.StringUtil;

public class XmlAppendable {
    private final String SPACES = "                                                                 ";
    private final Appendable _out;
    private final int _indent;
    private final Stack<String> _tags = new Stack();
    private String _space = "";

    public XmlAppendable(OutputStream outputStream, String string) {
        this((Appendable)new OutputStreamWriter(outputStream, string), string);
    }

    public XmlAppendable(Appendable appendable) {
        this(appendable, 2);
    }

    public XmlAppendable(Appendable appendable, String string) {
        this(appendable, 2, string);
    }

    public XmlAppendable(Appendable appendable, int n) {
        this(appendable, n, "utf-8");
    }

    public XmlAppendable(Appendable appendable, int n, String string) {
        this._out = appendable;
        this._indent = n;
        this._out.append("<?xml version=\"1.0\" encoding=\"" + string + "\"?>\n");
    }

    public XmlAppendable openTag(String string, Map<String, String> map) {
        this._out.append(this._space).append('<').append(string);
        this.attributes(map);
        this._out.append(">\n");
        this._space = this._space + "                                                                 ".substring(0, this._indent);
        this._tags.push(string);
        return this;
    }

    public XmlAppendable openTag(String string) {
        this._out.append(this._space).append('<').append(string).append(">\n");
        this._space = this._space + "                                                                 ".substring(0, this._indent);
        this._tags.push(string);
        return this;
    }

    public XmlAppendable content(String string) {
        if (string != null) {
            this._out.append(StringUtil.sanitizeXmlString((String)string));
        }
        return this;
    }

    public XmlAppendable cdata(String string) {
        this._out.append("<![CDATA[").append(string).append("]]>");
        return this;
    }

    public XmlAppendable tag(String string) {
        this._out.append(this._space).append('<').append(string).append("/>\n");
        return this;
    }

    public XmlAppendable tag(String string, Map<String, String> map) {
        this._out.append(this._space).append('<').append(string);
        this.attributes(map);
        this._out.append("/>\n");
        return this;
    }

    public XmlAppendable tag(String string, String string2) {
        this._out.append(this._space).append('<').append(string).append('>');
        this.content(string2);
        this._out.append("</").append(string).append(">\n");
        return this;
    }

    public XmlAppendable tagCDATA(String string, String string2) {
        this._out.append(this._space).append('<').append(string).append('>');
        this.cdata(string2);
        this._out.append("</").append(string).append(">\n");
        return this;
    }

    public XmlAppendable tag(String string, Map<String, String> map, String string2) {
        this._out.append(this._space).append('<').append(string);
        this.attributes(map);
        this._out.append('>');
        this.content(string2);
        this._out.append("</").append(string).append(">\n");
        return this;
    }

    public XmlAppendable closeTag() {
        if (this._tags.isEmpty()) {
            throw new IllegalStateException("Tags closed");
        }
        String string = this._tags.pop();
        this._space = this._space.substring(0, this._space.length() - this._indent);
        this._out.append(this._space).append("</").append(string).append(">\n");
        if (this._tags.isEmpty() && this._out instanceof Closeable) {
            ((Closeable)((Object)this._out)).close();
        }
        return this;
    }

    private void attributes(Map<String, String> map) {
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            this._out.append(' ').append(string).append("=\"");
            this.content(string2);
            this._out.append('\"');
        }
    }

    public void literal(String string) {
        this._out.append(string);
    }
}

