/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class TimerScheduler
extends AbstractLifeCycle
implements Runnable,
Scheduler {
    private static final Logger LOG = Log.getLogger(TimerScheduler.class);
    private final String _name;
    private final boolean _daemon;
    private Timer _timer;

    public TimerScheduler() {
        this(null, false);
    }

    public TimerScheduler(String string, boolean bl) {
        this._name = string;
        this._daemon = bl;
    }

    @Override
    protected void doStart() {
        this._timer = this._name == null ? new Timer() : new Timer(this._name, this._daemon);
        this.run();
        super.doStart();
    }

    @Override
    protected void doStop() {
        this._timer.cancel();
        super.doStop();
        this._timer = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        Timer timer = this._timer;
        if (timer == null) {
            throw new RejectedExecutionException("STOPPED: " + this);
        }
        SimpleTask simpleTask = new SimpleTask(runnable);
        timer.schedule((TimerTask)simpleTask, timeUnit.toMillis(l));
        return simpleTask;
    }

    @Override
    public void run() {
        Timer timer = this._timer;
        if (timer != null) {
            timer.purge();
            this.schedule(this, 1L, TimeUnit.SECONDS);
        }
    }

    private static class SimpleTask
    extends TimerTask
    implements Scheduler.Task {
        private final Runnable _task;

        private SimpleTask(Runnable runnable) {
            this._task = runnable;
        }

        @Override
        public void run() {
            try {
                this._task.run();
            }
            catch (Throwable throwable) {
                LOG.warn("Exception while executing task " + this._task, throwable);
            }
        }

        public String toString() {
            return String.format("%s.%s@%x", TimerScheduler.class.getSimpleName(), SimpleTask.class.getSimpleName(), this.hashCode());
        }
    }
}

