/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.Scheduler;

public class ScheduledExecutorScheduler
extends AbstractLifeCycle
implements Dumpable,
Scheduler {
    private final String name;
    private final boolean daemon;
    private final ClassLoader classloader;
    private final ThreadGroup threadGroup;
    private volatile ScheduledThreadPoolExecutor scheduler;
    private volatile Thread thread;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    public ScheduledExecutorScheduler(String string, boolean bl) {
        this(string, bl, Thread.currentThread().getContextClassLoader());
    }

    public ScheduledExecutorScheduler(String string, boolean bl, ClassLoader classLoader) {
        this(string, bl, classLoader, null);
    }

    public ScheduledExecutorScheduler(String string, boolean bl, ClassLoader classLoader, ThreadGroup threadGroup) {
        this.name = string == null ? "Scheduler-" + this.hashCode() : string;
        this.daemon = bl;
        this.classloader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.threadGroup = threadGroup;
    }

    @Override
    protected void doStart() {
        this.scheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = ScheduledExecutorScheduler.this.thread = new Thread(ScheduledExecutorScheduler.this.threadGroup, runnable, ScheduledExecutorScheduler.this.name);
                thread.setDaemon(ScheduledExecutorScheduler.this.daemon);
                thread.setContextClassLoader(ScheduledExecutorScheduler.this.classloader);
                return thread;
            }
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        super.doStart();
    }

    @Override
    protected void doStop() {
        this.scheduler.shutdownNow();
        super.doStop();
        this.scheduler = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this.scheduler;
        if (scheduledThreadPoolExecutor == null) {
            return new Scheduler.Task(){

                @Override
                public boolean cancel() {
                    return false;
                }
            };
        }
        ScheduledFuture<?> scheduledFuture = scheduledThreadPoolExecutor.schedule(runnable, l, timeUnit);
        return new ScheduledFutureTask(scheduledFuture);
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable appendable, String string) {
        ContainerLifeCycle.dumpObject(appendable, this);
        Thread thread = this.thread;
        if (thread != null) {
            List<StackTraceElement> list = Arrays.asList(thread.getStackTrace());
            ContainerLifeCycle.dump(appendable, string, list);
        }
    }

    private static class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

