/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="A thread pool with no max bound by default")
public class QueuedThreadPool
extends AbstractLifeCycle
implements Dumpable,
ThreadPool.SizedThreadPool {
    private static final Logger LOG = Log.getLogger(QueuedThreadPool.class);
    private final AtomicInteger _threadsStarted = new AtomicInteger();
    private final AtomicInteger _threadsIdle = new AtomicInteger();
    private final AtomicLong _lastShrink = new AtomicLong();
    private final ConcurrentHashSet<Thread> _threads = new ConcurrentHashSet();
    private final Object _joinLock = new Object();
    private final BlockingQueue<Runnable> _jobs;
    private final ThreadGroup _threadGroup;
    private String _name = "qtp" + this.hashCode();
    private int _idleTimeout;
    private int _maxThreads;
    private int _minThreads;
    private int _priority = 5;
    private boolean _daemon = false;
    private boolean _detailedDump = false;
    private Runnable _runnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            boolean bl = false;
            boolean bl2 = false;
            try {
                Runnable runnable = (Runnable)QueuedThreadPool.this._jobs.poll();
                if (runnable != null && QueuedThreadPool.this._threadsIdle.get() == 0) {
                    QueuedThreadPool.this.startThreads(1);
                }
                block10: while (QueuedThreadPool.this.isRunning()) {
                    while (runnable != null && QueuedThreadPool.this.isRunning()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("run {}", runnable);
                        }
                        QueuedThreadPool.this.runJob(runnable);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("ran {}", runnable);
                        }
                        if (Thread.interrupted()) {
                            bl2 = true;
                            break block10;
                        }
                        runnable = (Runnable)QueuedThreadPool.this._jobs.poll();
                    }
                    try {
                        QueuedThreadPool.this._threadsIdle.incrementAndGet();
                        while (QueuedThreadPool.this.isRunning() && runnable == null) {
                            if (QueuedThreadPool.this._idleTimeout <= 0) {
                                runnable = (Runnable)QueuedThreadPool.this._jobs.take();
                                continue;
                            }
                            int n = QueuedThreadPool.this._threadsStarted.get();
                            if (n > QueuedThreadPool.this._minThreads) {
                                long l = QueuedThreadPool.this._lastShrink.get();
                                long l2 = System.nanoTime();
                                if ((l == 0L || l2 - l > TimeUnit.MILLISECONDS.toNanos(QueuedThreadPool.this._idleTimeout)) && QueuedThreadPool.this._lastShrink.compareAndSet(l, l2) && QueuedThreadPool.this._threadsStarted.compareAndSet(n, n - 1)) {
                                    bl = true;
                                    break block10;
                                }
                            }
                            runnable = QueuedThreadPool.this.idleJobPoll();
                        }
                    }
                    finally {
                        if (QueuedThreadPool.this._threadsIdle.decrementAndGet() != 0) continue;
                        QueuedThreadPool.this.startThreads(1);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
                LOG.ignore(interruptedException);
                if (!bl && QueuedThreadPool.this.isRunning()) {
                    if (!bl2) {
                        LOG.warn("Unexpected thread death: {} in {}", this, QueuedThreadPool.this);
                    }
                    if (QueuedThreadPool.this._threadsStarted.decrementAndGet() < QueuedThreadPool.this.getMaxThreads()) {
                        QueuedThreadPool.this.startThreads(1);
                    }
                }
                QueuedThreadPool.this._threads.remove(Thread.currentThread());
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
                {
                    catch (Throwable throwable2) {
                        if (!bl && QueuedThreadPool.this.isRunning()) {
                            if (!bl2) {
                                LOG.warn("Unexpected thread death: {} in {}", this, QueuedThreadPool.this);
                            }
                            if (QueuedThreadPool.this._threadsStarted.decrementAndGet() < QueuedThreadPool.this.getMaxThreads()) {
                                QueuedThreadPool.this.startThreads(1);
                            }
                        }
                        QueuedThreadPool.this._threads.remove(Thread.currentThread());
                        throw throwable2;
                    }
                }
                if (!bl && QueuedThreadPool.this.isRunning()) {
                    if (!bl2) {
                        LOG.warn("Unexpected thread death: {} in {}", this, QueuedThreadPool.this);
                    }
                    if (QueuedThreadPool.this._threadsStarted.decrementAndGet() < QueuedThreadPool.this.getMaxThreads()) {
                        QueuedThreadPool.this.startThreads(1);
                    }
                }
                QueuedThreadPool.this._threads.remove(Thread.currentThread());
            }
            if (!bl && QueuedThreadPool.this.isRunning()) {
                if (!bl2) {
                    LOG.warn("Unexpected thread death: {} in {}", this, QueuedThreadPool.this);
                }
                if (QueuedThreadPool.this._threadsStarted.decrementAndGet() < QueuedThreadPool.this.getMaxThreads()) {
                    QueuedThreadPool.this.startThreads(1);
                }
            }
            QueuedThreadPool.this._threads.remove(Thread.currentThread());
        }
    };

    public QueuedThreadPool() {
        this(200);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n) {
        this(n, 8);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2) {
        this(n, n2, 60000);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3) {
        this(n, n2, n3, null);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3, @Name(value="queue") BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, n3, blockingQueue, null);
    }

    public QueuedThreadPool(@Name(value="maxThreads") int n, @Name(value="minThreads") int n2, @Name(value="idleTimeout") int n3, @Name(value="queue") BlockingQueue<Runnable> blockingQueue, @Name(value="threadGroup") ThreadGroup threadGroup) {
        this.setMinThreads(n2);
        this.setMaxThreads(n);
        this.setIdleTimeout(n3);
        this.setStopTimeout(5000L);
        if (blockingQueue == null) {
            int n4 = Math.max(this._minThreads, 8);
            blockingQueue = new BlockingArrayQueue<Runnable>(n4, n4);
        }
        this._jobs = blockingQueue;
        this._threadGroup = threadGroup;
    }

    @Override
    protected void doStart() {
        super.doStart();
        this._threadsStarted.set(0);
        this.startThreads(this._minThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        long l;
        super.doStop();
        long l2 = this.getStopTimeout();
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        if (l2 <= 0L) {
            blockingQueue.clear();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        int n = this._threadsStarted.get();
        while (n-- > 0) {
            blockingQueue.offer(runnable);
        }
        long l3 = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l2) / 2L;
        for (Thread iterator2 : this._threads) {
            l = TimeUnit.NANOSECONDS.toMillis(l3 - System.nanoTime());
            if (l <= 0L) continue;
            iterator2.join(l);
        }
        if (this._threadsStarted.get() > 0) {
            for (Thread thread : this._threads) {
                thread.interrupt();
            }
        }
        l3 = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(l2) / 2L;
        for (Thread thread : this._threads) {
            l = TimeUnit.NANOSECONDS.toMillis(l3 - System.nanoTime());
            if (l <= 0L) continue;
            thread.join(l);
        }
        Thread.yield();
        int n2 = this._threads.size();
        if (n2 > 0) {
            Thread.yield();
            if (LOG.isDebugEnabled()) {
                for (Thread thread : this._threads) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                        stringBuilder.append(System.lineSeparator()).append("\tat ").append(stackTraceElement);
                    }
                    LOG.warn("Couldn't stop {}{}", thread, stringBuilder.toString());
                }
            } else {
                for (Thread thread : this._threads) {
                    LOG.warn("{} Couldn't stop {}", this, thread);
                }
            }
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    public void setDaemon(boolean bl) {
        this._daemon = bl;
    }

    public void setIdleTimeout(int n) {
        this._idleTimeout = n;
    }

    @Override
    public void setMaxThreads(int n) {
        this._maxThreads = n;
        if (this._minThreads > this._maxThreads) {
            this._minThreads = this._maxThreads;
        }
    }

    @Override
    public void setMinThreads(int n) {
        this._minThreads = n;
        if (this._minThreads > this._maxThreads) {
            this._maxThreads = this._minThreads;
        }
        int n2 = this._threadsStarted.get();
        if (this.isStarted() && n2 < this._minThreads) {
            this.startThreads(this._minThreads - n2);
        }
    }

    public void setName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException("started");
        }
        this._name = string;
    }

    public void setThreadsPriority(int n) {
        this._priority = n;
    }

    @ManagedAttribute(value="maximum time a thread may be idle in ms")
    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    @Override
    @ManagedAttribute(value="maximum number of threads in the pool")
    public int getMaxThreads() {
        return this._maxThreads;
    }

    @Override
    @ManagedAttribute(value="minimum number of threads in the pool")
    public int getMinThreads() {
        return this._minThreads;
    }

    @ManagedAttribute(value="name of the thread pool")
    public String getName() {
        return this._name;
    }

    @ManagedAttribute(value="priority of threads in the pool")
    public int getThreadsPriority() {
        return this._priority;
    }

    @ManagedAttribute(value="Size of the job queue")
    public int getQueueSize() {
        return this._jobs.size();
    }

    @ManagedAttribute(value="thead pool using a daemon thread")
    public boolean isDaemon() {
        return this._daemon;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean bl) {
        this._detailedDump = bl;
    }

    @Override
    public void execute(Runnable runnable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("queue {}", runnable);
        }
        if (!this.isRunning() || !this._jobs.offer(runnable)) {
            LOG.warn("{} rejected {}", this, runnable);
            throw new RejectedExecutionException(runnable.toString());
        }
        if (this.getThreads() == 0) {
            this.startThreads(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(1L);
        }
    }

    @Override
    @ManagedAttribute(value="total number of threads currently in the pool")
    public int getThreads() {
        return this._threadsStarted.get();
    }

    @Override
    @ManagedAttribute(value="total number of idle threads in the pool")
    public int getIdleThreads() {
        return this._threadsIdle.get();
    }

    @ManagedAttribute(value="total number of busy threads in the pool")
    public int getBusyThreads() {
        return this.getThreads() - this.getIdleThreads();
    }

    @Override
    @ManagedAttribute(value="True if the pools is at maxThreads and there are not idle threads than queued jobs")
    public boolean isLowOnThreads() {
        return this._threadsStarted.get() == this._maxThreads && this._jobs.size() >= this._threadsIdle.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startThreads(int n) {
        while (n > 0 && this.isRunning()) {
            int n2 = this._threadsStarted.get();
            if (n2 >= this._maxThreads) {
                return false;
            }
            if (!this._threadsStarted.compareAndSet(n2, n2 + 1)) continue;
            boolean bl = false;
            try {
                Thread thread = this.newThread(this._runnable);
                thread.setDaemon(this.isDaemon());
                thread.setPriority(this.getThreadsPriority());
                thread.setName(this._name + "-" + thread.getId());
                this._threads.add(thread);
                thread.start();
                bl = true;
                --n;
            }
            finally {
                if (bl) continue;
                this._threadsStarted.decrementAndGet();
            }
        }
        return true;
    }

    protected Thread newThread(Runnable runnable) {
        return new Thread(this._threadGroup, runnable);
    }

    @Override
    @ManagedOperation(value="dump thread state")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable appendable, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.getMaxThreads());
        for (final Thread thread : this._threads) {
            final StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!"idleJobPoll".equals(stackTraceElement.getMethodName())) continue;
                bl = true;
                break;
            }
            final boolean bl2 = bl;
            if (this.isDetailedDump()) {
                arrayList.add(new Dumpable(){

                    @Override
                    public void dump(Appendable appendable, String string) {
                        appendable.append(String.valueOf(thread.getId())).append(' ').append(thread.getName()).append(' ').append(thread.getState().toString()).append(bl2 ? " IDLE" : "");
                        if (thread.getPriority() != 5) {
                            appendable.append(" prio=").append(String.valueOf(thread.getPriority()));
                        }
                        appendable.append(System.lineSeparator());
                        if (!bl2) {
                            ContainerLifeCycle.dump(appendable, string, Arrays.asList(stackTraceElementArray));
                        }
                    }

                    @Override
                    public String dump() {
                        return null;
                    }
                });
                continue;
            }
            int n = thread.getPriority();
            arrayList.add(thread.getId() + " " + thread.getName() + " " + (Object)((Object)thread.getState()) + " @ " + (stackTraceElementArray.length > 0 ? stackTraceElementArray[0] : "???") + (bl2 ? " IDLE" : "") + (n == 5 ? "" : " prio=" + n));
        }
        ContainerLifeCycle.dumpObject(appendable, this);
        ContainerLifeCycle.dump(appendable, string, arrayList);
    }

    public String toString() {
        return String.format("%s{%s,%d<=%d<=%d,i=%d,q=%d}", this._name, this.getState(), this.getMinThreads(), this.getThreads(), this.getMaxThreads(), this.getIdleThreads(), this._jobs == null ? -1 : this._jobs.size());
    }

    private Runnable idleJobPoll() {
        return this._jobs.poll(this._idleTimeout, TimeUnit.MILLISECONDS);
    }

    protected void runJob(Runnable runnable) {
        runnable.run();
    }

    protected BlockingQueue<Runnable> getQueue() {
        return this._jobs;
    }

    public void setQueue(BlockingQueue<Runnable> blockingQueue) {
        throw new UnsupportedOperationException("Use constructor injection");
    }

    @ManagedOperation(value="interrupt a pool thread")
    public boolean interruptThread(@Name(value="id") long l) {
        for (Thread thread : this._threads) {
            if (thread.getId() != l) continue;
            thread.interrupt();
            return true;
        }
        return false;
    }

    @ManagedOperation(value="dump a pool thread stack")
    public String dumpThread(@Name(value="id") long l) {
        for (Thread thread : this._threads) {
            if (thread.getId() != l) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(thread.getId()).append(" ").append(thread.getName()).append(" ");
            stringBuilder.append((Object)thread.getState()).append(":").append(System.lineSeparator());
            for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                stringBuilder.append("  at ").append(stackTraceElement.toString()).append(System.lineSeparator());
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

