/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class Locker {
    private static final boolean SPIN = Boolean.getBoolean(Locker.class.getName() + ".spin");
    private final boolean _spin;
    private final ReentrantLock _lock = new ReentrantLock();
    private final AtomicReference<Thread> _spinLockState = new AtomicReference<Object>(null);
    private final Lock _unlock = new Lock();

    public Locker() {
        this(SPIN);
    }

    public Locker(boolean bl) {
        this._spin = bl;
    }

    public Lock lock() {
        if (this._spin) {
            this.spinLock();
        } else {
            this.concLock();
        }
        return this._unlock;
    }

    private void spinLock() {
        Thread thread;
        Thread thread2 = Thread.currentThread();
        while ((thread = this._spinLockState.get()) != null || !this._spinLockState.compareAndSet(null, thread2)) {
            if (thread != thread2) continue;
            throw new IllegalStateException("Locker is not reentrant");
        }
    }

    private void concLock() {
        if (this._lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Locker is not reentrant");
        }
        this._lock.lock();
    }

    public boolean isLocked() {
        if (this._spin) {
            return this._spinLockState.get() != null;
        }
        return this._lock.isLocked();
    }

    public class Lock
    implements AutoCloseable {
        @Override
        public void close() {
            if (Locker.this._spin) {
                Locker.this._spinLockState.set(null);
            } else {
                Locker.this._lock.unlock();
            }
        }
    }
}

