/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ExecutorThreadPool
extends AbstractLifeCycle
implements LifeCycle,
ThreadPool {
    private static final Logger LOG = Log.getLogger(ExecutorThreadPool.class);
    private final ExecutorService _executor;

    public ExecutorThreadPool(ExecutorService executorService) {
        this._executor = executorService;
    }

    public ExecutorThreadPool() {
        this(new ThreadPoolExecutor(256, 256, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public ExecutorThreadPool(int n) {
        this(n < 0 ? new ThreadPoolExecutor(256, 256, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()) : (n == 0 ? new ThreadPoolExecutor(32, 256, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()) : new ThreadPoolExecutor(32, 256, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(n))));
    }

    public ExecutorThreadPool(int n, int n2, long l) {
        this(n, n2, l, TimeUnit.MILLISECONDS);
    }

    public ExecutorThreadPool(int n, int n2, long l, TimeUnit timeUnit) {
        this(n, n2, l, timeUnit, new LinkedBlockingQueue<Runnable>());
    }

    public ExecutorThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(new ThreadPoolExecutor(n, n2, l, timeUnit, blockingQueue));
    }

    @Override
    public void execute(Runnable runnable) {
        this._executor.execute(runnable);
    }

    public boolean dispatch(Runnable runnable) {
        try {
            this._executor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            LOG.warn(rejectedExecutionException);
            return false;
        }
    }

    @Override
    public int getIdleThreads() {
        if (this._executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this._executor;
            return threadPoolExecutor.getPoolSize() - threadPoolExecutor.getActiveCount();
        }
        return -1;
    }

    @Override
    public int getThreads() {
        if (this._executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this._executor;
            return threadPoolExecutor.getPoolSize();
        }
        return -1;
    }

    @Override
    public boolean isLowOnThreads() {
        if (this._executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this._executor;
            return threadPoolExecutor.getPoolSize() == threadPoolExecutor.getMaximumPoolSize() && threadPoolExecutor.getQueue().size() >= threadPoolExecutor.getPoolSize() - threadPoolExecutor.getActiveCount();
        }
        return false;
    }

    @Override
    public void join() {
        this._executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doStop() {
        super.doStop();
        this._executor.shutdownNow();
    }
}

