/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.Atomics;

public class SampleStatistic {
    protected final AtomicLong _max = new AtomicLong();
    protected final AtomicLong _total = new AtomicLong();
    protected final AtomicLong _count = new AtomicLong();
    protected final AtomicLong _totalVariance100 = new AtomicLong();

    public void reset() {
        this._max.set(0L);
        this._total.set(0L);
        this._count.set(0L);
        this._totalVariance100.set(0L);
    }

    public void set(long l) {
        long l2 = this._total.addAndGet(l);
        long l3 = this._count.incrementAndGet();
        if (l3 > 1L) {
            long l4 = l2 * 10L / l3;
            long l5 = l * 10L - l4;
            this._totalVariance100.addAndGet(l5 * l5);
        }
        Atomics.updateMax(this._max, l);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getTotal() {
        return this._total.get();
    }

    public long getCount() {
        return this._count.get();
    }

    public double getMean() {
        return (double)this._total.get() / (double)this._count.get();
    }

    public double getVariance() {
        long l = this._totalVariance100.get();
        long l2 = this._count.get();
        return l2 > 1L ? (double)l / 100.0 / (double)(l2 - 1L) : 0.0;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public String toString() {
        return String.format("%s@%x{c=%d,m=%d,t=%d,v100=%d}", this.getClass().getSimpleName(), this.hashCode(), this._count.get(), this._max.get(), this._total.get(), this._totalVariance100.get());
    }
}

