/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.util.Atomics;

public class CounterStatistic {
    protected final AtomicLong _max = new AtomicLong();
    protected final AtomicLong _curr = new AtomicLong();
    protected final AtomicLong _total = new AtomicLong();

    public void reset() {
        this._total.set(0L);
        this._max.set(0L);
        long l = this._curr.get();
        this._total.addAndGet(l);
        Atomics.updateMax(this._max, l);
    }

    public void reset(long l) {
        this._total.set(0L);
        this._max.set(0L);
        this._curr.set(l);
        if (l > 0L) {
            this._total.addAndGet(l);
            Atomics.updateMax(this._max, l);
        }
    }

    public long add(long l) {
        long l2 = this._curr.addAndGet(l);
        if (l > 0L) {
            this._total.addAndGet(l);
            Atomics.updateMax(this._max, l2);
        }
        return l2;
    }

    public long increment() {
        return this.add(1L);
    }

    public long decrement() {
        return this.add(-1L);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getCurrent() {
        return this._curr.get();
    }

    public long getTotal() {
        return this._total.get();
    }

    public String toString() {
        return String.format("%s@%x{c=%d,m=%d,t=%d}", this.getClass().getSimpleName(), this.hashCode(), this._curr.get(), this._max.get(), this._total.get());
    }
}

