/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class X509 {
    private static final Logger LOG = Log.getLogger(X509.class);
    private static final int KEY_USAGE__KEY_CERT_SIGN = 5;
    private static final int SUBJECT_ALTERNATIVE_NAMES__DNS_NAME = 2;
    private final X509Certificate _x509;
    private final String _alias;
    private final List<String> _hosts = new ArrayList<String>();
    private final List<String> _wilds = new ArrayList<String>();

    public static boolean isCertSign(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        return blArray != null && blArray[5];
    }

    public X509(String string, X509Certificate x509Certificate) {
        this._alias = string;
        this._x509 = x509Certificate;
        boolean bl = false;
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            for (List<?> list : collection) {
                if (((Number)list.get(0)).intValue() != 2) continue;
                String object = list.get(1).toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Certificate SAN alias={} CN={} in {}", string, object, this);
                }
                if (object == null) continue;
                bl = true;
                this.addName(object);
            }
        }
        if (!bl) {
            LdapName ldapName = new LdapName(x509Certificate.getSubjectX500Principal().getName("RFC2253"));
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                String string2 = rdn.getValue().toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Certificate CN alias={} CN={} in {}", string, string2, this);
                }
                if (string2 == null || !string2.contains(".") || string2.contains(" ")) continue;
                this.addName(string2);
            }
        }
    }

    protected void addName(String string) {
        if ((string = StringUtil.asciiToLowerCase(string)).startsWith("*.")) {
            this._wilds.add(string.substring(2));
        } else {
            this._hosts.add(string);
        }
    }

    public String getAlias() {
        return this._alias;
    }

    public X509Certificate getCertificate() {
        return this._x509;
    }

    public Set<String> getHosts() {
        return new HashSet<String>(this._hosts);
    }

    public Set<String> getWilds() {
        return new HashSet<String>(this._wilds);
    }

    public boolean matches(String string) {
        String string2;
        if (this._hosts.contains(string = StringUtil.asciiToLowerCase(string)) || this._wilds.contains(string)) {
            return true;
        }
        int n = string.indexOf(46);
        return n >= 0 && this._wilds.contains(string2 = string.substring(n + 1));
    }

    public String toString() {
        return String.format("%s@%x(%s,h=%s,w=%s)", this.getClass().getSimpleName(), this.hashCode(), this._alias, this._hosts, this._wilds);
    }
}

