/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.security.CertificateValidator;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.AliasedX509ExtendedKeyManager;
import org.eclipse.jetty.util.ssl.SniX509ExtendedKeyManager;
import org.eclipse.jetty.util.ssl.X509;

public class SslContextFactory
extends AbstractLifeCycle {
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }};
    static final Logger LOG = Log.getLogger(SslContextFactory.class);
    public static final String DEFAULT_KEYMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? KeyManagerFactory.getDefaultAlgorithm() : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    public static final String DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? TrustManagerFactory.getDefaultAlgorithm() : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    public static final String KEYPASSWORD_PROPERTY = "org.eclipse.jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "org.eclipse.jetty.ssl.password";
    private final Set<String> _excludeProtocols = new LinkedHashSet<String>();
    private final Set<String> _includeProtocols = new LinkedHashSet<String>();
    private String[] _selectedProtocols;
    private final Set<String> _excludeCipherSuites = new LinkedHashSet<String>();
    private final List<String> _includeCipherSuites = new ArrayList<String>();
    private boolean _useCipherSuitesOrder = true;
    Comparator<String> _cipherComparator;
    private String[] _selectedCipherSuites;
    private Resource _keyStoreResource;
    private String _keyStoreProvider;
    private String _keyStoreType = "JKS";
    private String _certAlias;
    private final Map<String, X509> _aliasX509 = new HashMap<String, X509>();
    private final Map<String, X509> _certHosts = new HashMap<String, X509>();
    private final Map<String, X509> _certWilds = new HashMap<String, X509>();
    private Resource _trustStoreResource;
    private String _trustStoreProvider;
    private String _trustStoreType = "JKS";
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private Password _keyStorePassword;
    private Password _keyManagerPassword;
    private Password _trustStorePassword;
    private String _sslProvider;
    private String _sslProtocol = "TLS";
    private String _secureRandomAlgorithm;
    private String _keyManagerFactoryAlgorithm = DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    private String _trustManagerFactoryAlgorithm = DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM;
    private boolean _validateCerts;
    private boolean _validatePeerCerts;
    private int _maxCertPathLength = -1;
    private String _crlPath;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;
    private KeyStore _setKeyStore;
    private KeyStore _setTrustStore;
    private boolean _sessionCachingEnabled = true;
    private int _sslSessionCacheSize;
    private int _sslSessionTimeout;
    private SSLContext _setContext;
    private String _endpointIdentificationAlgorithm = null;
    private boolean _trustAll;
    private boolean _renegotiationAllowed = true;
    protected Factory _factory;

    public SslContextFactory() {
        this(false);
    }

    public SslContextFactory(boolean bl) {
        this.setTrustAll(bl);
        this.addExcludeProtocols("SSL", "SSLv2", "SSLv2Hello", "SSLv3");
        this.setExcludeCipherSuites("^.*_RSA_.*_(MD5|SHA|SHA1)$", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
    }

    public SslContextFactory(String string) {
        this.setKeyStorePath(string);
    }

    public String[] getSelectedProtocols() {
        return Arrays.copyOf(this._selectedProtocols, this._selectedProtocols.length);
    }

    public String[] getSelectedCipherSuites() {
        return Arrays.copyOf(this._selectedCipherSuites, this._selectedCipherSuites.length);
    }

    public Comparator<String> getCipherComparator() {
        return this._cipherComparator;
    }

    public void setCipherComparator(Comparator<String> comparator) {
        if (comparator != null) {
            this.setUseCipherSuitesOrder(true);
        }
        this._cipherComparator = comparator;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this._aliasX509.keySet());
    }

    public X509 getX509(String string) {
        return this._aliasX509.get(string);
    }

    @Override
    protected void doStart() {
        TrustManager[] trustManagerArray;
        SSLContext sSLContext = this._setContext;
        KeyStore keyStore = this._setKeyStore;
        KeyStore keyStore2 = this._setTrustStore;
        if (sSLContext == null) {
            if (keyStore == null && this._keyStoreResource == null && keyStore2 == null && this._trustStoreResource == null) {
                trustManagerArray = null;
                if (this._trustAll) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No keystore or trust store configured.  ACCEPTING UNTRUSTED CERTIFICATES!!!!!", new Object[0]);
                    }
                    trustManagerArray = TRUST_ALL_CERTS;
                }
                SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
                sSLContext = this._sslProvider == null ? SSLContext.getInstance(this._sslProtocol) : SSLContext.getInstance(this._sslProtocol, this._sslProvider);
                sSLContext.init(null, trustManagerArray, secureRandom);
            } else {
                Serializable serializable;
                if (keyStore == null) {
                    keyStore = this.loadKeyStore(this._keyStoreResource);
                }
                if (keyStore2 == null) {
                    keyStore2 = this.loadTrustStore(this._trustStoreResource);
                }
                trustManagerArray = this.loadCRL(this._crlPath);
                this._certHosts.clear();
                if (keyStore != null) {
                    for (String object2 : Collections.list(keyStore.aliases())) {
                        serializable = keyStore.getCertificate(object2);
                        if (serializable == null || !"X.509".equals(((Certificate)serializable).getType())) continue;
                        X509Certificate x509Certificate = (X509Certificate)serializable;
                        if (X509.isCertSign(x509Certificate)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Skipping " + x509Certificate, new Object[0]);
                            continue;
                        }
                        X509 x509 = new X509(object2, x509Certificate);
                        this._aliasX509.put(object2, x509);
                        if (this._validateCerts) {
                            Iterator<String> iterator = new CertificateValidator(keyStore2, (Collection<? extends CRL>)trustManagerArray);
                            ((CertificateValidator)((Object)iterator)).setMaxCertPathLength(this._maxCertPathLength);
                            ((CertificateValidator)((Object)iterator)).setEnableCRLDP(this._enableCRLDP);
                            ((CertificateValidator)((Object)iterator)).setEnableOCSP(this._enableOCSP);
                            ((CertificateValidator)((Object)iterator)).setOcspResponderURL(this._ocspResponderURL);
                            ((CertificateValidator)((Object)iterator)).validate(keyStore, x509Certificate);
                        }
                        LOG.info("x509={} for {}", x509, this);
                        for (String string : x509.getHosts()) {
                            this._certHosts.put(string, x509);
                        }
                        for (String string : x509.getWilds()) {
                            this._certWilds.put(string, x509);
                        }
                    }
                }
                KeyManager[] keyManagerArray = this.getKeyManagers(keyStore);
                TrustManager[] trustManagerArray2 = this.getTrustManagers(keyStore2, (Collection<? extends CRL>)trustManagerArray);
                serializable = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
                sSLContext = this._sslProvider == null ? SSLContext.getInstance(this._sslProtocol) : SSLContext.getInstance(this._sslProtocol, this._sslProvider);
                sSLContext.init(keyManagerArray, trustManagerArray2, (SecureRandom)serializable);
            }
        }
        trustManagerArray = sSLContext.createSSLEngine();
        this.selectCipherSuites(trustManagerArray.getEnabledCipherSuites(), trustManagerArray.getSupportedCipherSuites());
        this.selectProtocols(trustManagerArray.getEnabledProtocols(), trustManagerArray.getSupportedProtocols());
        this._factory = new Factory(keyStore, keyStore2, sSLContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Selected Protocols {} of {}", Arrays.asList(this._selectedProtocols), Arrays.asList(trustManagerArray.getSupportedProtocols()));
            LOG.debug("Selected Ciphers   {} of {}", Arrays.asList(this._selectedCipherSuites), Arrays.asList(trustManagerArray.getSupportedCipherSuites()));
        }
    }

    @Override
    protected void doStop() {
        this._factory = null;
        super.doStop();
        this._certHosts.clear();
        this._certWilds.clear();
        this._aliasX509.clear();
    }

    public String[] getExcludeProtocols() {
        return this._excludeProtocols.toArray(new String[this._excludeProtocols.size()]);
    }

    public void setExcludeProtocols(String ... stringArray) {
        this.checkNotStarted();
        this._excludeProtocols.clear();
        this._excludeProtocols.addAll(Arrays.asList(stringArray));
    }

    public void addExcludeProtocols(String ... stringArray) {
        this.checkNotStarted();
        this._excludeProtocols.addAll(Arrays.asList(stringArray));
    }

    public String[] getIncludeProtocols() {
        return this._includeProtocols.toArray(new String[this._includeProtocols.size()]);
    }

    public void setIncludeProtocols(String ... stringArray) {
        this.checkNotStarted();
        this._includeProtocols.clear();
        this._includeProtocols.addAll(Arrays.asList(stringArray));
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites.toArray(new String[this._excludeCipherSuites.size()]);
    }

    public void setExcludeCipherSuites(String ... stringArray) {
        this.checkNotStarted();
        this._excludeCipherSuites.clear();
        this._excludeCipherSuites.addAll(Arrays.asList(stringArray));
    }

    public void addExcludeCipherSuites(String ... stringArray) {
        this.checkNotStarted();
        this._excludeCipherSuites.addAll(Arrays.asList(stringArray));
    }

    public String[] getIncludeCipherSuites() {
        return this._includeCipherSuites.toArray(new String[this._includeCipherSuites.size()]);
    }

    public void setIncludeCipherSuites(String ... stringArray) {
        this.checkNotStarted();
        this._includeCipherSuites.clear();
        this._includeCipherSuites.addAll(Arrays.asList(stringArray));
    }

    public boolean isUseCipherSuitesOrder() {
        return this._useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean bl) {
        this._useCipherSuitesOrder = bl;
    }

    public String getKeyStorePath() {
        return this._keyStoreResource.toString();
    }

    public void setKeyStorePath(String string) {
        this.checkNotStarted();
        try {
            this._keyStoreResource = Resource.newResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public String getKeyStoreProvider() {
        return this._keyStoreProvider;
    }

    public void setKeyStoreProvider(String string) {
        this.checkNotStarted();
        this._keyStoreProvider = string;
    }

    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    public void setKeyStoreType(String string) {
        this.checkNotStarted();
        this._keyStoreType = string;
    }

    public String getCertAlias() {
        return this._certAlias;
    }

    public void setCertAlias(String string) {
        this.checkNotStarted();
        this._certAlias = string;
    }

    public void setTrustStorePath(String string) {
        this.checkNotStarted();
        try {
            this._trustStoreResource = Resource.newResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public String getTrustStoreProvider() {
        return this._trustStoreProvider;
    }

    public void setTrustStoreProvider(String string) {
        this.checkNotStarted();
        this._trustStoreProvider = string;
    }

    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    public void setTrustStoreType(String string) {
        this.checkNotStarted();
        this._trustStoreType = string;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.checkNotStarted();
        this._needClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.checkNotStarted();
        this._wantClientAuth = bl;
    }

    public boolean isValidateCerts() {
        return this._validateCerts;
    }

    public void setValidateCerts(boolean bl) {
        this.checkNotStarted();
        this._validateCerts = bl;
    }

    public boolean isValidatePeerCerts() {
        return this._validatePeerCerts;
    }

    public void setValidatePeerCerts(boolean bl) {
        this.checkNotStarted();
        this._validatePeerCerts = bl;
    }

    public void setKeyStorePassword(String string) {
        this.checkNotStarted();
        this._keyStorePassword = string == null ? (this._keyStoreResource != null ? Password.getPassword(PASSWORD_PROPERTY, null, null) : null) : new Password(string);
    }

    public void setKeyManagerPassword(String string) {
        this.checkNotStarted();
        this._keyManagerPassword = string == null ? (System.getProperty(KEYPASSWORD_PROPERTY) != null ? Password.getPassword(KEYPASSWORD_PROPERTY, null, null) : null) : new Password(string);
    }

    public void setTrustStorePassword(String string) {
        this.checkNotStarted();
        this._trustStorePassword = string == null ? (this._trustStoreResource != null && !this._trustStoreResource.equals(this._keyStoreResource) ? Password.getPassword(PASSWORD_PROPERTY, null, null) : null) : new Password(string);
    }

    public String getProvider() {
        return this._sslProvider;
    }

    public void setProvider(String string) {
        this.checkNotStarted();
        this._sslProvider = string;
    }

    public String getProtocol() {
        return this._sslProtocol;
    }

    public void setProtocol(String string) {
        this.checkNotStarted();
        this._sslProtocol = string;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String string) {
        this.checkNotStarted();
        this._secureRandomAlgorithm = string;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._keyManagerFactoryAlgorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String string) {
        this.checkNotStarted();
        this._keyManagerFactoryAlgorithm = string;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    public boolean isTrustAll() {
        return this._trustAll;
    }

    public void setTrustAll(boolean bl) {
        this._trustAll = bl;
        if (bl) {
            this.setEndpointIdentificationAlgorithm(null);
        }
    }

    public void setTrustManagerFactoryAlgorithm(String string) {
        this.checkNotStarted();
        this._trustManagerFactoryAlgorithm = string;
    }

    public boolean isRenegotiationAllowed() {
        return this._renegotiationAllowed;
    }

    public void setRenegotiationAllowed(boolean bl) {
        this._renegotiationAllowed = bl;
    }

    public String getCrlPath() {
        return this._crlPath;
    }

    public void setCrlPath(String string) {
        this.checkNotStarted();
        this._crlPath = string;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    public void setMaxCertPathLength(int n) {
        this.checkNotStarted();
        this._maxCertPathLength = n;
    }

    public SSLContext getSslContext() {
        return this.isStarted() ? this._factory._context : this._setContext;
    }

    public void setSslContext(SSLContext sSLContext) {
        this.checkNotStarted();
        this._setContext = sSLContext;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this._endpointIdentificationAlgorithm = string;
    }

    protected KeyStore loadKeyStore(Resource resource) {
        return CertificateUtils.getKeyStore(resource, this._keyStoreType, this._keyStoreProvider, this._keyStorePassword == null ? null : this._keyStorePassword.toString());
    }

    protected KeyStore loadTrustStore(Resource resource) {
        String string;
        String string2 = this._trustStoreType;
        String string3 = this._trustStoreProvider;
        String string4 = string = this._trustStorePassword == null ? null : this._trustStorePassword.toString();
        if (resource == null || resource.equals(this._keyStoreResource)) {
            resource = this._keyStoreResource;
            if (string2 == null) {
                string2 = this._keyStoreType;
            }
            if (string3 == null) {
                string3 = this._keyStoreProvider;
            }
            if (string == null) {
                string = this._keyStorePassword == null ? null : this._keyStorePassword.toString();
            }
        }
        return CertificateUtils.getKeyStore(resource, string2, string3, string);
    }

    protected Collection<? extends CRL> loadCRL(String string) {
        return CertificateUtils.loadCRL(string);
    }

    protected KeyManager[] getKeyManagers(KeyStore keyStore) {
        KeyManager[] keyManagerArray = null;
        if (keyStore != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._keyManagerFactoryAlgorithm);
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? (this._keyStorePassword == null ? null : this._keyStorePassword.toString().toCharArray()) : this._keyManagerPassword.toString().toCharArray());
            keyManagerArray = keyManagerFactory.getKeyManagers();
            if (keyManagerArray != null) {
                int n;
                if (this._certAlias != null) {
                    for (n = 0; n < keyManagerArray.length; ++n) {
                        if (!(keyManagerArray[n] instanceof X509ExtendedKeyManager)) continue;
                        keyManagerArray[n] = new AliasedX509ExtendedKeyManager((X509ExtendedKeyManager)keyManagerArray[n], this._certAlias);
                    }
                }
                if (!this._certHosts.isEmpty() || !this._certWilds.isEmpty()) {
                    for (n = 0; n < keyManagerArray.length; ++n) {
                        if (!(keyManagerArray[n] instanceof X509ExtendedKeyManager)) continue;
                        keyManagerArray[n] = new SniX509ExtendedKeyManager((X509ExtendedKeyManager)keyManagerArray[n]);
                    }
                }
            }
        }
        LOG.debug("managers={} for {}", keyManagerArray, this);
        return keyManagerArray;
    }

    protected TrustManager[] getTrustManagers(KeyStore keyStore, Collection<? extends CRL> collection) {
        TrustManager[] trustManagerArray = null;
        if (keyStore != null) {
            if (this._validatePeerCerts && this._trustManagerFactoryAlgorithm.equalsIgnoreCase("PKIX")) {
                PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(keyStore, (CertSelector)new X509CertSelector());
                pKIXBuilderParameters.setMaxPathLength(this._maxCertPathLength);
                pKIXBuilderParameters.setRevocationEnabled(true);
                if (collection != null && !collection.isEmpty()) {
                    pKIXBuilderParameters.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(collection)));
                }
                if (this._enableCRLDP) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                }
                if (this._enableOCSP) {
                    Security.setProperty("ocsp.enable", "true");
                    if (this._ocspResponderURL != null) {
                        Security.setProperty("ocsp.responderURL", this._ocspResponderURL);
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(new CertPathTrustManagerParameters(pKIXBuilderParameters));
                trustManagerArray = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(keyStore);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
        }
        return trustManagerArray;
    }

    public void selectProtocols(String[] stringArray, String[] stringArray2) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (!this._includeProtocols.isEmpty()) {
            for (String string : this._includeProtocols) {
                if (Arrays.asList(stringArray2).contains(string)) {
                    linkedHashSet.add(string);
                    continue;
                }
                LOG.info("Protocol {} not supported in {}", string, Arrays.asList(stringArray2));
            }
        } else {
            linkedHashSet.addAll(Arrays.asList(stringArray));
        }
        linkedHashSet.removeAll(this._excludeProtocols);
        if (linkedHashSet.isEmpty()) {
            LOG.warn("No selected protocols from {}", Arrays.asList(stringArray2));
        }
        this._selectedProtocols = linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    protected void selectCipherSuites(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._includeCipherSuites.isEmpty()) {
            arrayList.addAll(Arrays.asList(stringArray));
        } else {
            this.processIncludeCipherSuites(stringArray2, arrayList);
        }
        this.removeExcludedCipherSuites(arrayList);
        if (arrayList.isEmpty()) {
            LOG.warn("No supported ciphers from {}", Arrays.asList(stringArray2));
        }
        if (this._cipherComparator != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sorting selected ciphers with {}", this._cipherComparator);
            }
            Collections.sort(arrayList, this._cipherComparator);
        }
        this._selectedCipherSuites = arrayList.toArray(new String[arrayList.size()]);
    }

    protected void processIncludeCipherSuites(String[] stringArray, List<String> list) {
        for (String string : this._includeCipherSuites) {
            Pattern pattern = Pattern.compile(string);
            boolean bl = false;
            for (String string2 : stringArray) {
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                bl = true;
                list.add(string2);
            }
            if (bl) continue;
            LOG.info("No Cipher matching '{}' is supported", string);
        }
    }

    protected void removeExcludedCipherSuites(List<String> list) {
        for (String string : this._excludeCipherSuites) {
            Pattern pattern = Pattern.compile(string);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                iterator.remove();
            }
        }
    }

    protected void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot modify configuration when " + this.getState());
        }
    }

    protected void checkIsStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("!STARTED: " + this);
        }
    }

    protected void checkIsRunning() {
        if (!this.isRunning()) {
            throw new IllegalStateException("!RUNNING: " + this);
        }
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    public void setEnableCRLDP(boolean bl) {
        this.checkNotStarted();
        this._enableCRLDP = bl;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    public void setEnableOCSP(boolean bl) {
        this.checkNotStarted();
        this._enableOCSP = bl;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    public void setOcspResponderURL(String string) {
        this.checkNotStarted();
        this._ocspResponderURL = string;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.checkNotStarted();
        this._setKeyStore = keyStore;
    }

    public KeyStore getKeyStore() {
        return this.isStarted() ? this._factory._keyStore : this._setKeyStore;
    }

    public void setTrustStore(KeyStore keyStore) {
        this.checkNotStarted();
        this._setTrustStore = keyStore;
    }

    public KeyStore getTrustStore() {
        return this.isStarted() ? this._factory._trustStore : this._setTrustStore;
    }

    public void setKeyStoreResource(Resource resource) {
        this.checkNotStarted();
        this._keyStoreResource = resource;
    }

    public Resource getKeyStoreResource() {
        return this._keyStoreResource;
    }

    public void setTrustStoreResource(Resource resource) {
        this.checkNotStarted();
        this._trustStoreResource = resource;
    }

    public Resource getTrustStoreResource() {
        return this._trustStoreResource;
    }

    public boolean isSessionCachingEnabled() {
        return this._sessionCachingEnabled;
    }

    public void setSessionCachingEnabled(boolean bl) {
        this._sessionCachingEnabled = bl;
    }

    public int getSslSessionCacheSize() {
        return this._sslSessionCacheSize;
    }

    public void setSslSessionCacheSize(int n) {
        this._sslSessionCacheSize = n;
    }

    public int getSslSessionTimeout() {
        return this._sslSessionTimeout;
    }

    public void setSslSessionTimeout(int n) {
        this._sslSessionTimeout = n;
    }

    public SSLServerSocket newSslServerSocket(String string, int n, int n2) {
        this.checkIsStarted();
        SSLServerSocketFactory sSLServerSocketFactory = this._factory._context.getServerSocketFactory();
        SSLServerSocket sSLServerSocket = (SSLServerSocket)(string == null ? sSLServerSocketFactory.createServerSocket(n, n2) : sSLServerSocketFactory.createServerSocket(n, n2, InetAddress.getByName(string)));
        if (this.getWantClientAuth()) {
            sSLServerSocket.setWantClientAuth(this.getWantClientAuth());
        }
        if (this.getNeedClientAuth()) {
            sSLServerSocket.setNeedClientAuth(this.getNeedClientAuth());
        }
        sSLServerSocket.setEnabledCipherSuites(this._selectedCipherSuites);
        sSLServerSocket.setEnabledProtocols(this._selectedProtocols);
        return sSLServerSocket;
    }

    public SSLSocket newSslSocket() {
        this.checkIsStarted();
        SSLSocketFactory sSLSocketFactory = this._factory._context.getSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
        if (this.getWantClientAuth()) {
            sSLSocket.setWantClientAuth(this.getWantClientAuth());
        }
        if (this.getNeedClientAuth()) {
            sSLSocket.setNeedClientAuth(this.getNeedClientAuth());
        }
        sSLSocket.setEnabledCipherSuites(this._selectedCipherSuites);
        sSLSocket.setEnabledProtocols(this._selectedProtocols);
        return sSLSocket;
    }

    public SSLEngine newSSLEngine() {
        this.checkIsRunning();
        SSLEngine sSLEngine = this._factory._context.createSSLEngine();
        this.customize(sSLEngine);
        return sSLEngine;
    }

    public SSLEngine newSSLEngine(String string, int n) {
        this.checkIsStarted();
        SSLEngine sSLEngine = this.isSessionCachingEnabled() ? this._factory._context.createSSLEngine(string, n) : this._factory._context.createSSLEngine();
        this.customize(sSLEngine);
        return sSLEngine;
    }

    public SSLEngine newSSLEngine(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return this.newSSLEngine();
        }
        boolean bl = this.getNeedClientAuth();
        String string = bl ? inetSocketAddress.getHostName() : inetSocketAddress.getAddress().getHostAddress();
        return this.newSSLEngine(string, inetSocketAddress.getPort());
    }

    public void customize(SSLEngine sSLEngine) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Customize {}", sSLEngine);
        }
        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
        sSLParameters.setEndpointIdentificationAlgorithm(this._endpointIdentificationAlgorithm);
        sSLParameters.setUseCipherSuitesOrder(this._useCipherSuitesOrder);
        if (!this._certHosts.isEmpty() || !this._certWilds.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enable SNI matching {}", sSLEngine);
            }
            sSLParameters.setSNIMatchers(Collections.singletonList(new AliasSNIMatcher()));
        }
        sSLParameters.setCipherSuites(this._selectedCipherSuites);
        sSLParameters.setProtocols(this._selectedProtocols);
        if (this.getWantClientAuth()) {
            sSLParameters.setWantClientAuth(true);
        }
        if (this.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        }
        sSLEngine.setSSLParameters(sSLParameters);
    }

    public static X509Certificate[] getCertChain(SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return null;
            }
            int n = certificateArray.length;
            X509Certificate[] x509CertificateArray = new X509Certificate[n];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < n; ++i) {
                byte[] byArray = certificateArray[i].getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                x509CertificateArray[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
            return x509CertificateArray;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
        catch (Exception exception) {
            LOG.warn("EXCEPTION ", exception);
            return null;
        }
    }

    public static int deduceKeyLength(String string) {
        if (string == null) {
            return 0;
        }
        if (string.contains("WITH_AES_256_")) {
            return 256;
        }
        if (string.contains("WITH_RC4_128_")) {
            return 128;
        }
        if (string.contains("WITH_AES_128_")) {
            return 128;
        }
        if (string.contains("WITH_RC4_40_")) {
            return 40;
        }
        if (string.contains("WITH_3DES_EDE_CBC_")) {
            return 168;
        }
        if (string.contains("WITH_IDEA_CBC_")) {
            return 128;
        }
        if (string.contains("WITH_RC2_CBC_40_")) {
            return 40;
        }
        if (string.contains("WITH_DES40_CBC_")) {
            return 40;
        }
        if (string.contains("WITH_DES_CBC_")) {
            return 56;
        }
        return 0;
    }

    public String toString() {
        return String.format("%s@%x(%s,%s)", this.getClass().getSimpleName(), this.hashCode(), this._keyStoreResource, this._trustStoreResource);
    }

    class AliasSNIMatcher
    extends SNIMatcher {
        private String _host;
        private X509 _x509;

        AliasSNIMatcher() {
            super(0);
        }

        @Override
        public boolean matches(SNIServerName sNIServerName) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SNI matching for {}", sNIServerName);
            }
            if (sNIServerName instanceof SNIHostName) {
                String string = this._host = ((SNIHostName)sNIServerName).getAsciiName();
                string = StringUtil.asciiToLowerCase(string);
                this._x509 = (X509)SslContextFactory.this._certHosts.get(string);
                if (this._x509 == null) {
                    int n;
                    this._x509 = (X509)SslContextFactory.this._certWilds.get(string);
                    if (this._x509 == null && (n = string.indexOf(46)) >= 0) {
                        String string2 = string.substring(n + 1);
                        this._x509 = (X509)SslContextFactory.this._certWilds.get(string2);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SNI matched {}->{}", string, this._x509);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("SNI no match for {}", sNIServerName);
            }
            return true;
        }

        public String getHost() {
            return this._host;
        }

        public X509 getX509() {
            return this._x509;
        }
    }

    protected class Factory {
        final KeyStore _keyStore;
        final KeyStore _trustStore;
        final SSLContext _context;

        public Factory(KeyStore keyStore, KeyStore keyStore2, SSLContext sSLContext) {
            this._keyStore = keyStore;
            this._trustStore = keyStore2;
            this._context = sSLContext;
        }

        public String toString() {
            return String.format("SslFactory@%x{%s}", System.identityHashCode(this), SslContextFactory.this);
        }
    }
}

