/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.ssl.X509;

public class SniX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    public static final String SNI_X509 = "org.eclipse.jetty.util.ssl.snix509";
    private static final String NO_MATCHERS = "no_matchers";
    private static final Logger LOG = Log.getLogger(SniX509ExtendedKeyManager.class);
    private final X509ExtendedKeyManager _delegate;

    public SniX509ExtendedKeyManager(X509ExtendedKeyManager x509ExtendedKeyManager) {
        this._delegate = x509ExtendedKeyManager;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this._delegate.chooseClientAlias(stringArray, principalArray, socket);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this._delegate.chooseEngineClientAlias(stringArray, principalArray, sSLEngine);
    }

    protected String chooseServerAlias(String string, Principal[] principalArray, Collection<SNIMatcher> collection, SSLSession sSLSession) {
        String[] stringArray = this._delegate.getServerAliases(string, principalArray);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string2 = null;
        X509 x509 = null;
        if (collection != null) {
            for (SNIMatcher sNIMatcher : collection) {
                if (!(sNIMatcher instanceof SslContextFactory.AliasSNIMatcher)) continue;
                SslContextFactory.AliasSNIMatcher aliasSNIMatcher = (SslContextFactory.AliasSNIMatcher)sNIMatcher;
                string2 = aliasSNIMatcher.getHost();
                x509 = aliasSNIMatcher.getX509();
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matched {} with {} from {}", string2, x509, Arrays.asList(stringArray));
        }
        if (x509 != null) {
            for (String string3 : stringArray) {
                if (!string3.equals(x509.getAlias())) continue;
                sSLSession.putValue(SNI_X509, x509);
                return string3;
            }
            return null;
        }
        return NO_MATCHERS;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        SSLSocket sSLSocket = (SSLSocket)socket;
        String string2 = this.chooseServerAlias(string, principalArray, sSLSocket.getSSLParameters().getSNIMatchers(), sSLSocket.getHandshakeSession());
        if (string2 == NO_MATCHERS) {
            string2 = this._delegate.chooseServerAlias(string, principalArray, socket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Chose alias {}/{} on {}", string2, string, socket);
        }
        return string2;
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        String string2 = this.chooseServerAlias(string, principalArray, sSLEngine.getSSLParameters().getSNIMatchers(), sSLEngine.getHandshakeSession());
        if (string2 == NO_MATCHERS) {
            string2 = this._delegate.chooseEngineServerAlias(string, principalArray, sSLEngine);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Chose alias {}/{} on {}", string2, string, sSLEngine);
        }
        return string2;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this._delegate.getCertificateChain(string);
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this._delegate.getClientAliases(string, principalArray);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this._delegate.getPrivateKey(string);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this._delegate.getServerAliases(string, principalArray);
    }
}

