/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public class Password
extends Credential {
    private static final Logger LOG = Log.getLogger(Password.class);
    private static final long serialVersionUID = 5062906681431569445L;
    public static final String __OBFUSCATE = "OBF:";
    private String _pw;

    public Password(String string) {
        this._pw = string;
        while (this._pw != null && this._pw.startsWith(__OBFUSCATE)) {
            this._pw = Password.deobfuscate(this._pw);
        }
    }

    public String toString() {
        return this._pw;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this._pw.length());
    }

    @Override
    public boolean check(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Password) {
            return object.equals(this._pw);
        }
        if (object instanceof String) {
            return object.equals(this._pw);
        }
        if (object instanceof char[]) {
            return Arrays.equals(this._pw.toCharArray(), (char[])object);
        }
        if (object instanceof Credential) {
            return ((Credential)object).check(this._pw);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (object instanceof Password) {
            Password password = (Password)object;
            return password._pw == this._pw || null != this._pw && this._pw.equals(password._pw);
        }
        if (object instanceof String) {
            return object.equals(this._pw);
        }
        return false;
    }

    public int hashCode() {
        return null == this._pw ? super.hashCode() : this._pw.hashCode();
    }

    public static String obfuscate(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        stringBuilder.append(__OBFUSCATE);
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            byte by = byArray[i];
            byte by2 = byArray[byArray.length - (i + 1)];
            if (by < 0 || by2 < 0) {
                n = (0xFF & by) * 256 + (0xFF & by2);
                String string2 = Integer.toString(n, 36).toLowerCase();
                stringBuilder.append("U0000", 0, 5 - string2.length());
                stringBuilder.append(string2);
                continue;
            }
            n = 127 + by + by2;
            int n2 = 127 + by - by2;
            int n3 = n * 256 + n2;
            String string3 = Integer.toString(n3, 36).toLowerCase();
            int n4 = Integer.parseInt(string3, 36);
            int n5 = n3 / 256;
            int n6 = n3 % 256;
            byte by3 = (byte)((n5 + n6 - 254) / 2);
            stringBuilder.append("000", 0, 4 - string3.length());
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static String deobfuscate(String string) {
        if (string.startsWith(__OBFUSCATE)) {
            string = string.substring(4);
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length(); i += 4) {
            int n2;
            int n3;
            String string2;
            if (string.charAt(i) == 'U') {
                string2 = string.substring(++i, i + 4);
                n3 = Integer.parseInt(string2, 36);
                n2 = (byte)(n3 >> 8);
                byArray[n++] = n2;
                continue;
            }
            string2 = string.substring(i, i + 4);
            n3 = Integer.parseInt(string2, 36);
            n2 = n3 / 256;
            int n4 = n3 % 256;
            byte by = (byte)((n2 + n4 - 254) / 2);
            byArray[n++] = by;
        }
        return new String(byArray, 0, n, StandardCharsets.UTF_8);
    }

    public static Password getPassword(String string, String string2, String string3) {
        String string4 = System.getProperty(string, string2);
        if (string4 == null || string4.length() == 0) {
            try {
                System.out.print(string + (string3 != null && string3.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                byte[] byArray = new byte[512];
                int n = System.in.read(byArray);
                if (n > 0) {
                    string4 = new String(byArray, 0, n).trim();
                }
            }
            catch (IOException iOException) {
                LOG.warn("EXCEPTION ", iOException);
            }
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
            }
        }
        return new Password(string4);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            System.err.println("Usage - java " + Password.class.getName() + " [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String string = stringArray[stringArray.length == 1 ? 0 : 1];
        Password password = new Password(string);
        System.err.println(password.toString());
        System.err.println(Password.obfuscate(password.toString()));
        System.err.println(Credential.MD5.digest(string));
        if (stringArray.length == 2) {
            System.err.println(Credential.Crypt.crypt(stringArray[0], password.toString()));
        }
    }
}

