/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.eclipse.jetty.util.resource.Resource;

public class CertificateUtils {
    public static KeyStore getKeyStore(Resource resource, String string, String string2, String string3) {
        KeyStore keyStore = null;
        if (resource != null) {
            keyStore = string2 != null ? KeyStore.getInstance(string, string2) : KeyStore.getInstance(string);
            if (!resource.exists()) {
                throw new IllegalStateException("no valid keystore");
            }
            try (InputStream inputStream = resource.getInputStream();){
                keyStore.load(inputStream, string3 == null ? null : string3.toCharArray());
            }
        }
        return keyStore;
    }

    public static Collection<? extends CRL> loadCRL(String string) {
        Collection<? extends CRL> collection = null;
        if (string != null) {
            try (InputStream inputStream = null;){
                inputStream = Resource.newResource(string).getInputStream();
                collection = CertificateFactory.getInstance("X.509").generateCRLs(inputStream);
            }
        }
        return collection;
    }
}

