/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceCollection
extends Resource {
    private static final Logger LOG = Log.getLogger(ResourceCollection.class);
    private Resource[] _resources;

    public ResourceCollection() {
        this._resources = new Resource[0];
    }

    public ResourceCollection(Resource ... resourceArray) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : resourceArray) {
            if (resource == null) continue;
            if (resource instanceof ResourceCollection) {
                for (Resource resource2 : ((ResourceCollection)resource).getResources()) {
                    arrayList.add(resource2);
                }
                continue;
            }
            arrayList.add(resource);
        }
        this._resources = arrayList.toArray(new Resource[arrayList.size()]);
        for (Resource resource : this._resources) {
            if (resource.exists() && resource.isDirectory()) continue;
            throw new IllegalArgumentException(resource + " is not an existing directory.");
        }
    }

    public ResourceCollection(String[] stringArray) {
        this._resources = new Resource[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this._resources[i] = Resource.newResource(stringArray[i]);
                if (this._resources[i].exists() && this._resources[i].isDirectory()) continue;
                throw new IllegalArgumentException(this._resources[i] + " is not an existing directory.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ResourceCollection(String string) {
        this.setResourcesAsCSV(string);
    }

    public Resource[] getResources() {
        return this._resources;
    }

    public void setResources(Resource[] resourceArray) {
        this._resources = resourceArray != null ? resourceArray : new Resource[]{};
    }

    public void setResourcesAsCSV(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            throw new IllegalArgumentException("ResourceCollection@setResourcesAsCSV(String)  argument must be a string containing one or more comma-separated resource strings.");
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                Resource resource = Resource.newResource(stringTokenizer.nextToken().trim());
                if (!resource.exists() || !resource.isDirectory()) {
                    LOG.warn(" !exist " + resource, new Object[0]);
                    continue;
                }
                arrayList.add(resource);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this._resources = arrayList.toArray(new Resource[arrayList.size()]);
    }

    @Override
    public Resource addPath(String string) {
        int n;
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        if (string == null) {
            throw new MalformedURLException();
        }
        if (string.length() == 0 || "/".equals(string)) {
            return this;
        }
        Resource resource = null;
        ArrayList<Resource> arrayList = null;
        for (n = 0; n < this._resources.length; ++n) {
            resource = this._resources[n].addPath(string);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++n;
        while (n < this._resources.length) {
            Resource resource2 = this._resources[n].addPath(string);
            if (resource2.exists() && resource2.isDirectory()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Resource>();
                }
                if (resource != null) {
                    arrayList.add(resource);
                    resource = null;
                }
                arrayList.add(resource2);
            }
            ++n;
        }
        if (resource != null) {
            return resource;
        }
        if (arrayList != null) {
            return new ResourceCollection(arrayList.toArray(new Resource[arrayList.size()]));
        }
        return null;
    }

    protected Object findResource(String string) {
        int n;
        Resource resource = null;
        ArrayList<Resource> arrayList = null;
        for (n = 0; n < this._resources.length; ++n) {
            resource = this._resources[n].addPath(string);
            if (!resource.exists()) continue;
            if (resource.isDirectory()) break;
            return resource;
        }
        ++n;
        while (n < this._resources.length) {
            Resource resource2 = this._resources[n].addPath(string);
            if (resource2.exists() && resource2.isDirectory()) {
                if (resource != null) {
                    arrayList = new ArrayList<Resource>();
                    arrayList.add(resource);
                }
                arrayList.add(resource2);
            }
            ++n;
        }
        if (resource != null) {
            return resource;
        }
        if (arrayList != null) {
            return arrayList;
        }
        return null;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean exists() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    @Override
    public File getFile() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource resource : this._resources) {
            File file = resource.getFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource resource : this._resources) {
            InputStream inputStream = resource.getInputStream();
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource resource : this._resources) {
            ReadableByteChannel readableByteChannel = resource.getReadableByteChannel();
            if (readableByteChannel == null) continue;
            return readableByteChannel;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource resource : this._resources) {
            String string = resource.getName();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public URL getURL() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource resource : this._resources) {
            URL uRL = resource.getURL();
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        return true;
    }

    @Override
    public long lastModified() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource resource : this._resources) {
            long l = resource.lastModified();
            if (l == -1L) continue;
            return l;
        }
        return -1L;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public String[] list() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Resource resource : this._resources) {
            for (String string : resource.list()) {
                hashSet.add(string);
            }
        }
        Object[] objectArray = hashSet.toArray(new String[hashSet.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public void close() {
        if (this._resources == null) {
            throw new IllegalStateException("*resources* not set.");
        }
        for (Resource resource : this._resources) {
            resource.close();
        }
    }

    @Override
    public boolean renameTo(Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(File file) {
        int n = this._resources.length;
        while (n-- > 0) {
            this._resources[n].copyTo(file);
        }
    }

    public String toString() {
        if (this._resources == null) {
            return "[]";
        }
        return String.valueOf(Arrays.asList(this._resources));
    }

    @Override
    public boolean isContainedIn(Resource resource) {
        return false;
    }
}

