/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.BadResource;
import org.eclipse.jetty.util.resource.JarFileResource;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResource;

public abstract class Resource
implements Closeable,
ResourceFactory {
    private static final Logger LOG = Log.getLogger(Resource.class);
    public static boolean __defaultUseCaches = true;
    volatile Object _associate;

    public static void setDefaultUseCaches(boolean bl) {
        __defaultUseCaches = bl;
    }

    public static boolean getDefaultUseCaches() {
        return __defaultUseCaches;
    }

    public static Resource newResource(URI uRI) {
        return Resource.newResource(uRI.toURL());
    }

    public static Resource newResource(URL uRL) {
        return Resource.newResource(uRL, __defaultUseCaches);
    }

    static Resource newResource(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        if (string.startsWith("file:")) {
            try {
                return new PathResource(uRL);
            }
            catch (Exception exception) {
                LOG.warn(exception.toString(), new Object[0]);
                LOG.debug("EXCEPTION ", exception);
                return new BadResource(uRL, exception.toString());
            }
        }
        if (string.startsWith("jar:file:")) {
            return new JarFileResource(uRL, bl);
        }
        if (string.startsWith("jar:")) {
            return new JarResource(uRL, bl);
        }
        return new URLResource(uRL, null, bl);
    }

    public static Resource newResource(String string) {
        return Resource.newResource(string, __defaultUseCaches);
    }

    public static Resource newResource(String string, boolean bl) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (!(string.startsWith("ftp:") || string.startsWith("file:") || string.startsWith("jar:"))) {
                try {
                    if (string.startsWith("./")) {
                        string = string.substring(2);
                    }
                    File file = new File(string).getCanonicalFile();
                    return new PathResource(file.toPath());
                }
                catch (Exception exception) {
                    LOG.debug("EXCEPTION ", exception);
                    throw malformedURLException;
                }
            }
            LOG.warn("Bad Resource: " + string, new Object[0]);
            throw malformedURLException;
        }
        return Resource.newResource(uRL, bl);
    }

    public static Resource newResource(File file) {
        return new PathResource(file.toPath());
    }

    public static Resource newSystemResource(String string) {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                uRL = classLoader.getResource(string);
                if (uRL == null && string.startsWith("/")) {
                    uRL = classLoader.getResource(string.substring(1));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                uRL = null;
            }
        }
        if (uRL == null && (classLoader = Resource.class.getClassLoader()) != null && (uRL = classLoader.getResource(string)) == null && string.startsWith("/")) {
            uRL = classLoader.getResource(string.substring(1));
        }
        if (uRL == null && (uRL = ClassLoader.getSystemResource(string)) == null && string.startsWith("/")) {
            uRL = ClassLoader.getSystemResource(string.substring(1));
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL);
    }

    public static Resource newClassPathResource(String string) {
        return Resource.newClassPathResource(string, true, false);
    }

    public static Resource newClassPathResource(String string, boolean bl, boolean bl2) {
        URL uRL = Resource.class.getResource(string);
        if (uRL == null) {
            uRL = Loader.getResource(Resource.class, string);
        }
        if (uRL == null) {
            return null;
        }
        return Resource.newResource(uRL, bl);
    }

    public static boolean isContainedIn(Resource resource, Resource resource2) {
        return resource.isContainedIn(resource2);
    }

    protected void finalize() {
        this.close();
    }

    public abstract boolean isContainedIn(Resource var1);

    public final void release() {
        this.close();
    }

    @Override
    public abstract void close();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    @Deprecated
    public abstract URL getURL();

    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public abstract File getFile();

    public abstract String getName();

    public abstract InputStream getInputStream();

    public abstract ReadableByteChannel getReadableByteChannel();

    public abstract boolean delete();

    public abstract boolean renameTo(Resource var1);

    public abstract String[] list();

    public abstract Resource addPath(String var1);

    @Override
    public Resource getResource(String string) {
        try {
            return this.addPath(string);
        }
        catch (Exception exception) {
            LOG.debug(exception);
            return null;
        }
    }

    @Deprecated
    public String encode(String string) {
        return null;
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object object) {
        this._associate = object;
    }

    public boolean isAlias() {
        return this.getAlias() != null;
    }

    public URI getAlias() {
        return null;
    }

    public String getListHTML(String string, boolean bl) {
        if ((string = URIUtil.canonicalPath(string)) == null || !this.isDirectory()) {
            return null;
        }
        Object[] objectArray = this.list();
        if (objectArray == null) {
            return null;
        }
        Arrays.sort(objectArray);
        String string2 = URIUtil.decodePath(string);
        String string3 = "Directory: " + Resource.deTag(string2);
        StringBuilder stringBuilder = new StringBuilder(4096);
        stringBuilder.append("<HTML><HEAD>");
        stringBuilder.append("<LINK HREF=\"").append("jetty-dir.css").append("\" REL=\"stylesheet\" TYPE=\"text/css\"/><TITLE>");
        stringBuilder.append(string3);
        stringBuilder.append("</TITLE></HEAD><BODY>\n<H1>");
        stringBuilder.append(string3);
        stringBuilder.append("</H1>\n<TABLE BORDER=0>\n");
        if (bl) {
            stringBuilder.append("<TR><TD><A HREF=\"");
            stringBuilder.append(URIUtil.addPaths(string, "../"));
            stringBuilder.append("\">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        String string4 = Resource.hrefEncodeURI(string);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        for (int i = 0; i < objectArray.length; ++i) {
            Resource resource = this.addPath((String)objectArray[i]);
            stringBuilder.append("\n<TR><TD><A HREF=\"");
            String string5 = URIUtil.addPaths(string4, URIUtil.encodePath((String)objectArray[i]));
            stringBuilder.append(string5);
            if (resource.isDirectory() && !string5.endsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append("\">");
            stringBuilder.append(Resource.deTag((String)objectArray[i]));
            stringBuilder.append("&nbsp;");
            stringBuilder.append("</A></TD><TD ALIGN=right>");
            stringBuilder.append(resource.length());
            stringBuilder.append(" bytes&nbsp;</TD><TD>");
            stringBuilder.append(dateFormat.format(new Date(resource.lastModified())));
            stringBuilder.append("</TD></TR>");
        }
        stringBuilder.append("</TABLE>\n");
        stringBuilder.append("</BODY></HTML>\n");
        return stringBuilder.toString();
    }

    private static String hrefEncodeURI(String string) {
        char c;
        int n;
        StringBuffer stringBuffer = null;
        block9: for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    stringBuffer = new StringBuffer(string.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (stringBuffer == null) {
            return string;
        }
        block10: for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            switch (c) {
                case '\"': {
                    stringBuffer.append("%22");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("%27");
                    continue block10;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                    continue block10;
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String deTag(String string) {
        return StringUtil.sanitizeXmlString(string);
    }

    public void writeTo(OutputStream outputStream, long l, long l2) {
        try (InputStream inputStream = this.getInputStream();){
            inputStream.skip(l);
            if (l2 < 0L) {
                IO.copy(inputStream, outputStream);
            } else {
                IO.copy(inputStream, outputStream, l2);
            }
        }
    }

    public void copyTo(File file) {
        if (file.exists()) {
            throw new IllegalArgumentException(file + " exists");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.writeTo(fileOutputStream, 0L, -1L);
        }
    }

    public String getWeakETag() {
        return this.getWeakETag("");
    }

    public String getWeakETag(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("W/\"");
            String string2 = this.getName();
            int n = string2.length();
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                l = 31L * l + (long)string2.charAt(i);
            }
            B64Code.encode(this.lastModified() ^ l, (Appendable)stringBuilder);
            B64Code.encode(this.length() ^ l, (Appendable)stringBuilder);
            stringBuilder.append(string);
            stringBuilder.append('\"');
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Collection<Resource> getAllResources() {
        try {
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            String[] stringArray = this.list();
            if (stringArray != null) {
                for (String string : stringArray) {
                    Resource resource = this.addPath(string);
                    if (resource.isDirectory()) {
                        arrayList.addAll(resource.getAllResources());
                        continue;
                    }
                    arrayList.add(resource);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static URL toURL(File file) {
        return file.toURI().toURL();
    }
}

