/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class PathResource
extends Resource {
    private static final Logger LOG = Log.getLogger(PathResource.class);
    private static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
    private final Path path;
    private final Path alias;
    private final URI uri;

    private static final Path checkAliasPath(Path path) {
        Path path2 = path;
        if (!path2.isAbsolute()) {
            path2 = path.toAbsolutePath();
        }
        try {
            if (Files.isSymbolicLink(path)) {
                return Files.readSymbolicLink(path);
            }
            if (Files.exists(path, new LinkOption[0])) {
                int n;
                Path path3 = path2.toRealPath(FOLLOW_LINKS);
                int n2 = path2.getNameCount();
                if (n2 != (n = path3.getNameCount())) {
                    return path3;
                }
                for (int i = n - 1; i >= 0; --i) {
                    if (path2.getName(i).toString().equals(path3.getName(i).toString())) continue;
                    return path3;
                }
            }
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
        }
        catch (Exception exception) {
            LOG.warn("bad alias ({} {}) for {}", exception.getClass().getName(), exception.getMessage(), path);
        }
        return null;
    }

    public PathResource(File file) {
        this(file.toPath());
    }

    public PathResource(Path path) {
        this.path = path.toAbsolutePath();
        this.uri = this.path.toUri();
        this.alias = PathResource.checkAliasPath(path);
    }

    public PathResource(URI uRI) {
        Path path;
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri");
        }
        if (!uRI.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("not file: scheme");
        }
        try {
            path = new File(uRI).toPath();
        }
        catch (InvalidPathException invalidPathException) {
            throw invalidPathException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            LOG.ignore(exception);
            throw new IOException("Unable to build Path from: " + uRI, exception);
        }
        this.path = path.toAbsolutePath();
        this.uri = path.toUri();
        this.alias = PathResource.checkAliasPath(path);
    }

    public PathResource(URL uRL) {
        this(uRL.toURI());
    }

    @Override
    public Resource addPath(String string) {
        String string2 = URIUtil.canonicalPath(string);
        if (string2 == null || string2.length() == 0) {
            throw new MalformedURLException();
        }
        if ("/".equals(string2)) {
            return this;
        }
        return new PathResource(this.path.getFileSystem().getPath(this.path.toString(), string));
    }

    @Override
    public void close() {
    }

    @Override
    public boolean delete() {
        try {
            return Files.deleteIfExists(this.path);
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PathResource pathResource = (PathResource)object;
        return !(this.path == null ? pathResource.path != null : !this.path.equals(pathResource.path));
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path, NO_FOLLOW_LINKS);
    }

    @Override
    public File getFile() {
        return this.path.toFile();
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() {
        return Files.newInputStream(this.path, StandardOpenOption.READ);
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() {
        return FileChannel.open(this.path, StandardOpenOption.READ);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public URL getURL() {
        try {
            return this.path.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.path == null ? 0 : this.path.hashCode());
        return n2;
    }

    @Override
    public boolean isContainedIn(Resource resource) {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, FOLLOW_LINKS);
    }

    @Override
    public long lastModified() {
        try {
            FileTime fileTime = Files.getLastModifiedTime(this.path, FOLLOW_LINKS);
            return fileTime.toMillis();
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return Files.size(this.path);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public boolean isAlias() {
        return this.alias != null;
    }

    public Path getAliasPath() {
        return this.alias;
    }

    @Override
    public URI getAlias() {
        return this.alias == null ? null : this.alias.toUri();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] list() {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.path);){
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Path stringArray2 : directoryStream) {
                String throwable2 = stringArray2.getFileName().toString();
                if (Files.isDirectory(stringArray2, new LinkOption[0])) {
                    throwable2 = throwable2 + "/";
                }
                arrayList.add(throwable2);
            }
            int n = arrayList.size();
            String[] stringArray = arrayList.toArray(new String[n]);
            return stringArray;
        }
        catch (DirectoryIteratorException directoryIteratorException) {
            LOG.debug(directoryIteratorException);
            return null;
        }
        catch (IOException iOException) {
            LOG.debug(iOException);
        }
        return null;
    }

    @Override
    public boolean renameTo(Resource resource) {
        if (resource instanceof PathResource) {
            PathResource pathResource = (PathResource)resource;
            try {
                Path path = Files.move(this.path, pathResource.path, new CopyOption[0]);
                return Files.exists(path, NO_FOLLOW_LINKS);
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
                return false;
            }
        }
        return false;
    }

    @Override
    public void copyTo(File file) {
        if (this.isDirectory()) {
            IO.copyDir(this.path.toFile(), file);
        } else {
            Files.copy(this.path, file.toPath(), new CopyOption[0]);
        }
    }

    public String toString() {
        return this.uri.toASCIIString();
    }
}

