/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;

public class JarResource
extends URLResource {
    private static final Logger LOG = Log.getLogger(JarResource.class);
    protected JarURLConnection _jarConnection;

    protected JarResource(URL uRL) {
        super(uRL, null);
    }

    protected JarResource(URL uRL, boolean bl) {
        super(uRL, null, bl);
    }

    @Override
    public synchronized void close() {
        this._jarConnection = null;
        super.close();
    }

    @Override
    protected synchronized boolean checkConnection() {
        super.checkConnection();
        try {
            if (this._jarConnection != this._connection) {
                this.newConnection();
            }
        }
        catch (IOException iOException) {
            LOG.ignore(iOException);
            this._jarConnection = null;
        }
        return this._jarConnection != null;
    }

    protected void newConnection() {
        this._jarConnection = (JarURLConnection)this._connection;
    }

    @Override
    public boolean exists() {
        if (this._urlString.endsWith("!/")) {
            return this.checkConnection();
        }
        return super.exists();
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public InputStream getInputStream() {
        this.checkConnection();
        if (!this._urlString.endsWith("!/")) {
            return new FilterInputStream(this.getInputStream(false)){

                @Override
                public void close() {
                    this.in = IO.getClosedStream();
                }
            };
        }
        URL uRL = new URL(this._urlString.substring(4, this._urlString.length() - 2));
        InputStream inputStream = uRL.openStream();
        return inputStream;
    }

    @Override
    public void copyTo(File file) {
        block61: {
            boolean bl;
            String string;
            int n;
            int n2;
            if (!this.exists()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Extract " + this + " to " + file, new Object[0]);
            }
            int n3 = n2 = (n = (string = this.getURL().toExternalForm().trim()).indexOf("!/")) >= 0 ? 4 : 0;
            if (n < 0) {
                throw new IOException("Not a valid jar url: " + string);
            }
            URL uRL = new URL(string.substring(n2, n));
            String string2 = n + 2 < string.length() ? string.substring(n + 2) : null;
            boolean bl2 = bl = string2 != null && string2.endsWith("/");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Extracting entry = " + string2 + " from jar " + uRL, new Object[0]);
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            try (InputStream inputStream = uRLConnection.getInputStream();
                 JarInputStream jarInputStream = new JarInputStream(inputStream);){
                Object object;
                Object object2;
                File file2;
                Object object3;
                Object object4;
                JarEntry jarEntry;
                while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                    boolean bl3;
                    object4 = jarEntry.getName();
                    if (string2 != null && ((String)object4).startsWith(string2)) {
                        if (!bl && string2.length() + 1 == ((String)object4).length() && ((String)object4).endsWith("/")) {
                            bl = true;
                        }
                        bl3 = bl ? !((String)(object4 = ((String)object4).substring(string2.length()))).equals("") : true;
                    } else {
                        bl3 = string2 == null || ((String)object4).startsWith(string2);
                    }
                    if (!bl3) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Skipping entry: " + (String)object4, new Object[0]);
                        continue;
                    }
                    object3 = ((String)object4).replace('\\', '/');
                    if ((object3 = URIUtil.canonicalPath((String)object3)) == null) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Invalid entry: " + (String)object4, new Object[0]);
                        continue;
                    }
                    file2 = new File(file, (String)object4);
                    if (jarEntry.isDirectory()) {
                        if (file2.exists()) continue;
                        file2.mkdirs();
                        continue;
                    }
                    object2 = new File(file2.getParent());
                    if (!((File)object2).exists()) {
                        ((File)object2).mkdirs();
                    }
                    object = new FileOutputStream(file2);
                    Throwable throwable = null;
                    try {
                        IO.copy(jarInputStream, (OutputStream)object);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((OutputStream)object).close();
                            }
                        }
                    }
                    if (jarEntry.getTime() < 0L) continue;
                    file2.setLastModified(jarEntry.getTime());
                }
                if (string2 != null && (string2 == null || !string2.equalsIgnoreCase("META-INF/MANIFEST.MF")) || (object4 = jarInputStream.getManifest()) == null) break block61;
                object3 = new File(file, "META-INF");
                ((File)object3).mkdir();
                file2 = new File((File)object3, "MANIFEST.MF");
                object2 = new FileOutputStream(file2);
                object = null;
                try {
                    ((Manifest)object4).write((OutputStream)object2);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStream)object2).close();
                        }
                    }
                }
            }
        }
    }

    public static Resource newJarResource(Resource resource) {
        if (resource instanceof JarResource) {
            return resource;
        }
        return Resource.newResource("jar:" + resource + "!/");
    }
}

