/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;

class JarFileResource
extends JarResource {
    private static final Logger LOG = Log.getLogger(JarFileResource.class);
    private JarFile _jarFile;
    private File _file;
    private String[] _list;
    private JarEntry _entry;
    private boolean _directory;
    private String _jarUrl;
    private String _path;
    private boolean _exists;

    protected JarFileResource(URL uRL) {
        super(uRL);
    }

    protected JarFileResource(URL uRL, boolean bl) {
        super(uRL, bl);
    }

    @Override
    public synchronized void close() {
        this._exists = false;
        this._list = null;
        this._entry = null;
        this._file = null;
        if (!this.getUseCaches() && this._jarFile != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Closing JarFile " + this._jarFile.getName(), new Object[0]);
                }
                this._jarFile.close();
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
        this._jarFile = null;
        super.close();
    }

    @Override
    protected synchronized boolean checkConnection() {
        try {
            super.checkConnection();
        }
        finally {
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
        }
        return this._jarFile != null;
    }

    @Override
    protected synchronized void newConnection() {
        super.newConnection();
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        this._list = null;
        int n = this._urlString.indexOf("!/");
        this._jarUrl = this._urlString.substring(0, n + 2);
        this._path = this._urlString.substring(n + 2);
        if (this._path.length() == 0) {
            this._path = null;
        }
        this._jarFile = this._jarConnection.getJarFile();
        this._file = new File(this._jarFile.getName());
    }

    @Override
    public boolean exists() {
        Object object;
        if (this._exists) {
            return true;
        }
        if (this._urlString.endsWith("!/")) {
            String string = this._urlString.substring(4, this._urlString.length() - 2);
            try {
                return JarFileResource.newResource(string).exists();
            }
            catch (Exception exception) {
                LOG.ignore(exception);
                return false;
            }
        }
        boolean bl = this.checkConnection();
        if (this._jarUrl != null && this._path == null) {
            this._directory = bl;
            return true;
        }
        boolean bl2 = false;
        JarFile jarFile = null;
        if (bl) {
            jarFile = this._jarFile;
        } else {
            try {
                object = (JarURLConnection)new URL(this._jarUrl).openConnection();
                ((URLConnection)object).setUseCaches(this.getUseCaches());
                jarFile = ((JarURLConnection)object).getJarFile();
                bl2 = !this.getUseCaches();
            }
            catch (Exception exception) {
                LOG.ignore(exception);
            }
        }
        if (jarFile != null && this._entry == null && !this._directory) {
            object = jarFile.getJarEntry(this._path);
            if (object == null) {
                this._exists = false;
            } else if (((ZipEntry)object).isDirectory()) {
                this._directory = true;
                this._entry = object;
            } else {
                JarEntry jarEntry = jarFile.getJarEntry(this._path + '/');
                if (jarEntry != null) {
                    this._directory = true;
                    this._entry = jarEntry;
                } else {
                    this._directory = false;
                    this._entry = object;
                }
            }
        }
        if (bl2 && jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                LOG.ignore(iOException);
            }
        }
        this._exists = this._directory || this._entry != null;
        return this._exists;
    }

    @Override
    public boolean isDirectory() {
        return this._urlString.endsWith("/") || this.exists() && this._directory;
    }

    @Override
    public long lastModified() {
        if (this.checkConnection() && this._file != null) {
            if (this.exists() && this._entry != null) {
                return this._entry.getTime();
            }
            return this._file.lastModified();
        }
        return -1L;
    }

    @Override
    public synchronized String[] list() {
        if (this.isDirectory() && this._list == null) {
            List<String> list = null;
            try {
                list = this.listEntries();
            }
            catch (Exception exception) {
                LOG.warn("Retrying list:" + exception, new Object[0]);
                LOG.debug(exception);
                this.close();
                list = this.listEntries();
            }
            if (list != null) {
                this._list = new String[list.size()];
                list.toArray(this._list);
            }
        }
        return this._list;
    }

    private List<String> listEntries() {
        Object object;
        this.checkConnection();
        ArrayList<String> arrayList = new ArrayList<String>(32);
        JarFile jarFile = this._jarFile;
        if (jarFile == null) {
            try {
                object = (JarURLConnection)new URL(this._jarUrl).openConnection();
                ((URLConnection)object).setUseCaches(this.getUseCaches());
                jarFile = ((JarURLConnection)object).getJarFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                LOG.ignore(exception);
            }
            if (jarFile == null) {
                throw new IllegalStateException();
            }
        }
        object = jarFile.entries();
        String string = this._urlString.substring(this._urlString.indexOf("!/") + 2);
        while (object.hasMoreElements()) {
            String string2;
            int n;
            JarEntry jarEntry = (JarEntry)object.nextElement();
            String string3 = jarEntry.getName().replace('\\', '/');
            if (!string3.startsWith(string) || string3.length() == string.length() || (n = (string2 = string3.substring(string.length())).indexOf(47)) >= 0 && (n == 0 && string2.length() == 1 || arrayList.contains(string2 = n == 0 ? string2.substring(n + 1, string2.length()) : string2.substring(0, n + 1)))) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public long length() {
        if (this.isDirectory()) {
            return -1L;
        }
        if (this._entry != null) {
            return this._entry.getSize();
        }
        return -1L;
    }

    public static Resource getNonCachingResource(Resource resource) {
        if (!(resource instanceof JarFileResource)) {
            return resource;
        }
        JarFileResource jarFileResource = (JarFileResource)resource;
        JarFileResource jarFileResource2 = new JarFileResource(jarFileResource.getURL(), false);
        return jarFileResource2;
    }

    @Override
    public boolean isContainedIn(Resource resource) {
        String string = this._urlString;
        int n = string.indexOf("!/");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (string.startsWith("jar:")) {
            string = string.substring(4);
        }
        URL uRL = new URL(string);
        return uRL.sameFile(resource.getURL());
    }
}

