/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.security.Permission;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

@Deprecated
public class FileResource
extends Resource {
    private static final Logger LOG = Log.getLogger(FileResource.class);
    private final File _file;
    private final String _uri;
    private final URI _alias;

    public FileResource(URL uRL) {
        File file;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw uRISyntaxException;
        }
        catch (Exception exception) {
            if (!uRL.toString().startsWith("file:")) {
                throw new IllegalArgumentException("!file:");
            }
            LOG.ignore(exception);
            try {
                String string = "file:" + URIUtil.encodePath(uRL.toString().substring(5));
                URI uRI = new URI(string);
                file = uRI.getAuthority() == null ? new File(uRI) : new File("//" + uRI.getAuthority() + URIUtil.decodePath(uRL.getFile()));
            }
            catch (Exception exception2) {
                LOG.ignore(exception2);
                URLConnection uRLConnection = uRL.openConnection();
                Permission permission = uRLConnection.getPermission();
                file = new File(permission == null ? uRL.getFile() : permission.getName());
            }
        }
        this._file = file;
        this._uri = FileResource.normalizeURI(this._file, uRL.toURI());
        this._alias = FileResource.checkFileAlias(this._file);
    }

    public FileResource(URI uRI) {
        File file;
        this._file = file = new File(uRI);
        URI uRI2 = this._file.toURI();
        this._uri = FileResource.normalizeURI(this._file, uRI);
        this._alias = !URIUtil.equalsIgnoreEncodings(this._uri, uRI2.toString()) ? this._file.toURI() : FileResource.checkFileAlias(this._file);
    }

    public FileResource(File file) {
        this._file = file;
        this._uri = FileResource.normalizeURI(this._file, this._file.toURI());
        this._alias = FileResource.checkFileAlias(this._file);
    }

    private static String normalizeURI(File file, URI uRI) {
        String string = uRI.toASCIIString();
        if (file.isDirectory()) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        } else if (file.exists() && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static URI checkFileAlias(File file) {
        try {
            String string = file.getAbsolutePath();
            String string2 = file.getCanonicalPath();
            if (!string.equals(string2)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ALIAS abs={} can={}", string, string2);
                }
                URI uRI = new File(string2).toURI();
                String string3 = "file://" + URIUtil.encodePath(uRI.getPath());
                return new URI(string3);
            }
        }
        catch (Exception exception) {
            LOG.warn("bad alias for {}: {}", file, exception.toString());
            LOG.debug(exception);
            try {
                return new URI("http://eclipse.org/bad/canonical/alias");
            }
            catch (Exception exception2) {
                LOG.ignore(exception2);
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    @Override
    public Resource addPath(String string) {
        URI uRI;
        if ((string = URIUtil.canonicalPath(string)) == null) {
            throw new MalformedURLException();
        }
        if ("/".equals(string)) {
            return this;
        }
        string = URIUtil.encodePath(string);
        try {
            uRI = this._file.isDirectory() ? new URI(URIUtil.addPaths(this._uri, string)) : new URI(this._uri + string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MalformedURLException(uRISyntaxException.getMessage()){
                {
                    super(string);
                    this.initCause(uRISyntaxException);
                }
            };
        }
        return new FileResource(uRI);
    }

    @Override
    public URI getAlias() {
        return this._alias;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public long lastModified() {
        return this._file.lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this._file.exists() && this._file.isDirectory() || this._uri.endsWith("/");
    }

    @Override
    public long length() {
        return this._file.length();
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public InputStream getInputStream() {
        return new FileInputStream(this._file);
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() {
        return FileChannel.open(this._file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public boolean delete() {
        return this._file.delete();
    }

    @Override
    public boolean renameTo(Resource resource) {
        if (resource instanceof FileResource) {
            return this._file.renameTo(((FileResource)resource)._file);
        }
        return false;
    }

    @Override
    public String[] list() {
        String[] stringArray = this._file.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        while (n-- > 0) {
            if (!new File(this._file, stringArray[n]).isDirectory() || stringArray[n].endsWith("/")) continue;
            int n2 = n;
            stringArray[n2] = stringArray[n2] + "/";
        }
        return stringArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !(object instanceof FileResource)) {
            return false;
        }
        FileResource fileResource = (FileResource)object;
        return fileResource._file == this._file || null != this._file && this._file.equals(fileResource._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    @Override
    public void copyTo(File file) {
        if (this.isDirectory()) {
            IO.copyDir(this.getFile(), file);
        } else {
            if (file.exists()) {
                throw new IllegalArgumentException(file + " exists");
            }
            IO.copy(this.getFile(), file);
        }
    }

    @Override
    public boolean isContainedIn(Resource resource) {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this._uri);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    @Override
    public URI getURI() {
        return this._file.toURI();
    }

    public String toString() {
        return this._uri;
    }
}

