/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.PrintStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Jetty StdErr Logging Implementation")
public class StdErrLog
extends AbstractLogger {
    private static final String EOL;
    private static int __tagpad;
    private static DateCache _dateCache;
    private static final boolean __source;
    private static final boolean __long;
    private static final boolean __escape;
    private int _level = 2;
    private int _configuredLevel;
    private PrintStream _stderr = null;
    private boolean _source = __source;
    private boolean _printLongNames = __long;
    private final String _name;
    private final String _abbrevname;
    private boolean _hideStacks = false;

    public static void setTagPad(int n) {
        __tagpad = n;
    }

    public static int getLoggingLevel(Properties properties, String string) {
        int n = StdErrLog.lookupLoggingLevel(properties, string);
        if (n == -1 && (n = StdErrLog.lookupLoggingLevel(properties, "log")) == -1) {
            n = 2;
        }
        return n;
    }

    public static StdErrLog getLogger(Class<?> clazz) {
        Logger logger = Log.getLogger(clazz);
        if (logger instanceof StdErrLog) {
            return (StdErrLog)logger;
        }
        throw new RuntimeException("Logger for " + clazz + " is not of type StdErrLog");
    }

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String string) {
        this(string, null);
    }

    public StdErrLog(String string, Properties properties) {
        String string2;
        if (properties != null && properties != Log.__props) {
            Log.__props.putAll((Map<?, ?>)properties);
        }
        this._name = string == null ? "" : string;
        this._abbrevname = StdErrLog.condensePackageString(this._name);
        this._configuredLevel = this._level = StdErrLog.getLoggingLevel(Log.__props, this._name);
        try {
            string2 = StdErrLog.getLoggingProperty(Log.__props, this._name, "SOURCE");
            this._source = string2 == null ? __source : Boolean.parseBoolean(string2);
        }
        catch (AccessControlException accessControlException) {
            this._source = __source;
        }
        try {
            string2 = StdErrLog.getLoggingProperty(Log.__props, this._name, "STACKS");
            this._hideStacks = string2 == null ? false : !Boolean.parseBoolean(string2);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setPrintLongNames(boolean bl) {
        this._printLongNames = bl;
    }

    public boolean isPrintLongNames() {
        return this._printLongNames;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    public void setHideStacks(boolean bl) {
        this._hideStacks = bl;
    }

    public boolean isSource() {
        return this._source;
    }

    public void setSource(boolean bl) {
        this._source = bl;
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        if (this._level <= 3) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":WARN:", string, objectArray);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    @Override
    public void warn(Throwable throwable) {
        this.warn("", throwable);
    }

    @Override
    public void warn(String string, Throwable throwable) {
        if (this._level <= 3) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":WARN:", string, throwable);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this._level <= 2) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":INFO:", string, objectArray);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    @Override
    public void info(Throwable throwable) {
        this.info("", throwable);
    }

    @Override
    public void info(String string, Throwable throwable) {
        if (this._level <= 2) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":INFO:", string, throwable);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    @Override
    @ManagedAttribute(value="is debug enabled for root logger Log.LOG")
    public boolean isDebugEnabled() {
        return this._level <= 1;
    }

    @Override
    public void setDebugEnabled(boolean bl) {
        if (bl) {
            this._level = 1;
            for (Logger logger : Log.getLoggers().values()) {
                if (!logger.getName().startsWith(this.getName()) || !(logger instanceof StdErrLog)) continue;
                ((StdErrLog)logger).setLevel(1);
            }
        } else {
            this._level = this._configuredLevel;
            for (Logger logger : Log.getLoggers().values()) {
                if (!logger.getName().startsWith(this.getName()) || !(logger instanceof StdErrLog)) continue;
                ((StdErrLog)logger).setLevel(((StdErrLog)logger)._configuredLevel);
            }
        }
    }

    public int getLevel() {
        return this._level;
    }

    public void setLevel(int n) {
        this._level = n;
    }

    public void setStdErrStream(PrintStream printStream) {
        this._stderr = printStream == System.err ? null : printStream;
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this._level <= 1) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":DBUG:", string, objectArray);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    @Override
    public void debug(String string, long l) {
        if (this.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":DBUG:", string, l);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        this.debug("", throwable);
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this._level <= 1) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":DBUG:", string, throwable);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    private void format(StringBuilder stringBuilder, String string, String string2, Object ... objectArray) {
        long l = System.currentTimeMillis();
        int n = (int)(l % 1000L);
        String string3 = _dateCache.formatNow(l);
        this.tag(stringBuilder, string3, n, string);
        this.format(stringBuilder, string2, objectArray);
    }

    private void format(StringBuilder stringBuilder, String string, String string2, Throwable throwable) {
        this.format(stringBuilder, string, string2, new Object[0]);
        if (this.isHideStacks()) {
            this.format(stringBuilder, ": " + String.valueOf(throwable), new Object[0]);
        } else {
            this.format(stringBuilder, throwable);
        }
    }

    private void tag(StringBuilder stringBuilder, String string, int n, String string2) {
        int n2;
        stringBuilder.setLength(0);
        stringBuilder.append(string);
        if (n > 99) {
            stringBuilder.append('.');
        } else if (n > 9) {
            stringBuilder.append(".0");
        } else {
            stringBuilder.append(".00");
        }
        stringBuilder.append(n).append(string2);
        String string3 = this._printLongNames ? this._name : this._abbrevname;
        String string4 = Thread.currentThread().getName();
        int n3 = n2 = __tagpad > 0 ? string3.length() + string4.length() - __tagpad : 0;
        if (n2 < 0) {
            stringBuilder.append(string3).append(':').append("                                                  ", 0, -n2).append(string4);
        } else if (n2 == 0) {
            stringBuilder.append(string3).append(':').append(string4);
        }
        stringBuilder.append(':');
        if (this._source) {
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                String string5 = stackTraceElement.getClassName();
                if (string5.equals(StdErrLog.class.getName()) || string5.equals(Log.class.getName())) continue;
                if (!this._printLongNames && string5.startsWith("org.eclipse.jetty.")) {
                    stringBuilder.append(StdErrLog.condensePackageString(string5));
                } else {
                    stringBuilder.append(string5);
                }
                stringBuilder.append('#').append(stackTraceElement.getMethodName());
                if (stackTraceElement.getFileName() != null) {
                    stringBuilder.append('(').append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber()).append(')');
                }
                stringBuilder.append(':');
                break;
            }
        }
        stringBuilder.append(' ');
    }

    private void format(StringBuilder stringBuilder, String string, Object ... objectArray) {
        if (string == null) {
            string = "";
            for (int i = 0; i < objectArray.length; ++i) {
                string = string + "{} ";
            }
        }
        String string2 = "{}";
        int n = 0;
        for (Object object : objectArray) {
            int n2 = string.indexOf(string2, n);
            if (n2 < 0) {
                this.escape(stringBuilder, string.substring(n));
                stringBuilder.append(" ");
                stringBuilder.append(object);
                n = string.length();
                continue;
            }
            this.escape(stringBuilder, string.substring(n, n2));
            stringBuilder.append(String.valueOf(object));
            n = n2 + string2.length();
        }
        this.escape(stringBuilder, string.substring(n));
    }

    private void escape(StringBuilder stringBuilder, String string) {
        if (__escape) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isISOControl(c)) {
                    if (c == '\n') {
                        stringBuilder.append('|');
                        continue;
                    }
                    if (c == '\r') {
                        stringBuilder.append('<');
                        continue;
                    }
                    stringBuilder.append('?');
                    continue;
                }
                stringBuilder.append(c);
            }
        } else {
            stringBuilder.append(string);
        }
    }

    protected void format(StringBuilder stringBuilder, Throwable throwable) {
        this.format(stringBuilder, throwable, "");
    }

    /*
     * WARNING - void declaration
     */
    protected void format(StringBuilder stringBuilder, Throwable throwable, String string) {
        if (throwable == null) {
            stringBuilder.append("null");
        } else {
            void object;
            stringBuilder.append(EOL).append(string);
            this.format(stringBuilder, throwable.toString(), new Object[0]);
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            boolean i = false;
            while (stackTraceElementArray != null && object < stackTraceElementArray.length) {
                stringBuilder.append(EOL).append(string).append("\tat ");
                this.format(stringBuilder, stackTraceElementArray[object].toString(), new Object[0]);
                ++object;
            }
            for (Throwable throwable2 : throwable.getSuppressed()) {
                stringBuilder.append(EOL).append(string).append("Suppressed: ");
                this.format(stringBuilder, throwable2, "\t|" + string);
            }
            Throwable throwable3 = throwable.getCause();
            if (throwable3 != null && throwable3 != throwable) {
                stringBuilder.append(EOL).append(string).append("Caused by: ");
                this.format(stringBuilder, throwable3, string);
            }
        }
    }

    @Override
    protected Logger newLogger(String string) {
        StdErrLog stdErrLog = new StdErrLog(string);
        stdErrLog.setPrintLongNames(this._printLongNames);
        stdErrLog._stderr = this._stderr;
        if (this._level != this._configuredLevel) {
            stdErrLog._level = this._level;
        }
        return stdErrLog;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StdErrLog:");
        stringBuilder.append(this._name);
        stringBuilder.append(":LEVEL=");
        switch (this._level) {
            case 0: {
                stringBuilder.append("ALL");
                break;
            }
            case 1: {
                stringBuilder.append("DEBUG");
                break;
            }
            case 2: {
                stringBuilder.append("INFO");
                break;
            }
            case 3: {
                stringBuilder.append("WARN");
                break;
            }
            default: {
                stringBuilder.append("?");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void ignore(Throwable throwable) {
        if (this._level <= 0) {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.format(stringBuilder, ":IGNORED:", "", throwable);
            (this._stderr == null ? System.err : this._stderr).println(stringBuilder);
        }
    }

    static {
        String[] stringArray;
        EOL = System.getProperty("line.separator");
        __tagpad = Integer.parseInt(Log.__props.getProperty("org.eclipse.jetty.util.log.StdErrLog.TAG_PAD", "0"));
        __source = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.SOURCE", Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.SOURCE", "false")));
        __long = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.LONG", "false"));
        __escape = Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.stderr.ESCAPE", "true"));
        for (String string : stringArray = new String[]{"DEBUG", "org.eclipse.jetty.util.log.DEBUG", "org.eclipse.jetty.util.log.stderr.DEBUG"}) {
            if (System.getProperty(string) == null) continue;
            System.err.printf("System Property [%s] has been deprecated! (Use org.eclipse.jetty.LEVEL=DEBUG instead)%n", string);
        }
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

