/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.lang.reflect.Method;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LoggerLog
extends AbstractLogger {
    private final Object _logger;
    private final Method _debugMT;
    private final Method _debugMAA;
    private final Method _infoMT;
    private final Method _infoMAA;
    private final Method _warnMT;
    private final Method _warnMAA;
    private final Method _setDebugEnabledE;
    private final Method _getLoggerN;
    private final Method _getName;
    private volatile boolean _debug;

    public LoggerLog(Object object) {
        try {
            this._logger = object;
            Class<?> clazz = object.getClass();
            this._debugMT = clazz.getMethod("debug", String.class, Throwable.class);
            this._debugMAA = clazz.getMethod("debug", String.class, Object[].class);
            this._infoMT = clazz.getMethod("info", String.class, Throwable.class);
            this._infoMAA = clazz.getMethod("info", String.class, Object[].class);
            this._warnMT = clazz.getMethod("warn", String.class, Throwable.class);
            this._warnMAA = clazz.getMethod("warn", String.class, Object[].class);
            Method method = clazz.getMethod("isDebugEnabled", new Class[0]);
            this._setDebugEnabledE = clazz.getMethod("setDebugEnabled", Boolean.TYPE);
            this._getLoggerN = clazz.getMethod("getLogger", String.class);
            this._getName = clazz.getMethod("getName", new Class[0]);
            this._debug = (Boolean)method.invoke(this._logger, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public String getName() {
        try {
            return (String)this._getName.invoke(this._logger, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        try {
            this._warnMAA.invoke(this._logger, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void warn(Throwable throwable) {
        this.warn("", throwable);
    }

    @Override
    public void warn(String string, Throwable throwable) {
        try {
            this._warnMT.invoke(this._logger, string, throwable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        try {
            this._infoMAA.invoke(this._logger, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void info(Throwable throwable) {
        this.info("", throwable);
    }

    @Override
    public void info(String string, Throwable throwable) {
        try {
            this._infoMT.invoke(this._logger, string, throwable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this._debug;
    }

    @Override
    public void setDebugEnabled(boolean bl) {
        try {
            this._setDebugEnabledE.invoke(this._logger, bl);
            this._debug = bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (!this._debug) {
            return;
        }
        try {
            this._debugMAA.invoke(this._logger, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void debug(Throwable throwable) {
        this.debug("", throwable);
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (!this._debug) {
            return;
        }
        try {
            this._debugMT.invoke(this._logger, string, throwable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void debug(String string, long l) {
        if (!this._debug) {
            return;
        }
        try {
            this._debugMAA.invoke(this._logger, new Long(l));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void ignore(Throwable throwable) {
        if (Log.isIgnored()) {
            this.warn("IGNORED ", throwable);
        }
    }

    @Override
    protected Logger newLogger(String string) {
        try {
            Object object = this._getLoggerN.invoke(this._logger, string);
            return new LoggerLog(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this;
        }
    }
}

