/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.Uptime;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.LoggerLog;
import org.eclipse.jetty.util.log.StdErrLog;

public class Log {
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED ";
    protected static final Properties __props;
    public static String __logClass;
    public static boolean __ignored;
    private static final ConcurrentMap<String, Logger> __loggers;
    private static Logger LOG;
    private static boolean __initialized;

    static void loadProperties(String string, Properties properties) {
        URL uRL = Loader.getResource(Log.class, string);
        if (uRL != null) {
            try (InputStream inputStream = uRL.openStream();){
                Properties properties2 = new Properties();
                properties2.load(inputStream);
                for (Object object : properties2.keySet()) {
                    Object object2 = properties2.get(object);
                    if (object2 == null) continue;
                    properties.put(object, object2);
                }
            }
            catch (IOException iOException) {
                System.err.println("[WARN] Error loading logging config: " + uRL);
                iOException.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialized() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            __initialized = true;
            try {
                Class clazz2;
                Class clazz3 = clazz2 = __logClass == null ? null : Loader.loadClass(Log.class, __logClass);
                if (LOG == null || clazz2 != null && !LOG.getClass().equals(clazz2)) {
                    LOG = (Logger)clazz2.newInstance();
                    LOG.debug("Logging to {} via {}", LOG, clazz2.getName());
                }
            }
            catch (Throwable throwable) {
                Log.initStandardLogging(throwable);
            }
            if (LOG != null) {
                LOG.info(String.format("Logging initialized @%dms", Uptime.getUptime()), new Object[0]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void initStandardLogging(Throwable throwable) {
        if (throwable != null && __ignored) {
            throwable.printStackTrace(System.err);
        }
        if (LOG == null) {
            Class<StdErrLog> clazz = StdErrLog.class;
            LOG = new StdErrLog();
            LOG.debug("Logging to {} via {}", LOG, clazz.getName());
        }
    }

    public static Logger getLog() {
        Log.initialized();
        return LOG;
    }

    public static void setLog(Logger logger) {
        LOG = logger;
        __logClass = null;
    }

    public static Logger getRootLogger() {
        Log.initialized();
        return LOG;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static void setLogToParent(String string) {
        ClassLoader classLoader = Log.class.getClassLoader();
        if (classLoader != null && classLoader.getParent() != null) {
            try {
                Class<?> clazz = classLoader.getParent().loadClass("org.eclipse.jetty.util.log.Log");
                Method method = clazz.getMethod("getLogger", String.class);
                Object object = method.invoke(null, string);
                Log.setLog(new LoggerLog(object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Log.setLog(Log.getLogger(string));
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    public static Logger getLogger(String string) {
        Log.initialized();
        if (string == null) {
            return LOG;
        }
        Logger logger = (Logger)__loggers.get(string);
        if (logger == null) {
            logger = LOG.getLogger(string);
        }
        return logger;
    }

    static ConcurrentMap<String, Logger> getMutableLoggers() {
        return __loggers;
    }

    @ManagedAttribute(value="list of all instantiated loggers")
    public static Map<String, Logger> getLoggers() {
        return Collections.unmodifiableMap(__loggers);
    }

    static {
        __loggers = new ConcurrentHashMap<String, Logger>();
        __props = new Properties();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log.loadProperties("jetty-logging.properties", __props);
                String string = System.getProperty("os.name");
                if (string != null && string.length() > 0) {
                    string = string.toLowerCase(Locale.ENGLISH).replace(' ', '-');
                    Log.loadProperties("jetty-logging-" + string + ".properties", __props);
                }
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = System.getProperty(string2);
                    if (string3 == null) continue;
                    __props.setProperty(string2, string3);
                }
                __logClass = __props.getProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(__props.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
        __initialized = false;
    }
}

