/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JettyLogHandler
extends Handler {
    public static void config() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource("logging.properties");
        if (uRL != null) {
            System.err.printf("Initializing java.util.logging from %s%n", uRL);
            try (InputStream inputStream = uRL.openStream();){
                LogManager.getLogManager().readConfiguration(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        } else {
            System.err.printf("WARNING: java.util.logging failed to initialize: logging.properties not found%n", new Object[0]);
        }
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    public JettyLogHandler() {
        if (Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.DEBUG", "false"))) {
            this.setLevel(Level.FINEST);
        }
        if (Boolean.parseBoolean(Log.__props.getProperty("org.eclipse.jetty.util.log.IGNORED", "false"))) {
            this.setLevel(Level.ALL);
        }
        System.err.printf("%s Initialized at level [%s]%n", this.getClass().getName(), this.getLevel().getName());
    }

    private synchronized String formatMessage(LogRecord logRecord) {
        String string = this.getMessage(logRecord);
        try {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null || objectArray.length == 0) {
                return string;
            }
            if (Pattern.compile("\\{\\d+\\}").matcher(string).find()) {
                return MessageFormat.format(string, objectArray);
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private String getMessage(LogRecord logRecord) {
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(logRecord.getMessage());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return logRecord.getMessage();
    }

    @Override
    public void publish(LogRecord logRecord) {
        Logger logger = this.getJettyLogger(logRecord.getLoggerName());
        int n = logRecord.getLevel().intValue();
        if (n >= Level.OFF.intValue()) {
            return;
        }
        Throwable throwable = logRecord.getThrown();
        String string = this.formatMessage(logRecord);
        if (n >= Level.WARNING.intValue()) {
            if (throwable != null) {
                logger.warn(string, throwable);
            } else {
                logger.warn(string, new Object[0]);
            }
            return;
        }
        if (n >= Level.INFO.intValue()) {
            if (throwable != null) {
                logger.info(string, throwable);
            } else {
                logger.info(string, new Object[0]);
            }
            return;
        }
        if (n >= Level.FINEST.intValue()) {
            if (throwable != null) {
                logger.debug(string, throwable);
            } else {
                logger.debug(string, new Object[0]);
            }
            return;
        }
        if (n >= Level.ALL.intValue()) {
            logger.ignore(throwable);
            return;
        }
    }

    private Logger getJettyLogger(String string) {
        return Log.getLogger(string);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

