/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import org.eclipse.jetty.util.log.Slf4jLog;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

class JettyAwareLogger
implements Logger {
    private static final int DEBUG = 10;
    private static final int ERROR = 40;
    private static final int INFO = 20;
    private static final int TRACE = 0;
    private static final int WARN = 30;
    private static final String FQCN = Slf4jLog.class.getName();
    private final LocationAwareLogger _logger;

    public JettyAwareLogger(LocationAwareLogger locationAwareLogger) {
        this._logger = locationAwareLogger;
    }

    public String getName() {
        return this._logger.getName();
    }

    public boolean isTraceEnabled() {
        return this._logger.isTraceEnabled();
    }

    public void trace(String string) {
        this.log(null, 0, string, null, null);
    }

    public void trace(String string, Object object) {
        this.log(null, 0, string, new Object[]{object}, null);
    }

    public void trace(String string, Object object, Object object2) {
        this.log(null, 0, string, new Object[]{object, object2}, null);
    }

    public void trace(String string, Object[] objectArray) {
        this.log(null, 0, string, objectArray, null);
    }

    public void trace(String string, Throwable throwable) {
        this.log(null, 0, string, null, throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this._logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String string) {
        this.log(marker, 0, string, null, null);
    }

    public void trace(Marker marker, String string, Object object) {
        this.log(marker, 0, string, new Object[]{object}, null);
    }

    public void trace(Marker marker, String string, Object object, Object object2) {
        this.log(marker, 0, string, new Object[]{object, object2}, null);
    }

    public void trace(Marker marker, String string, Object[] objectArray) {
        this.log(marker, 0, string, objectArray, null);
    }

    public void trace(Marker marker, String string, Throwable throwable) {
        this.log(marker, 0, string, null, throwable);
    }

    public boolean isDebugEnabled() {
        return this._logger.isDebugEnabled();
    }

    public void debug(String string) {
        this.log(null, 10, string, null, null);
    }

    public void debug(String string, Object object) {
        this.log(null, 10, string, new Object[]{object}, null);
    }

    public void debug(String string, Object object, Object object2) {
        this.log(null, 10, string, new Object[]{object, object2}, null);
    }

    public void debug(String string, Object[] objectArray) {
        this.log(null, 10, string, objectArray, null);
    }

    public void debug(String string, Throwable throwable) {
        this.log(null, 10, string, null, throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this._logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String string) {
        this.log(marker, 10, string, null, null);
    }

    public void debug(Marker marker, String string, Object object) {
        this.log(marker, 10, string, new Object[]{object}, null);
    }

    public void debug(Marker marker, String string, Object object, Object object2) {
        this.log(marker, 10, string, new Object[]{object, object2}, null);
    }

    public void debug(Marker marker, String string, Object[] objectArray) {
        this.log(marker, 10, string, objectArray, null);
    }

    public void debug(Marker marker, String string, Throwable throwable) {
        this.log(marker, 10, string, null, throwable);
    }

    public boolean isInfoEnabled() {
        return this._logger.isInfoEnabled();
    }

    public void info(String string) {
        this.log(null, 20, string, null, null);
    }

    public void info(String string, Object object) {
        this.log(null, 20, string, new Object[]{object}, null);
    }

    public void info(String string, Object object, Object object2) {
        this.log(null, 20, string, new Object[]{object, object2}, null);
    }

    public void info(String string, Object[] objectArray) {
        this.log(null, 20, string, objectArray, null);
    }

    public void info(String string, Throwable throwable) {
        this.log(null, 20, string, null, throwable);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this._logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String string) {
        this.log(marker, 20, string, null, null);
    }

    public void info(Marker marker, String string, Object object) {
        this.log(marker, 20, string, new Object[]{object}, null);
    }

    public void info(Marker marker, String string, Object object, Object object2) {
        this.log(marker, 20, string, new Object[]{object, object2}, null);
    }

    public void info(Marker marker, String string, Object[] objectArray) {
        this.log(marker, 20, string, objectArray, null);
    }

    public void info(Marker marker, String string, Throwable throwable) {
        this.log(marker, 20, string, null, throwable);
    }

    public boolean isWarnEnabled() {
        return this._logger.isWarnEnabled();
    }

    public void warn(String string) {
        this.log(null, 30, string, null, null);
    }

    public void warn(String string, Object object) {
        this.log(null, 30, string, new Object[]{object}, null);
    }

    public void warn(String string, Object[] objectArray) {
        this.log(null, 30, string, objectArray, null);
    }

    public void warn(String string, Object object, Object object2) {
        this.log(null, 30, string, new Object[]{object, object2}, null);
    }

    public void warn(String string, Throwable throwable) {
        this.log(null, 30, string, null, throwable);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this._logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String string) {
        this.log(marker, 30, string, null, null);
    }

    public void warn(Marker marker, String string, Object object) {
        this.log(marker, 30, string, new Object[]{object}, null);
    }

    public void warn(Marker marker, String string, Object object, Object object2) {
        this.log(marker, 30, string, new Object[]{object, object2}, null);
    }

    public void warn(Marker marker, String string, Object[] objectArray) {
        this.log(marker, 30, string, objectArray, null);
    }

    public void warn(Marker marker, String string, Throwable throwable) {
        this.log(marker, 30, string, null, throwable);
    }

    public boolean isErrorEnabled() {
        return this._logger.isErrorEnabled();
    }

    public void error(String string) {
        this.log(null, 40, string, null, null);
    }

    public void error(String string, Object object) {
        this.log(null, 40, string, new Object[]{object}, null);
    }

    public void error(String string, Object object, Object object2) {
        this.log(null, 40, string, new Object[]{object, object2}, null);
    }

    public void error(String string, Object[] objectArray) {
        this.log(null, 40, string, objectArray, null);
    }

    public void error(String string, Throwable throwable) {
        this.log(null, 40, string, null, throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this._logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String string) {
        this.log(marker, 40, string, null, null);
    }

    public void error(Marker marker, String string, Object object) {
        this.log(marker, 40, string, new Object[]{object}, null);
    }

    public void error(Marker marker, String string, Object object, Object object2) {
        this.log(marker, 40, string, new Object[]{object, object2}, null);
    }

    public void error(Marker marker, String string, Object[] objectArray) {
        this.log(marker, 40, string, objectArray, null);
    }

    public void error(Marker marker, String string, Throwable throwable) {
        this.log(marker, 40, string, null, throwable);
    }

    public String toString() {
        return this._logger.toString();
    }

    private void log(Marker marker, int n, String string, Object[] objectArray, Throwable throwable) {
        if (objectArray == null) {
            this._logger.log(marker, FQCN, n, string, null, throwable);
        } else {
            int n2;
            int n3 = this._logger.isTraceEnabled() ? 0 : (this._logger.isDebugEnabled() ? 10 : (this._logger.isInfoEnabled() ? 20 : (n2 = this._logger.isWarnEnabled() ? 30 : 40)));
            if (n2 <= n) {
                FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)string, (Object[])objectArray);
                this._logger.log(marker, FQCN, n, formattingTuple.getMessage(), null, throwable);
            }
        }
    }
}

