/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.FileWriter;
import java.io.Writer;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FileNoticeLifeCycleListener
implements LifeCycle.Listener {
    private static final Logger LOG = Log.getLogger(FileNoticeLifeCycleListener.class);
    private final String _filename;

    public FileNoticeLifeCycleListener(String string) {
        this._filename = string;
    }

    private void writeState(String string, LifeCycle lifeCycle) {
        try (FileWriter fileWriter = new FileWriter(this._filename, true);){
            ((Writer)fileWriter).append(string).append(" ").append(lifeCycle.toString()).append("\n");
        }
        catch (Exception exception) {
            LOG.warn(exception);
        }
    }

    @Override
    public void lifeCycleStarting(LifeCycle lifeCycle) {
        this.writeState("STARTING", lifeCycle);
    }

    @Override
    public void lifeCycleStarted(LifeCycle lifeCycle) {
        this.writeState("STARTED", lifeCycle);
    }

    @Override
    public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
        this.writeState("FAILED", lifeCycle);
    }

    @Override
    public void lifeCycleStopping(LifeCycle lifeCycle) {
        this.writeState("STOPPING", lifeCycle);
    }

    @Override
    public void lifeCycleStopped(LifeCycle lifeCycle) {
        this.writeState("STOPPED", lifeCycle);
    }
}

