/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class FileDestroyable
implements Destroyable {
    private static final Logger LOG = Log.getLogger(FileDestroyable.class);
    final List<File> _files = new ArrayList<File>();

    public FileDestroyable() {
    }

    public FileDestroyable(String string) {
        this._files.add(Resource.newResource(string).getFile());
    }

    public FileDestroyable(File file) {
        this._files.add(file);
    }

    public void addFile(String string) {
        try (Resource resource = Resource.newResource(string);){
            this._files.add(resource.getFile());
        }
    }

    public void addFile(File file) {
        this._files.add(file);
    }

    public void addFiles(Collection<File> collection) {
        this._files.addAll(collection);
    }

    public void removeFile(String string) {
        try (Resource resource = Resource.newResource(string);){
            this._files.remove(resource.getFile());
        }
    }

    public void removeFile(File file) {
        this._files.remove(file);
    }

    @Override
    public void destroy() {
        for (File file : this._files) {
            if (!file.exists()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroy {}", file);
            }
            IO.delete(file);
        }
    }
}

