/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Implementation of Container and LifeCycle")
public class ContainerLifeCycle
extends AbstractLifeCycle
implements Container,
Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(ContainerLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private final List<Container.Listener> _listeners = new CopyOnWriteArrayList<Container.Listener>();
    private boolean _doStarted = false;

    @Override
    protected void doStart() {
        this._doStarted = true;
        for (Bean bean : this._beans) {
            if (!(bean._bean instanceof LifeCycle)) continue;
            LifeCycle lifeCycle = (LifeCycle)bean._bean;
            switch (bean._managed) {
                case MANAGED: {
                    if (lifeCycle.isRunning()) break;
                    this.start(lifeCycle);
                    break;
                }
                case AUTO: {
                    if (lifeCycle.isRunning()) {
                        this.unmanage(bean);
                        break;
                    }
                    this.manage(bean);
                    this.start(lifeCycle);
                }
            }
        }
        super.doStart();
    }

    protected void start(LifeCycle lifeCycle) {
        lifeCycle.start();
    }

    protected void stop(LifeCycle lifeCycle) {
        lifeCycle.stop();
    }

    @Override
    protected void doStop() {
        this._doStarted = false;
        super.doStop();
        ArrayList<Bean> arrayList = new ArrayList<Bean>(this._beans);
        Collections.reverse(arrayList);
        for (Bean bean : arrayList) {
            if (bean._managed != Managed.MANAGED || !(bean._bean instanceof LifeCycle)) continue;
            LifeCycle lifeCycle = (LifeCycle)bean._bean;
            this.stop(lifeCycle);
        }
    }

    @Override
    public void destroy() {
        ArrayList<Bean> arrayList = new ArrayList<Bean>(this._beans);
        Collections.reverse(arrayList);
        for (Bean bean : arrayList) {
            if (!(bean._bean instanceof Destroyable) || bean._managed != Managed.MANAGED && bean._managed != Managed.POJO) continue;
            Destroyable destroyable = (Destroyable)bean._bean;
            destroyable.destroy();
        }
        this._beans.clear();
    }

    public boolean contains(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return true;
        }
        return false;
    }

    public boolean isManaged(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return bean.isManaged();
        }
        return false;
    }

    @Override
    public boolean addBean(Object object) {
        if (object instanceof LifeCycle) {
            LifeCycle lifeCycle = (LifeCycle)object;
            return this.addBean(object, lifeCycle.isRunning() ? Managed.UNMANAGED : Managed.AUTO);
        }
        return this.addBean(object, Managed.POJO);
    }

    public boolean addBean(Object object, boolean bl) {
        if (object instanceof LifeCycle) {
            return this.addBean(object, bl ? Managed.MANAGED : Managed.UNMANAGED);
        }
        return this.addBean(object, bl ? Managed.POJO : Managed.UNMANAGED);
    }

    public boolean addBean(Object object, Managed managed) {
        if (this.contains(object)) {
            return false;
        }
        Bean bean = new Bean(object);
        if (object instanceof Container.Listener) {
            this.addEventListener((Container.Listener)object);
        }
        this._beans.add(bean);
        for (Container.Listener listener : this._listeners) {
            listener.beanAdded(this, object);
        }
        try {
            switch (managed) {
                case UNMANAGED: {
                    this.unmanage(bean);
                    break;
                }
                case MANAGED: {
                    this.manage(bean);
                    if (!this.isStarting() || !this._doStarted) break;
                    Object object2 = (LifeCycle)object;
                    if (!object2.isRunning()) {
                        this.start((LifeCycle)object2);
                    }
                    break;
                }
                case AUTO: {
                    Object object2;
                    if (object instanceof LifeCycle) {
                        object2 = (LifeCycle)object;
                        if (this.isStarting()) {
                            if (object2.isRunning()) {
                                this.unmanage(bean);
                                break;
                            }
                            if (this._doStarted) {
                                this.manage(bean);
                                this.start((LifeCycle)object2);
                                break;
                            }
                            bean._managed = Managed.AUTO;
                            break;
                        }
                        if (this.isStarted()) {
                            this.unmanage(bean);
                            break;
                        }
                        bean._managed = Managed.AUTO;
                        break;
                    }
                    bean._managed = Managed.POJO;
                    break;
                }
                case POJO: {
                    bean._managed = Managed.POJO;
                }
            }
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added {}", this, bean);
        }
        return true;
    }

    public void addManaged(LifeCycle lifeCycle) {
        this.addBean((Object)lifeCycle, true);
        try {
            if (this.isRunning() && !lifeCycle.isRunning()) {
                this.start(lifeCycle);
            }
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void addEventListener(Container.Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
        for (Bean bean : this._beans) {
            listener.beanAdded(this, bean._bean);
            if (!(listener instanceof Container.InheritedListener) || !bean.isManaged() || !(bean._bean instanceof Container)) continue;
            if (bean._bean instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)bean._bean).addBean((Object)listener, false);
                continue;
            }
            ((Container)bean._bean).addBean(listener);
        }
    }

    public void manage(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            this.manage(bean);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + object);
    }

    private void manage(Bean bean) {
        if (bean._managed != Managed.MANAGED) {
            bean._managed = Managed.MANAGED;
            if (bean._bean instanceof Container) {
                for (Container.Listener listener : this._listeners) {
                    if (!(listener instanceof Container.InheritedListener)) continue;
                    if (bean._bean instanceof ContainerLifeCycle) {
                        ((ContainerLifeCycle)bean._bean).addBean((Object)listener, false);
                        continue;
                    }
                    ((Container)bean._bean).addBean(listener);
                }
            }
            if (bean._bean instanceof AbstractLifeCycle) {
                ((AbstractLifeCycle)bean._bean).setStopTimeout(this.getStopTimeout());
            }
        }
    }

    public void unmanage(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            this.unmanage(bean);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + object);
    }

    private void unmanage(Bean bean) {
        if (bean._managed != Managed.UNMANAGED) {
            if (bean._managed == Managed.MANAGED && bean._bean instanceof Container) {
                for (Container.Listener listener : this._listeners) {
                    if (!(listener instanceof Container.InheritedListener)) continue;
                    ((Container)bean._bean).removeBean(listener);
                }
            }
            bean._managed = Managed.UNMANAGED;
        }
    }

    @Override
    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public void setBeans(Collection<Object> collection) {
        for (Object object : collection) {
            this.addBean(object);
        }
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Bean bean : this._beans) {
            if (!clazz.isInstance(bean._bean)) continue;
            arrayList.add(clazz.cast(bean._bean));
        }
        return arrayList;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        for (Bean bean : this._beans) {
            if (!clazz.isInstance(bean._bean)) continue;
            return clazz.cast(bean._bean);
        }
        return null;
    }

    public void removeBeans() {
        ArrayList<Bean> arrayList = new ArrayList<Bean>(this._beans);
        for (Bean bean : arrayList) {
            this.remove(bean);
        }
    }

    private Bean getBean(Object object) {
        for (Bean bean : this._beans) {
            if (bean._bean != object) continue;
            return bean;
        }
        return null;
    }

    @Override
    public boolean removeBean(Object object) {
        Bean bean = this.getBean(object);
        return bean != null && this.remove(bean);
    }

    private boolean remove(Bean bean) {
        if (this._beans.remove(bean)) {
            boolean bl = bean.isManaged();
            this.unmanage(bean);
            for (Container.Listener listener : this._listeners) {
                listener.beanRemoved(this, bean._bean);
            }
            if (bean._bean instanceof Container.Listener) {
                this.removeEventListener((Container.Listener)bean._bean);
            }
            if (bl && bean._bean instanceof LifeCycle) {
                try {
                    this.stop((LifeCycle)bean._bean);
                }
                catch (Error | RuntimeException throwable) {
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeEventListener(Container.Listener listener) {
        if (this._listeners.remove(listener)) {
            for (Bean bean : this._beans) {
                listener.beanRemoved(this, bean._bean);
                if (!(listener instanceof Container.InheritedListener) || !bean.isManaged() || !(bean._bean instanceof Container)) continue;
                ((Container)bean._bean).removeBean(listener);
            }
        }
    }

    @Override
    public void setStopTimeout(long l) {
        super.setStopTimeout(l);
        for (Bean bean : this._beans) {
            if (!bean.isManaged() || !(bean._bean instanceof AbstractLifeCycle)) continue;
            ((AbstractLifeCycle)bean._bean).setStopTimeout(l);
        }
    }

    @ManagedOperation(value="Dump the object to stderr")
    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
        }
        catch (IOException iOException) {
            LOG.warn(iOException);
        }
    }

    @Override
    @ManagedOperation(value="Dump the object to a string")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            dumpable.dump(stringBuilder, "");
        }
        catch (IOException iOException) {
            LOG.warn(iOException);
        }
        return stringBuilder.toString();
    }

    public void dump(Appendable appendable) {
        this.dump(appendable, "");
    }

    protected void dumpThis(Appendable appendable) {
        appendable.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    public static void dumpObject(Appendable appendable, Object object) {
        try {
            if (object instanceof LifeCycle) {
                appendable.append(String.valueOf(object)).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)object)).append("\n");
            } else {
                appendable.append(String.valueOf(object)).append("\n");
            }
        }
        catch (Throwable throwable) {
            appendable.append(" => ").append(throwable.toString()).append('\n');
        }
    }

    @Override
    public void dump(Appendable appendable, String string) {
        this.dumpBeans(appendable, string, new Collection[0]);
    }

    protected void dumpBeans(Appendable appendable, String string, Collection<?> ... collectionArray) {
        this.dumpThis(appendable);
        int n = this._beans.size();
        for (Collection<?> collection : collectionArray) {
            n += collection.size();
        }
        if (n == 0) {
            return;
        }
        int n2 = 0;
        for (Bean bean : this._beans) {
            ++n2;
            switch (bean._managed) {
                case POJO: {
                    appendable.append(string).append(" +- ");
                    if (bean._bean instanceof Dumpable) {
                        ((Dumpable)bean._bean).dump(appendable, string + (n2 == n ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(appendable, bean._bean);
                    break;
                }
                case MANAGED: {
                    appendable.append(string).append(" += ");
                    if (bean._bean instanceof Dumpable) {
                        ((Dumpable)bean._bean).dump(appendable, string + (n2 == n ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(appendable, bean._bean);
                    break;
                }
                case UNMANAGED: {
                    appendable.append(string).append(" +~ ");
                    ContainerLifeCycle.dumpObject(appendable, bean._bean);
                    break;
                }
                case AUTO: {
                    appendable.append(string).append(" +? ");
                    if (bean._bean instanceof Dumpable) {
                        ((Dumpable)bean._bean).dump(appendable, string + (n2 == n ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(appendable, bean._bean);
                }
            }
        }
        if (n2 < n) {
            appendable.append(string).append(" |\n");
        }
        for (Collection<?> collection : collectionArray) {
            for (Object obj : collection) {
                ++n2;
                appendable.append(string).append(" +> ");
                if (obj instanceof Dumpable) {
                    ((Dumpable)obj).dump(appendable, string + (n2 == n ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(appendable, obj);
            }
        }
    }

    public static void dump(Appendable appendable, String string, Collection<?> ... collectionArray) {
        if (collectionArray.length == 0) {
            return;
        }
        int n = 0;
        for (Collection<?> collection : collectionArray) {
            n += collection.size();
        }
        if (n == 0) {
            return;
        }
        int n2 = 0;
        for (Collection<?> collection : collectionArray) {
            for (Object obj : collection) {
                ++n2;
                appendable.append(string).append(" +- ");
                if (obj instanceof Dumpable) {
                    ((Dumpable)obj).dump(appendable, string + (n2 == n ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(appendable, obj);
            }
        }
    }

    public void updateBean(Object object, Object object2) {
        if (object2 != object) {
            if (object != null) {
                this.removeBean(object);
            }
            if (object2 != null) {
                this.addBean(object2);
            }
        }
    }

    public void updateBean(Object object, Object object2, boolean bl) {
        if (object2 != object) {
            if (object != null) {
                this.removeBean(object);
            }
            if (object2 != null) {
                this.addBean(object2, bl);
            }
        }
    }

    public void updateBeans(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            block0: for (Object object : objectArray) {
                if (objectArray2 != null) {
                    for (Object object2 : objectArray2) {
                        if (object == object2) continue block0;
                    }
                }
                this.removeBean(object);
            }
        }
        if (objectArray2 != null) {
            block2: for (Object object : objectArray2) {
                if (objectArray != null) {
                    for (Object object2 : objectArray) {
                        if (object2 == object) continue block2;
                    }
                }
                this.addBean(object);
            }
        }
    }

    private static class Bean {
        private final Object _bean;
        private volatile Managed _managed = Managed.POJO;

        private Bean(Object object) {
            this._bean = object;
        }

        public boolean isManaged() {
            return this._managed == Managed.MANAGED;
        }

        public String toString() {
            return String.format("{%s,%s}", new Object[]{this._bean, this._managed});
        }
    }

    static enum Managed {
        POJO,
        MANAGED,
        UNMANAGED,
        AUTO;

    }
}

