/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class Utf8Appendable {
    protected static final Logger LOG = Log.getLogger(Utf8Appendable.class);
    public static final char REPLACEMENT = '\ufffd';
    public static final byte[] REPLACEMENT_UTF8 = new byte[]{-17, -65, -67};
    private static final int UTF8_ACCEPT = 0;
    private static final int UTF8_REJECT = 12;
    protected final Appendable _appendable;
    protected int _state = 0;
    private static final byte[] BYTE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] TRANS_TABLE = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private int _codep;

    public Utf8Appendable(Appendable appendable) {
        this._appendable = appendable;
    }

    public abstract int length();

    protected void reset() {
        this._state = 0;
    }

    private void checkCharAppend() {
        if (this._state != 0) {
            this._appendable.append('\ufffd');
            int n = this._state;
            this._state = 0;
            throw new NotUtf8Exception("char appended in state " + n);
        }
    }

    public void append(char c) {
        try {
            this.checkCharAppend();
            this._appendable.append(c);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(String string) {
        try {
            this.checkCharAppend();
            this._appendable.append(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(String string, int n, int n2) {
        try {
            this.checkCharAppend();
            this._appendable.append(string, n, n + n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(byte by) {
        try {
            this.appendByte(by);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(ByteBuffer byteBuffer) {
        try {
            while (byteBuffer.remaining() > 0) {
                this.appendByte(byteBuffer.get());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void append(byte[] byArray, int n, int n2) {
        try {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.appendByte(byArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public boolean append(byte[] byArray, int n, int n2, int n3) {
        try {
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                if (this.length() > n3) {
                    return false;
                }
                this.appendByte(byArray[i]);
            }
            return true;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected void appendByte(byte by) {
        if (by > 0 && this._state == 0) {
            this._appendable.append((char)(by & 0xFF));
        } else {
            int n = by & 0xFF;
            byte by2 = BYTE_TABLE[n];
            this._codep = this._state == 0 ? 255 >> by2 & n : n & 0x3F | this._codep << 6;
            int n2 = TRANS_TABLE[this._state + by2];
            switch (n2) {
                case 0: {
                    this._state = n2;
                    if (this._codep < 55296) {
                        this._appendable.append((char)this._codep);
                        break;
                    }
                    for (char c : Character.toChars(this._codep)) {
                        this._appendable.append(c);
                    }
                    break;
                }
                case 12: {
                    String string = "byte " + TypeUtil.toHexString(by) + " in state " + this._state / 12;
                    this._codep = 0;
                    this._state = 0;
                    this._appendable.append('\ufffd');
                    throw new NotUtf8Exception(string);
                }
                default: {
                    this._state = n2;
                }
            }
        }
    }

    public boolean isUtf8SequenceComplete() {
        return this._state == 0;
    }

    protected void checkState() {
        if (!this.isUtf8SequenceComplete()) {
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            throw new NotUtf8Exception("incomplete UTF8 sequence");
        }
    }

    public String toReplacedString() {
        if (!this.isUtf8SequenceComplete()) {
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            NotUtf8Exception notUtf8Exception = new NotUtf8Exception("incomplete UTF8 sequence");
            LOG.warn(notUtf8Exception.toString(), new Object[0]);
            LOG.debug(notUtf8Exception);
        }
        return this._appendable.toString();
    }

    public static class NotUtf8Exception
    extends IllegalArgumentException {
        public NotUtf8Exception(String string) {
            super("Not valid UTF8! " + string);
        }
    }
}

