/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class URIUtil
implements Cloneable {
    private static final Logger LOG = Log.getLogger(URIUtil.class);
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTP_COLON = "http:";
    public static final String HTTPS = "https";
    public static final String HTTPS_COLON = "https:";
    public static final Charset __CHARSET = StandardCharsets.UTF_8;

    private URIUtil() {
    }

    public static String encodePath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = URIUtil.encodePath(null, string);
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static StringBuilder encodePath(StringBuilder stringBuilder, String string) {
        int n;
        byte[] byArray = null;
        if (stringBuilder == null) {
            block29: for (n = 0; n < string.length(); ++n) {
                char by = string.charAt(n);
                switch (by) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case ']': {
                        stringBuilder = new StringBuilder(string.length() * 2);
                        break block29;
                    }
                    default: {
                        if (by <= '\u007f') continue block29;
                        byArray = string.getBytes(__CHARSET);
                        stringBuilder = new StringBuilder(string.length() * 2);
                        break block29;
                    }
                }
            }
            if (stringBuilder == null) {
                return null;
            }
        }
        if (byArray != null) {
            block30: for (n = 0; n < byArray.length; ++n) {
                void var4_5 = byArray[n];
                switch (var4_5) {
                    case 37: {
                        stringBuilder.append("%25");
                        continue block30;
                    }
                    case 63: {
                        stringBuilder.append("%3F");
                        continue block30;
                    }
                    case 59: {
                        stringBuilder.append("%3B");
                        continue block30;
                    }
                    case 35: {
                        stringBuilder.append("%23");
                        continue block30;
                    }
                    case 34: {
                        stringBuilder.append("%22");
                        continue block30;
                    }
                    case 39: {
                        stringBuilder.append("%27");
                        continue block30;
                    }
                    case 60: {
                        stringBuilder.append("%3C");
                        continue block30;
                    }
                    case 62: {
                        stringBuilder.append("%3E");
                        continue block30;
                    }
                    case 32: {
                        stringBuilder.append("%20");
                        continue block30;
                    }
                    case 91: {
                        stringBuilder.append("%5B");
                        continue block30;
                    }
                    case 93: {
                        stringBuilder.append("%5D");
                        continue block30;
                    }
                    default: {
                        if (var4_5 < 0) {
                            stringBuilder.append('%');
                            TypeUtil.toHex((byte)var4_5, (Appendable)stringBuilder);
                            continue block30;
                        }
                        stringBuilder.append((char)var4_5);
                        continue block30;
                    }
                }
            }
        } else {
            block31: for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '%': {
                        stringBuilder.append("%25");
                        continue block31;
                    }
                    case '?': {
                        stringBuilder.append("%3F");
                        continue block31;
                    }
                    case ';': {
                        stringBuilder.append("%3B");
                        continue block31;
                    }
                    case '#': {
                        stringBuilder.append("%23");
                        continue block31;
                    }
                    case '\"': {
                        stringBuilder.append("%22");
                        continue block31;
                    }
                    case '\'': {
                        stringBuilder.append("%27");
                        continue block31;
                    }
                    case '<': {
                        stringBuilder.append("%3C");
                        continue block31;
                    }
                    case '>': {
                        stringBuilder.append("%3E");
                        continue block31;
                    }
                    case ' ': {
                        stringBuilder.append("%20");
                        continue block31;
                    }
                    case '[': {
                        stringBuilder.append("%5B");
                        continue block31;
                    }
                    case ']': {
                        stringBuilder.append("%5D");
                        continue block31;
                    }
                    default: {
                        stringBuilder.append(c);
                        continue block31;
                    }
                }
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodeString(StringBuilder stringBuilder, String string, String string2) {
        int n;
        if (stringBuilder == null) {
            for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                if (n != 37 && string2.indexOf(n) < 0) continue;
                stringBuilder = new StringBuilder(string.length() << 1);
                break;
            }
            if (stringBuilder == null) {
                return null;
            }
        }
        StringBuilder stringBuilder2 = stringBuilder;
        synchronized (stringBuilder2) {
            for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                if (c == '%' || string2.indexOf(c) >= 0) {
                    stringBuilder.append('%');
                    StringUtil.append(stringBuilder, (byte)(0xFF & c), 16);
                    continue;
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder;
    }

    public static String decodePath(String string) {
        return URIUtil.decodePath(string, 0, string.length());
    }

    public static String decodePath(String string, int n, int n2) {
        try {
            Utf8StringBuilder utf8StringBuilder = null;
            int n3 = n + n2;
            block6: for (int i = n; i < n3; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '%': {
                        if (utf8StringBuilder == null) {
                            utf8StringBuilder = new Utf8StringBuilder(string.length());
                            utf8StringBuilder.append(string, n, i - n);
                        }
                        if (i + 2 < n3) {
                            char c2 = string.charAt(i + 1);
                            if (c2 == 'u') {
                                utf8StringBuilder.append((char)(0xFFFF & TypeUtil.parseInt(string, i + 2, 4, 16)));
                                i += 5;
                                continue block6;
                            }
                            utf8StringBuilder.append((byte)(0xFF & TypeUtil.convertHexDigit(c2) * 16 + TypeUtil.convertHexDigit(string.charAt(i + 2))));
                            i += 2;
                            continue block6;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (utf8StringBuilder == null) {
                            utf8StringBuilder = new Utf8StringBuilder(string.length());
                            utf8StringBuilder.append(string, n, i - n);
                        }
                        while (++i < n3) {
                            if (string.charAt(i) != '/') continue;
                            utf8StringBuilder.append('/');
                            continue block6;
                        }
                        continue block6;
                    }
                    default: {
                        if (utf8StringBuilder == null) continue block6;
                        utf8StringBuilder.append(c);
                    }
                }
            }
            if (utf8StringBuilder != null) {
                return utf8StringBuilder.toString();
            }
            if (n == 0 && n2 == string.length()) {
                return string;
            }
            return string.substring(n, n3);
        }
        catch (Utf8Appendable.NotUtf8Exception notUtf8Exception) {
            LOG.warn(string.substring(n, n + n2) + " " + notUtf8Exception, new Object[0]);
            LOG.debug(notUtf8Exception);
            return URIUtil.decodeISO88591Path(string, n, n2);
        }
    }

    private static String decodeISO88591Path(String string, int n, int n2) {
        StringBuilder stringBuilder = null;
        int n3 = n + n2;
        block4: for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string, n, i - n);
                    }
                    if (i + 2 < n3) {
                        char c2 = string.charAt(i + 1);
                        if (c2 == 'u') {
                            stringBuilder.append((char)(0xFFFF & TypeUtil.parseInt(string, i + 2, 4, 16)));
                            i += 5;
                            continue block4;
                        }
                        stringBuilder.append((byte)(0xFF & TypeUtil.convertHexDigit(c2) * 16 + TypeUtil.convertHexDigit(string.charAt(i + 2))));
                        i += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string, n, i - n);
                    }
                    while (++i < n3) {
                        if (string.charAt(i) != '/') continue;
                        stringBuilder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    if (stringBuilder == null) continue block4;
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        if (n == 0 && n2 == string.length()) {
            return string;
        }
        return string.substring(n, n3);
    }

    public static String addPaths(String string, String string2) {
        if (string == null || string.length() == 0) {
            if (string != null && string2 == null) {
                return string;
            }
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            n = string.indexOf(63);
        }
        if (n == 0) {
            return string2 + string;
        }
        if (n < 0) {
            n = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 2);
        stringBuilder.append(string);
        if (stringBuilder.charAt(n - 1) == '/') {
            if (string2.startsWith(SLASH)) {
                stringBuilder.deleteCharAt(n - 1);
                stringBuilder.insert(n - 1, string2);
            } else {
                stringBuilder.insert(n, string2);
            }
        } else if (string2.startsWith(SLASH)) {
            stringBuilder.insert(n, string2);
        } else {
            stringBuilder.insert(n, '/');
            stringBuilder.insert(n + 1, string2);
        }
        return stringBuilder.toString();
    }

    public static String parentPath(String string) {
        if (string == null || SLASH.equals(string)) {
            return null;
        }
        int n = string.lastIndexOf(47, string.length() - 2);
        if (n >= 0) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.length();
        int n2 = string.lastIndexOf(47, n);
        block8: while (n > 0) {
            switch (n - n2) {
                case 2: {
                    if (string.charAt(n2 + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (string.charAt(n2 + 1) == '.' && string.charAt(n2 + 2) == '.') break block8;
                }
            }
            n = n2;
            n2 = string.lastIndexOf(47, n - 1);
        }
        if (n2 >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        block9: while (n > 0) {
            switch (n - n2) {
                case 2: {
                    if (stringBuilder.charAt(n2 + 1) != '.') {
                        if (n5 <= 0 || --n5 != 0) break;
                        int n6 = n3 = n2 >= 0 ? n2 : 0;
                        if (n3 <= 0 || n4 != stringBuilder.length() || stringBuilder.charAt(n4 - 1) != '.') break;
                        ++n3;
                        break;
                    }
                    if (n2 < 0 && stringBuilder.length() > 2 && stringBuilder.charAt(1) == '/' && stringBuilder.charAt(2) == '/') break;
                    if (n4 < 0) {
                        n4 = n;
                    }
                    if ((n3 = n2) < 0 || n3 == 0 && stringBuilder.charAt(n3) == '/') {
                        ++n3;
                        if (n4 >= stringBuilder.length() || stringBuilder.charAt(n4) != '/') break;
                        ++n4;
                        break;
                    }
                    if (n == stringBuilder.length()) {
                        ++n3;
                    }
                    n = n2--;
                    while (n2 >= 0 && stringBuilder.charAt(n2) != '/') {
                        --n2;
                    }
                    continue block9;
                }
                case 3: {
                    if (stringBuilder.charAt(n2 + 1) != '.' || stringBuilder.charAt(n2 + 2) != '.') {
                        if (n5 <= 0 || --n5 != 0) break;
                        int n7 = n3 = n2 >= 0 ? n2 : 0;
                        if (n3 <= 0 || n4 != stringBuilder.length() || stringBuilder.charAt(n4 - 1) != '.') break;
                        ++n3;
                        break;
                    }
                    n3 = n2;
                    if (n4 < 0) {
                        n4 = n;
                    }
                    ++n5;
                    n = n2--;
                    while (n2 >= 0 && stringBuilder.charAt(n2) != '/') {
                        --n2;
                    }
                    continue block9;
                }
                default: {
                    if (n5 <= 0 || --n5 != 0) break;
                    int n8 = n3 = n2 >= 0 ? n2 : 0;
                    if (n4 != stringBuilder.length() || stringBuilder.charAt(n4 - 1) != '.') break;
                    ++n3;
                }
            }
            if (n5 <= 0 && n3 >= 0 && n4 >= n3) {
                stringBuilder.delete(n3, n4);
                n4 = -1;
                n3 = -1;
                if (n5 > 0) {
                    n4 = n;
                }
            }
            n = n2--;
            while (n2 >= 0 && stringBuilder.charAt(n2) != '/') {
                --n2;
            }
        }
        if (n5 > 0) {
            return null;
        }
        if (n4 >= 0) {
            stringBuilder.delete(n3, n4);
        }
        return stringBuilder.toString();
    }

    public static String compactPath(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        block8: for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '?': {
                    return string;
                }
                case '/': {
                    if (++n2 != 2) continue block8;
                    break block8;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        if (n2 < 2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string, 0, n);
        block9: while (n < n3) {
            char c = string.charAt(n);
            switch (c) {
                case '?': {
                    stringBuffer.append(string, n, n3);
                    break block9;
                }
                case '/': {
                    if (n2++ != 0) break;
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    n2 = 0;
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean hasScheme(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }

    public static String newURI(String string, String string2, int n, String string3, String string4) {
        StringBuilder stringBuilder = URIUtil.newURIBuilder(string, string2, n);
        stringBuilder.append(string3);
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append('?').append(string4);
        }
        return stringBuilder.toString();
    }

    public static StringBuilder newURIBuilder(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        URIUtil.appendSchemeHostPort(stringBuilder, string, string2, n);
        return stringBuilder;
    }

    public static void appendSchemeHostPort(StringBuilder stringBuilder, String string, String string2, int n) {
        if (string2.indexOf(58) >= 0 && string2.charAt(0) != '[') {
            stringBuilder.append(string).append("://").append('[').append(string2).append(']');
        } else {
            stringBuilder.append(string).append("://").append(string2);
        }
        if (n > 0) {
            switch (string) {
                case "http": {
                    if (n == 80) break;
                    stringBuilder.append(':').append(n);
                    break;
                }
                case "https": {
                    if (n == 443) break;
                    stringBuilder.append(':').append(n);
                    break;
                }
                default: {
                    stringBuilder.append(':').append(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer stringBuffer, String string, String string2, int n) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            if (string2.indexOf(58) >= 0 && string2.charAt(0) != '[') {
                stringBuffer.append(string).append("://").append('[').append(string2).append(']');
            } else {
                stringBuffer.append(string).append("://").append(string2);
            }
            if (n > 0) {
                switch (string) {
                    case "http": {
                        if (n == 80) break;
                        stringBuffer.append(':').append(n);
                        break;
                    }
                    case "https": {
                        if (n == 443) break;
                        stringBuffer.append(':').append(n);
                        break;
                    }
                    default: {
                        stringBuffer.append(':').append(n);
                    }
                }
            }
        }
    }

    public static boolean equalsIgnoreEncodings(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            int n5;
            int n6;
            int n7;
            int n8;
            if ((n8 = (n7 = string.charAt(n3++))) == 37) {
                n8 = TypeUtil.convertHexDigit(string.charAt(n3++)) * 16 + TypeUtil.convertHexDigit(string.charAt(n3++));
            }
            if ((n6 = (n5 = string2.charAt(n4++))) == 37) {
                n6 = TypeUtil.convertHexDigit(string2.charAt(n4++)) * 16 + TypeUtil.convertHexDigit(string2.charAt(n4++));
            }
            if (n8 == 47 && n7 != n5) {
                return false;
            }
            if (n8 == n6) continue;
            return URIUtil.decodePath(string).equals(URIUtil.decodePath(string2));
        }
        return n3 == n && n4 == n2;
    }
}

