/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class TypeUtil {
    private static final Logger LOG = Log.getLogger(TypeUtil.class);
    public static final Class<?>[] NO_ARGS = new Class[0];
    public static final int CR = 13;
    public static final int LF = 10;
    private static final HashMap<String, Class<?>> name2Class = new HashMap();
    private static final HashMap<Class<?>, String> class2Name;
    private static final HashMap<Class<?>, Method> class2Value;

    public static <T> List<T> asList(T[] TArray) {
        if (TArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(TArray);
    }

    public static Class<?> fromName(String string) {
        return name2Class.get(string);
    }

    public static String toName(Class<?> clazz) {
        return class2Name.get(clazz);
    }

    public static Object valueOf(Class<?> clazz, String string) {
        try {
            if (clazz.equals(String.class)) {
                return string;
            }
            Method method = class2Value.get(clazz);
            if (method != null) {
                return method.invoke(null, string);
            }
            if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
                return Character.valueOf(string.charAt(0));
            }
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(string);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException reflectiveOperationException) {
            LOG.ignore(reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            LOG.ignore(invocationTargetException);
        }
        return null;
    }

    public static Object valueOf(String string, String string2) {
        return TypeUtil.valueOf(TypeUtil.fromName(string), string2);
    }

    public static int parseInt(String string, int n, int n2, int n3) {
        int n4 = 0;
        if (n2 < 0) {
            n2 = string.length() - n;
        }
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            int n5 = TypeUtil.convertHexDigit((int)c);
            if (n5 < 0 || n5 >= n3) {
                throw new NumberFormatException(string.substring(n, n + n2));
            }
            n4 = n4 * n3 + n5;
        }
        return n4;
    }

    public static int parseInt(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        if (n2 < 0) {
            n2 = byArray.length - n;
        }
        for (int i = 0; i < n2; ++i) {
            char c = (char)(0xFF & byArray[n + i]);
            int n5 = c - 48;
            if (!(n5 >= 0 && n5 < n3 && n5 < 10 || (n5 = 10 + c - 65) >= 10 && n5 < n3)) {
                n5 = 10 + c - 97;
            }
            if (n5 < 0 || n5 >= n3) {
                throw new NumberFormatException(new String(byArray, n, n2));
            }
            n4 = n4 * n3 + n5;
        }
        return n4;
    }

    public static byte[] parseBytes(String string, int n) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i / 2] = (byte)TypeUtil.parseInt(string, i, 2, n);
        }
        return byArray;
    }

    public static String toString(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            int n2 = 0xFF & by;
            int n3 = 48 + n2 / n % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuilder.append((char)n3);
            n3 = 48 + n2 % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder.toString();
    }

    public static byte convertHexDigit(byte by) {
        byte by2 = (byte)((by & 0x1F) + (by >> 6) * 25 - 16);
        if (by2 < 0 || by2 > 15) {
            throw new NumberFormatException("!hex " + by);
        }
        return by2;
    }

    public static int convertHexDigit(char c) {
        int n = (c & 0x1F) + (c >> 6) * 25 - 16;
        if (n < 0 || n > 15) {
            throw new NumberFormatException("!hex " + c);
        }
        return n;
    }

    public static int convertHexDigit(int n) {
        int n2 = (n & 0x1F) + (n >> 6) * 25 - 16;
        if (n2 < 0 || n2 > 15) {
            throw new NumberFormatException("!hex " + n);
        }
        return n2;
    }

    public static void toHex(byte by, Appendable appendable) {
        try {
            int n = 0xF & (0xF0 & by) >> 4;
            appendable.append((char)((n > 9 ? 55 : 48) + n));
            n = 0xF & by;
            appendable.append((char)((n > 9 ? 55 : 48) + n));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void toHex(int n, Appendable appendable) {
        int n2 = 0xF & (0xF0000000 & n) >> 28;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF000000 & n) >> 24;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF00000 & n) >> 20;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF0000 & n) >> 16;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF000 & n) >> 12;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF00 & n) >> 8;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & (0xF0 & n) >> 4;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        n2 = 0xF & n;
        appendable.append((char)((n2 > 9 ? 55 : 48) + n2));
        Integer.toString(0, 36);
    }

    public static void toHex(long l, Appendable appendable) {
        TypeUtil.toHex((int)(l >> 32), appendable);
        TypeUtil.toHex((int)l, appendable);
    }

    public static String toHexString(byte by) {
        return TypeUtil.toHexString(new byte[]{by}, 0, 1);
    }

    public static String toHexString(byte[] byArray) {
        return TypeUtil.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2; ++i) {
            int n3 = 0xFF & byArray[i];
            int n4 = 48 + n3 / 16 % 16;
            if (n4 > 57) {
                n4 = 65 + (n4 - 48 - 10);
            }
            stringBuilder.append((char)n4);
            n4 = 48 + n3 % 16;
            if (n4 > 57) {
                n4 = 97 + (n4 - 48 - 10);
            }
            stringBuilder.append((char)n4);
        }
        return stringBuilder.toString();
    }

    public static byte[] fromHexString(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException(string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
            byArray[i] = (byte)(0xFF & n);
        }
        return byArray;
    }

    public static void dump(Class<?> clazz) {
        System.err.println("Dump: " + clazz);
        TypeUtil.dump(clazz.getClassLoader());
    }

    public static void dump(ClassLoader classLoader) {
        System.err.println("Dump Loaders:");
        while (classLoader != null) {
            System.err.println("  loader " + classLoader);
            classLoader = classLoader.getParent();
        }
    }

    public static Object call(Class<?> clazz, String string, Object object, Object[] objectArray) {
        Objects.requireNonNull(clazz, "Class cannot be null");
        Objects.requireNonNull(string, "Method name cannot be null");
        if (StringUtil.isBlank(string)) {
            throw new IllegalArgumentException("Method name cannot be blank");
        }
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string) || method.getParameterTypes().length != objectArray.length || Modifier.isStatic(method.getModifiers()) != (object == null) || object == null && method.getDeclaringClass() != clazz) continue;
            try {
                return method.invoke(object, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                LOG.ignore(exception);
            }
        }
        Object[] objectArray2 = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string) || method.getParameterTypes().length != objectArray.length + 1 || !method.getParameterTypes()[objectArray.length].isArray() || Modifier.isStatic(method.getModifiers()) != (object == null) || object == null && method.getDeclaringClass() != clazz) continue;
            if (objectArray2 == null) {
                objectArray2 = ArrayUtil.addToArray(objectArray, new Object[0], Object.class);
            }
            try {
                return method.invoke(object, objectArray2);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                LOG.ignore(exception);
            }
        }
        throw new NoSuchMethodException(string);
    }

    public static Object construct(Class<?> clazz, Object[] objectArray) {
        Objects.requireNonNull(clazz, "Class cannot be null");
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (objectArray == null ? constructor.getParameterTypes().length != 0 : constructor.getParameterTypes().length != objectArray.length) continue;
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException exception) {
                LOG.ignore(exception);
            }
        }
        throw new NoSuchMethodException("<init>");
    }

    public static Object construct(Class<?> clazz, Object[] objectArray, Map<String, Object> map) {
        Objects.requireNonNull(clazz, "Class cannot be null");
        Objects.requireNonNull(map, "Named Argument Map cannot be null");
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (objectArray == null ? constructor.getParameterTypes().length != 0 : constructor.getParameterTypes().length != objectArray.length) continue;
            try {
                Annotation[][] annotationArray = constructor.getParameterAnnotations();
                if (objectArray == null || objectArray.length == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Constructor has no arguments", new Object[0]);
                    }
                    return constructor.newInstance(objectArray);
                }
                if (annotationArray == null || annotationArray.length == 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Constructor has no parameter annotations", new Object[0]);
                    }
                    return constructor.newInstance(objectArray);
                }
                Object[] objectArray2 = new Object[objectArray.length];
                int n = 0;
                Annotation[][] annotationArray2 = annotationArray;
                int n2 = annotationArray2.length;
                for (int i = 0; i < n2; ++i) {
                    Annotation[] annotationArray3;
                    for (Annotation annotation : annotationArray3 = annotationArray2[i]) {
                        if (annotation instanceof Name) {
                            Name name = (Name)annotation;
                            if (map.containsKey(name.value())) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("placing named {} in position {}", name.value(), n);
                                }
                                objectArray2[n] = map.get(name.value());
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("placing {} in position {}", objectArray[n], n);
                                }
                                objectArray2[n] = objectArray[n];
                            }
                            ++n;
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("passing on annotation {}", annotation);
                    }
                }
                return constructor.newInstance(objectArray2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException exception) {
                LOG.ignore(exception);
            }
        }
        throw new NoSuchMethodException("<init>");
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.parseBoolean(object.toString());
    }

    public static boolean isFalse(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        return "false".equalsIgnoreCase(object.toString());
    }

    static {
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        class2Name.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            Class[] classArray = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", classArray));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", classArray));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", classArray));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", classArray));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", classArray));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", classArray));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", classArray));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", classArray));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", classArray));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", classArray));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", classArray));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", classArray));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", classArray));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", classArray));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

