/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;

public class TreeTrie<V>
extends AbstractTrie<V> {
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private static final int INDEX = 32;
    private final TreeTrie<V>[] _nextIndex;
    private final List<TreeTrie<V>> _nextOther = new ArrayList<TreeTrie<V>>();
    private final char _c;
    private String _key;
    private V _value;

    public TreeTrie() {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = '\u0000';
    }

    private TreeTrie(char c) {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = c;
    }

    @Override
    public void clear() {
        Arrays.fill(this._nextIndex, null);
        this._nextOther.clear();
        this._key = null;
        this._value = null;
    }

    @Override
    public boolean put(String string, V v) {
        TreeTrie<V> treeTrie = this;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            int n3 = n2 = c >= '\u0000' && c < '\u007f' ? __lookup[c] : -1;
            if (n2 >= 0) {
                if (treeTrie._nextIndex[n2] == null) {
                    treeTrie._nextIndex[n2] = new TreeTrie<V>(c);
                }
                treeTrie = treeTrie._nextIndex[n2];
                continue;
            }
            TreeTrie<V> treeTrie2 = null;
            int n4 = treeTrie._nextOther.size();
            while (n4-- > 0) {
                treeTrie2 = treeTrie._nextOther.get(n4);
                if (treeTrie2._c == c) break;
                treeTrie2 = null;
            }
            if (treeTrie2 == null) {
                treeTrie2 = new TreeTrie<V>(c);
                treeTrie._nextOther.add(treeTrie2);
            }
            treeTrie = treeTrie2;
        }
        treeTrie._key = v == null ? null : string;
        treeTrie._value = v;
        return true;
    }

    @Override
    public V get(String string, int n, int n2) {
        TreeTrie<V> treeTrie = this;
        for (int i = 0; i < n2; ++i) {
            int n3;
            char c = string.charAt(n + i);
            int n4 = n3 = c >= '\u0000' && c < '\u007f' ? __lookup[c] : -1;
            if (n3 >= 0) {
                if (treeTrie._nextIndex[n3] == null) {
                    return null;
                }
                treeTrie = treeTrie._nextIndex[n3];
                continue;
            }
            TreeTrie<V> treeTrie2 = null;
            int n5 = treeTrie._nextOther.size();
            while (n5-- > 0) {
                treeTrie2 = treeTrie._nextOther.get(n5);
                if (treeTrie2._c == c) break;
                treeTrie2 = null;
            }
            if (treeTrie2 == null) {
                return null;
            }
            treeTrie = treeTrie2;
        }
        return treeTrie._value;
    }

    @Override
    public V get(ByteBuffer byteBuffer, int n, int n2) {
        TreeTrie<V> treeTrie = this;
        for (int i = 0; i < n2; ++i) {
            int n3;
            byte by = byteBuffer.get(n + i);
            int n4 = n3 = by >= 0 && by < 127 ? __lookup[by] : -1;
            if (n3 >= 0) {
                if (treeTrie._nextIndex[n3] == null) {
                    return null;
                }
                treeTrie = treeTrie._nextIndex[n3];
                continue;
            }
            TreeTrie<V> treeTrie2 = null;
            int n5 = treeTrie._nextOther.size();
            while (n5-- > 0) {
                treeTrie2 = treeTrie._nextOther.get(n5);
                if (treeTrie2._c == by) break;
                treeTrie2 = null;
            }
            if (treeTrie2 == null) {
                return null;
            }
            treeTrie = treeTrie2;
        }
        return treeTrie._value;
    }

    @Override
    public V getBest(byte[] byArray, int n, int n2) {
        TreeTrie<V> treeTrie = this;
        for (int i = 0; i < n2; ++i) {
            TreeTrie<V> treeTrie2;
            int n3;
            byte by = byArray[n + i];
            int n4 = n3 = by >= 0 && by < 127 ? __lookup[by] : -1;
            if (n3 >= 0) {
                if (treeTrie._nextIndex[n3] == null) break;
                treeTrie = treeTrie._nextIndex[n3];
            } else {
                treeTrie2 = null;
                int n5 = treeTrie._nextOther.size();
                while (n5-- > 0) {
                    treeTrie2 = treeTrie._nextOther.get(n5);
                    if (treeTrie2._c == by) break;
                    treeTrie2 = null;
                }
                if (treeTrie2 == null) break;
                treeTrie = treeTrie2;
            }
            if (treeTrie._key == null) continue;
            treeTrie2 = treeTrie.getBest(byArray, n + i + 1, n2 - i - 1);
            if (treeTrie2 == null) break;
            return (V)treeTrie2;
        }
        return treeTrie._value;
    }

    @Override
    public V getBest(String string, int n, int n2) {
        TreeTrie<V> treeTrie = this;
        for (int i = 0; i < n2; ++i) {
            TreeTrie<V> treeTrie2;
            int n3;
            byte by = (byte)(0xFF & string.charAt(n + i));
            int n4 = n3 = by >= 0 && by < 127 ? __lookup[by] : -1;
            if (n3 >= 0) {
                if (treeTrie._nextIndex[n3] == null) break;
                treeTrie = treeTrie._nextIndex[n3];
            } else {
                treeTrie2 = null;
                int n5 = treeTrie._nextOther.size();
                while (n5-- > 0) {
                    treeTrie2 = treeTrie._nextOther.get(n5);
                    if (treeTrie2._c == by) break;
                    treeTrie2 = null;
                }
                if (treeTrie2 == null) break;
                treeTrie = treeTrie2;
            }
            if (treeTrie._key == null) continue;
            treeTrie2 = treeTrie.getBest(string, n + i + 1, n2 - i - 1);
            if (treeTrie2 == null) break;
            return (V)treeTrie2;
        }
        return treeTrie._value;
    }

    @Override
    public V getBest(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer.hasArray()) {
            return this.getBest(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n, n2);
        }
        return this.getBestByteBuffer(byteBuffer, n, n2);
    }

    private V getBestByteBuffer(ByteBuffer byteBuffer, int n, int n2) {
        TreeTrie<V> treeTrie = this;
        int n3 = byteBuffer.position() + n;
        for (int i = 0; i < n2; ++i) {
            TreeTrie<V> treeTrie2;
            byte by;
            int n4;
            int n5 = n4 = (by = byteBuffer.get(n3++)) >= 0 && by < 127 ? __lookup[by] : -1;
            if (n4 >= 0) {
                if (treeTrie._nextIndex[n4] == null) break;
                treeTrie = treeTrie._nextIndex[n4];
            } else {
                treeTrie2 = null;
                int n6 = treeTrie._nextOther.size();
                while (n6-- > 0) {
                    treeTrie2 = treeTrie._nextOther.get(n6);
                    if (treeTrie2._c == by) break;
                    treeTrie2 = null;
                }
                if (treeTrie2 == null) break;
                treeTrie = treeTrie2;
            }
            if (treeTrie._key == null) continue;
            treeTrie2 = treeTrie.getBest(byteBuffer, n + i + 1, n2 - i - 1);
            if (treeTrie2 == null) break;
            return (V)treeTrie2;
        }
        return treeTrie._value;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        TreeTrie.toString(stringBuilder, this);
        if (stringBuilder.length() == 0) {
            return "{}";
        }
        stringBuilder.setCharAt(0, '{');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static <V> void toString(Appendable appendable, TreeTrie<V> treeTrie) {
        if (treeTrie != null) {
            int n;
            if (treeTrie._value != null) {
                try {
                    appendable.append(',');
                    appendable.append(treeTrie._key);
                    appendable.append('=');
                    appendable.append(treeTrie._value.toString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            for (n = 0; n < 32; ++n) {
                if (treeTrie._nextIndex[n] == null) continue;
                TreeTrie.toString(appendable, treeTrie._nextIndex[n]);
            }
            n = treeTrie._nextOther.size();
            while (n-- > 0) {
                TreeTrie.toString(appendable, treeTrie._nextOther.get(n));
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        TreeTrie.keySet(hashSet, this);
        return hashSet;
    }

    private static <V> void keySet(Set<String> set, TreeTrie<V> treeTrie) {
        if (treeTrie != null) {
            int n;
            if (treeTrie._key != null) {
                set.add(treeTrie._key);
            }
            for (n = 0; n < 32; ++n) {
                if (treeTrie._nextIndex[n] == null) continue;
                TreeTrie.keySet(set, treeTrie._nextIndex[n]);
            }
            n = treeTrie._nextOther.size();
            while (n-- > 0) {
                TreeTrie.keySet(set, treeTrie._nextOther.get(n));
            }
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }
}

